/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ImmutableLifecycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLifecycleListener<EVENTTYPE extends EventObject, LISTENERTYPE extends ILifecycleListener<EVENTTYPE>, LIFECYCLEOBJECT>
extends ImmutableLifecycleListener<LISTENERTYPE> {
    protected static final String CANNOT_ADD_NULL_RESOURCE = "Cannot add null object";
    static final boolean TRACE_EVENTS = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsf.common/debug/lifecyclelistener")) != false || Boolean.valueOf(System.getProperty("org.eclipse.jst.jsf.common/debug/lifecyclelistener")) != false;
    private final CopyOnWriteArrayList<LISTENERTYPE> _listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<LIFECYCLEOBJECT> _lifecycleObjects = new CopyOnWriteArrayList();
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);

    @Override
    public void addListener(LISTENERTYPE listener) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        if (listener == null) {
            throw new NullPointerException("Cannot pass null listener");
        }
        this._listeners.addIfAbsent(listener);
    }

    @Override
    public void removeListener(LISTENERTYPE listener) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this._listeners.remove(listener);
    }

    protected void fireLifecycleEvent(EVENTTYPE event) {
        boolean disposeAfter = false;
        if (TRACE_EVENTS) {
            System.err.println(event);
        }
        for (ILifecycleListener listener : this._listeners) {
            EventResult result = listener.acceptEvent(event);
            disposeAfter |= result.getDisposeAfterEvent();
        }
        if (disposeAfter) {
            this.dispose();
        }
    }

    public boolean isDisposed() {
        return this._isDisposed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            CopyOnWriteArrayList<LIFECYCLEOBJECT> copyOnWriteArrayList = this._lifecycleObjects;
            synchronized (copyOnWriteArrayList) {
                this.removeSystemChangeListener();
                this._lifecycleObjects.clear();
                this.doDispose();
            }
        }
    }

    protected void doDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLifecycleObject(LIFECYCLEOBJECT object) {
        if (object == null) {
            throw new NullPointerException(CANNOT_ADD_NULL_RESOURCE);
        }
        CopyOnWriteArrayList<LIFECYCLEOBJECT> copyOnWriteArrayList = this._lifecycleObjects;
        synchronized (copyOnWriteArrayList) {
            if (this.isDisposed()) {
                return;
            }
            int preSize = this._lifecycleObjects.size();
            if (!this._lifecycleObjects.contains(object)) {
                this._lifecycleObjects.add(object);
            }
            if (preSize == 0 && this._lifecycleObjects.size() > 0) {
                this.addSystemChangeListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(IResource res) {
        CopyOnWriteArrayList<LIFECYCLEOBJECT> copyOnWriteArrayList = this._lifecycleObjects;
        synchronized (copyOnWriteArrayList) {
            if (this.isDisposed()) {
                return;
            }
            this._lifecycleObjects.remove(res);
            if (this._lifecycleObjects.size() == 0) {
                this.removeSystemChangeListener();
            }
        }
    }

    protected Collection<LIFECYCLEOBJECT> getLifecycleObjects() {
        return Collections.unmodifiableCollection(this._lifecycleObjects);
    }

    protected abstract void addSystemChangeListener();

    protected abstract void removeSystemChangeListener();
}

