/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Scm;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.IMavenToolbox;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.project.AbstractProjectScanner;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectPomScanner<T>
extends AbstractProjectScanner<MavenProjectScmInfo> {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectPomScanner.class);
    private final boolean developer;
    private final List<Dependency> dependencies;
    private final IMaven maven;

    public MavenProjectPomScanner(boolean developer, List<Dependency> dependencies) {
        this.developer = developer;
        this.dependencies = dependencies;
        this.maven = MavenPlugin.getMaven();
    }

    public String getDescription() {
        if (this.dependencies.size() == 1) {
            Dependency d = this.dependencies.get(0);
            return String.valueOf(d.getGroupId()) + ":" + d.getArtifactId() + ":" + d.getVersion() + (d.getClassifier() == null ? "" : ":" + d.getClassifier());
        }
        return this.dependencies.size() + " projects";
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        for (Dependency d : this.dependencies) {
            String msg;
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            try {
                int n;
                String connection;
                Model model = this.resolveModel(d.getGroupId(), d.getArtifactId(), d.getVersion(), monitor);
                if (model == null) {
                    msg = "Can't resolve " + d.getArtifactId();
                    Exception error = new Exception(msg);
                    log.error(msg, (Throwable)error);
                    this.addError(error);
                    continue;
                }
                Scm scm = this.resolveScm(model, monitor);
                if (scm == null) {
                    String msg2 = "No SCM info for " + d.getArtifactId();
                    Exception error = new Exception(msg2);
                    log.error(msg2, (Throwable)error);
                    this.addError(error);
                    continue;
                }
                String tag = scm.getTag();
                log.info(d.getArtifactId());
                log.info("Connection: {}", (Object)scm.getConnection());
                log.info("       dev: {}", (Object)scm.getDeveloperConnection());
                log.info("       url: {}", (Object)scm.getUrl());
                log.info("       tag: {}", (Object)tag);
                if (this.developer) {
                    connection = scm.getDeveloperConnection();
                    if (connection == null) {
                        String msg3 = String.valueOf(d.getArtifactId()) + " doesn't specify developer SCM connection";
                        error = new Exception(msg3);
                        log.error(msg3, (Throwable)error);
                        this.addError(error);
                        continue;
                    }
                } else {
                    connection = scm.getConnection();
                    if (connection == null) {
                        String msg4 = String.valueOf(d.getArtifactId()) + " doesn't specify SCM connection";
                        error = new Exception(msg4);
                        log.error(msg4, (Throwable)error);
                        this.addError(error);
                        continue;
                    }
                }
                if (connection.endsWith("/")) {
                    connection = connection.substring(0, connection.length() - 1);
                }
                String label = String.valueOf((n = connection.lastIndexOf("/")) == -1 ? connection : connection.substring(n)) + "/" + "pom.xml";
                this.addProject(new MavenProjectScmInfo(label, model, null, tag, connection, connection));
            }
            catch (Exception ex) {
                this.addError(ex);
                msg = "Error reading " + d.getArtifactId();
                log.error(msg, (Throwable)ex);
            }
        }
    }

    private Scm resolveScm(Model model, IProgressMonitor monitor) throws ArtifactResolutionException, ArtifactNotFoundException, XmlPullParserException, IOException, CoreException {
        Scm scm = model.getScm();
        if (scm != null) {
            return scm;
        }
        Parent parent = model.getParent();
        if (parent == null) {
            return null;
        }
        Model parentModel = this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), monitor);
        if (parentModel == null) {
            return null;
        }
        Scm parentScm = this.resolveScm(parentModel, monitor);
        if (parentScm == null) {
            return null;
        }
        HashSet modules = new HashSet(parentModel.getModules());
        List parentModelProfiles = parentModel.getProfiles();
        for (Profile profile : parentModelProfiles) {
            modules.addAll(profile.getModules());
        }
        String artifactId = model.getArtifactId();
        for (String module : modules) {
            if (!module.equals(artifactId) && !module.endsWith("/" + artifactId)) continue;
            if (parentScm.getConnection() != null) {
                parentScm.setConnection(String.valueOf(parentScm.getConnection()) + "/" + module);
            }
            if (parentScm.getDeveloperConnection() != null) {
                parentScm.setDeveloperConnection(String.valueOf(parentScm.getDeveloperConnection()) + "/" + module);
            }
            return parentScm;
        }
        return parentScm;
    }

    private Model resolveModel(String groupId, String artifactId, String version, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)Messages.MavenProjectPomScanner_task_resolving, (Object[])new Object[]{groupId, artifactId, version}));
        List repositories = this.maven.getArtifactRepositories();
        Artifact artifact = this.maven.resolve(groupId, artifactId, version, "pom", null, repositories, monitor);
        File file = artifact.getFile();
        if (file == null) {
            return null;
        }
        monitor.subTask(NLS.bind((String)Messages.MavenProjectPomScanner_23, (Object[])new Object[]{groupId, artifactId, version}));
        return this.readModel(file);
    }

    private Model readModel(File file) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream is = new FileInputStream(file);){
                return IMavenToolbox.of((IComponentLookup)this.maven).readModel((InputStream)new FileInputStream(file));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_read_pom, (Throwable)e));
        }
    }
}

