/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.conversion.AbstractWtpProjectConversionParticipant;
import org.eclipse.m2e.wtp.internal.conversion.MavenPluginUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarProjectConverter
extends AbstractWtpProjectConversionParticipant {
    private static final String DEFAULT_APPLICATION_FOLDER = "src/main/application";
    private static final String EAR_SOURCE_DIRECTORY_KEY = "earSourceDirectory";
    private static final String EAR_VERSION = "version";
    private static final String GENERATE_APPLICATION_XML = "generateApplicationXml";
    private static final Logger LOG = LoggerFactory.getLogger(EarProjectConverter.class);

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project) || !"ear".equals(model.getPackaging())) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        this.setEarPlugin(component, model);
    }

    private void setEarPlugin(IVirtualComponent component, Model model) throws CoreException {
        IProjectFacetVersion earVersion;
        Build build = this.getCloneOrCreateBuild(model);
        Plugin earPlugin = this.setPlugin(build, "org.apache.maven.plugins", "maven-ear-plugin", "2.7");
        IFolder applicationContentFolder = this.findEarContentFolder(component);
        boolean hasApplicationXml = true;
        boolean customized = false;
        if (applicationContentFolder != null) {
            String applicationContent = applicationContentFolder.getProjectRelativePath().toPortableString();
            if (!DEFAULT_APPLICATION_FOLDER.equals(applicationContent)) {
                MavenPluginUtils.configure(earPlugin, EAR_SOURCE_DIRECTORY_KEY, applicationContent);
                customized = true;
            }
            hasApplicationXml = applicationContentFolder.getFile("META-INF/application.xml").exists();
        } else {
            IProject project = component.getProject();
            String msg = "The EAR project " + (project != null ? project.getName() : component.getName()) + " does not have a content folder or uses root as content folder";
            LOG.warn(msg);
        }
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)component.getProject());
        if (fProject != null && !IJ2EEFacetConstants.ENTERPRISE_APPLICATION_13.equals(earVersion = fProject.getProjectFacetVersion(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET))) {
            String version;
            boolean isJavaEE;
            boolean bl = isJavaEE = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_50.compareTo((Object)earVersion) < 0;
            if (isJavaEE) {
                version = earVersion.getVersionString().substring(0, 1);
                if (!hasApplicationXml) {
                    MavenPluginUtils.configure(earPlugin, GENERATE_APPLICATION_XML, "false");
                }
            } else {
                version = earVersion.getVersionString();
            }
            MavenPluginUtils.configure(earPlugin, EAR_VERSION, version);
            customized = true;
        }
        if (customized) {
            model.setBuild(build);
        }
    }

    private IFolder findEarContentFolder(IVirtualComponent component) {
        return WTPProjectsUtil.getDefaultDeploymentDescriptorFolder(component.getRootFolder());
    }

    protected IProjectFacet getRequiredFaced() {
        return WTPProjectsUtil.EAR_FACET;
    }
}

