/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;
import org.eclipse.ui.themes.ITheme;

public class ThemeAdapter
extends PropertyMapAdapter {
    private ITheme targetTheme;
    private IPropertyChangeListener listener = event -> this.firePropertyChange(event.getProperty());

    public ThemeAdapter(ITheme targetTheme) {
        this.targetTheme = targetTheme;
    }

    @Override
    protected void attachListener() {
        this.targetTheme.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void detachListener() {
        this.targetTheme.removePropertyChangeListener(this.listener);
    }

    @Override
    public Set<String> keySet() {
        return ThemeAdapter.getKeySet(this.targetTheme);
    }

    @Override
    public Object getValue(String propertyId, Class propertyType) {
        return ThemeAdapter.getValue(this.targetTheme, propertyId, propertyType);
    }

    public static Set<String> getKeySet(ITheme targetTheme) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(targetTheme.keySet());
        result.addAll(targetTheme.getColorRegistry().getKeySet());
        result.addAll(targetTheme.getFontRegistry().getKeySet());
        return result;
    }

    public static Object getValue(ITheme targetTheme, String propertyId, Class<?> propertyType) {
        FontRegistry fonts;
        Color result;
        if (propertyType.isAssignableFrom(String.class)) {
            return targetTheme.getString(propertyId);
        }
        if (propertyType.isAssignableFrom(Color.class) && (result = targetTheme.getColorRegistry().get(propertyId)) != null) {
            return result;
        }
        if (propertyType.isAssignableFrom(Font.class) && (fonts = targetTheme.getFontRegistry()).hasValueFor(propertyId)) {
            return fonts.get(propertyId);
        }
        if (propertyType == Integer.class) {
            return targetTheme.getInt(propertyId);
        }
        if (propertyType == Boolean.class) {
            return targetTheme.getBoolean(propertyId) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean propertyExists(String propertyId) {
        return this.keySet().contains(propertyId);
    }

    @Override
    public void setValue(String propertyId, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

