/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.NumberFormat;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.Units;

@Category(value="__hidden__")
@CommandName(value="heap_dump_overview")
@Icon(value="/META-INF/icons/heapdump_details.gif")
public class HeapDumpInfoQuery
implements IQuery {
    @Argument
    public SnapshotInfo info;

    public IResult execute(IProgressListener listener) throws Exception {
        Serializable discard_seed;
        Serializable discard_offset;
        Serializable discard_pattern;
        Boolean useCompressedOops;
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ArrayList<TextEntry> entries = new ArrayList<TextEntry>(12);
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_UsedHeapDump, this.getUsedHeapInMb(this.info.getUsedHeapSize())));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumObjects, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumObjectsFormat, (Object[])new Object[]{this.info.getNumberOfObjects()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumClasses, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumClassesFormat, (Object[])new Object[]{this.info.getNumberOfClasses()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumClassLoaders, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumClassLoadersFormat, (Object[])new Object[]{this.info.getNumberOfClassLoaders()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumGCRoots, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumGCRootsFormat, (Object[])new Object[]{this.info.getNumberOfGCRoots()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_HeapFormat, this.info.getProperty("$heapFormat").toString()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_JVMVersion, this.info.getJvmInfo()));
        if (this.info.getCreationDate() != null) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Time, MessageUtil.format((String)Messages.HeapDumpInfoQuery_TimeFormat, (Object[])new Object[]{this.info.getCreationDate()})));
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Date, MessageUtil.format((String)Messages.HeapDumpInfoQuery_DateFormat, (Object[])new Object[]{this.info.getCreationDate()})));
        } else {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Time, null));
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Date, null));
        }
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_IdentifierSize, this.getSize(this.info.getIdentifierSize())));
        if (this.info.getIdentifierSize() == 8 && (useCompressedOops = (Boolean)this.info.getProperty("$useCompressedOops")) != null) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_UseCompressedOops, useCompressedOops.toString()));
        }
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_FilePath, this.info.getPath()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_FileLength, MessageUtil.format((String)Messages.HeapDumpInfoQuery_FileLengthFormat, (Object[])new Object[]{new File(this.info.getPath()).length()})));
        Serializable identifier = this.info.getProperty("$runtimeId");
        if (identifier instanceof String) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_MultipleSnapshotIdentifier, identifier.toString()));
        }
        NumberFormat percentFormatter = NumberFormat.getPercentInstance();
        percentFormatter.setMaximumFractionDigits(0);
        Serializable discard_ratio = this.info.getProperty("discard_ratio");
        if (discard_ratio instanceof Integer) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_DiscardRatio, MessageUtil.format((String)Messages.HeapDumpInfoQuery_DiscardRatio_format, (Object[])new Object[]{percentFormatter.format((double)((Integer)discard_ratio).intValue() * 0.01)})));
        }
        if ((discard_pattern = this.info.getProperty("discard_pattern")) instanceof String) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_DiscardPattern, discard_pattern.toString()));
        }
        if ((discard_offset = this.info.getProperty("discard_offset")) instanceof Integer) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_DiscardOffset, MessageUtil.format((String)Messages.HeapDumpInfoQuery_DiscardOffset_format, (Object[])new Object[]{percentFormatter.format((double)((Integer)discard_offset).intValue() * 0.01)})));
        }
        if ((discard_seed = this.info.getProperty("discard_seed")) instanceof Integer) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_DiscardSeed, MessageUtil.format((String)Messages.HeapDumpInfoQuery_DiscardSeed_format, (Object[])new Object[]{discard_seed})));
        }
        return new ListResult(TextEntry.class, entries, new String[]{"propertyName", "propertyValue"});
    }

    private String getUsedHeapInMb(long usedHeapSize) {
        return Units.Storage.of((long)usedHeapSize).format(usedHeapSize);
    }

    private String getSize(int identifierSize) {
        switch (identifierSize) {
            case 0: {
                return null;
            }
            case 4: {
                return Messages.HeapDumpInfoQuery_32bit;
            }
            case 8: {
                return Messages.HeapDumpInfoQuery_64bit;
            }
        }
        return String.valueOf(identifierSize);
    }

    public static class TextEntry {
        private String propertyValue;
        private String propertyName;

        public TextEntry(String propertyName, String propertyValue) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class TextEntryBeanInfo
    extends SimpleBeanInfo {
        @Override
        public PropertyDescriptor[] getPropertyDescriptors() {
            PropertyDescriptor[] ret;
            try {
                PropertyDescriptor propertyDescriptor1 = new PropertyDescriptor("propertyName", TextEntry.class, "getPropertyName", null){

                    @Override
                    public String getDisplayName() {
                        return Messages.HeapDumpInfoQuery_PropertyName;
                    }
                };
                PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor("propertyValue", TextEntry.class, "getPropertyValue", null){

                    @Override
                    public String getDisplayName() {
                        return Messages.HeapDumpInfoQuery_ProperyValue;
                    }
                };
                ret = new PropertyDescriptor[]{propertyDescriptor1, propertyDescriptor2};
            }
            catch (IntrospectionException e) {
                ret = null;
            }
            return ret;
        }
    }
}

