/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.undo.snapshot;

import org.eclipse.core.internal.resources.undo.snapshot.MarkerSnapshot;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

abstract class AbstractResourceSnapshot<T extends IResource>
implements IResourceSnapshot<T> {
    IContainer parent;
    long modificationStamp = -1L;
    long localTimeStamp = -1L;
    ResourceAttributes resourceAttributes;
    MarkerSnapshot[] markerDescriptions;

    protected AbstractResourceSnapshot() {
    }

    protected AbstractResourceSnapshot(T resource) {
        this.parent = resource.getParent();
        if (resource.isAccessible()) {
            this.modificationStamp = resource.getModificationStamp();
            this.localTimeStamp = resource.getLocalTimeStamp();
            this.resourceAttributes = resource.getResourceAttributes();
            try {
                IMarker[] markers = resource.findMarkers(null, true, 2);
                this.markerDescriptions = new MarkerSnapshot[markers.length];
                int i = 0;
                while (i < markers.length) {
                    this.markerDescriptions[i] = new MarkerSnapshot(markers[i]);
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public T createResource(IProgressMonitor monitor) throws CoreException {
        Object resource = this.createResourceHandle();
        this.createExistentResourceFromHandle(monitor);
        this.restoreResourceAttributes((IResource)resource);
        return resource;
    }

    @Override
    public boolean isValid() {
        return this.parent == null || this.parent.exists();
    }

    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        if (this.modificationStamp != -1L) {
            resource.revertModificationStamp(this.modificationStamp);
        }
        if (this.localTimeStamp != -1L) {
            resource.setLocalTimeStamp(this.localTimeStamp);
        }
        if (this.resourceAttributes != null) {
            resource.setResourceAttributes(this.resourceAttributes);
        }
        if (this.markerDescriptions != null) {
            MarkerSnapshot[] markerSnapshotArray = this.markerDescriptions;
            int n = this.markerDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerSnapshot markerDescription = markerSnapshotArray[n2];
                if (markerDescription.resource.exists()) {
                    markerDescription.createMarker();
                }
                ++n2;
            }
        }
    }

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Override
    public boolean verifyExistence(boolean checkMembers) {
        IResource handle;
        IContainer p = this.parent;
        if (p == null) {
            p = this.getWorkspace().getRoot();
        }
        return (handle = p.findMember(this.getName())) != null;
    }
}

