/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.BaseProvider;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMExecVmInfo;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="IBM Dump (using helper VM)")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/acquiringheapdump.html#task_acquiringheapdump__3")
public class IBMExecDumpProvider
extends BaseProvider {
    private static final String PLUGIN_ID = "org.eclipse.mat.ibmdump";
    private static final String JAVA_EXEC = "java";
    private static final String JAVA_EXEC_WINDOWS = "java.exe";
    private static final String JCMD = "jcmd";
    private static final String[] ibmmodules = new String[]{"jdmpview", "jdmpview.exe", "jpackcore", "jpackcore.exe", "jextract", "jextract.exe"};
    private static final String[] hprofmodules = new String[]{"jinfo", "jinfo.exe", "jstatd", "jstatd.exe"};
    private static boolean abort = false;
    private int lastCount = 20;
    @Argument(isMandatory=false)
    public File javaexecutable;
    @Argument(isMandatory=false)
    public List<File> javaList;
    @Argument(isMandatory=false)
    public String[] vmoptions = new String[0];
    private DumpType defaultTypeCopy;
    public File javaexecutableCopy;
    private static final String last_directory_key = String.valueOf(IBMExecDumpProvider.class.getName()) + ".lastDir";
    private static String savedJavaDir;
    private static File execJar;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType;

    public IBMExecDumpProvider() {
        try {
            Class.forName("com.ibm.jvm.Dump");
        }
        catch (ClassNotFoundException e) {
            this.defaultType = DumpType.HPROF;
        }
        this.fillJavaList();
        this.defaultTypeCopy = this.defaultType;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        if (!(info instanceof IBMExecVmInfo)) {
            throw new IllegalArgumentException(info.toString());
        }
        listener.beginTask(Messages.getString("IBMExecDumpProvider.GeneratingDump"), 1980);
        encoding = System.getProperty("file.encoding", "UTF-8");
        encodingOpt = "-Dfile.encoding=" + encoding;
        pb = new ProcessBuilder(new String[0]);
        p = null;
        info2 = (IBMExecVmInfo)info;
        vm = info2.getPidName();
        try {
            block46: {
                block45: {
                    block44: {
                        execPath = info2.javaexecutable.getPath();
                        args = new ArrayList<String>(9);
                        args.add(execPath);
                        if (!info2.javaexecutable.getName().startsWith("jcmd")) break block44;
                        args.add("-J" + encodingOpt);
                        if (info2.vmoptions == null) break block45;
                        var15_14 = info2.vmoptions;
                        var14_19 = info2.vmoptions.length;
                        var13_20 = 0;
                        if (true) ** GOTO lbl53
                    }
                    args.add(encodingOpt);
                    if (info2.vmoptions != null) {
                        args.addAll(Arrays.asList(info2.vmoptions));
                    }
                    args.add("-jar");
                    jar = IBMExecDumpProvider.getExecJar().getAbsolutePath();
                    args.add(jar);
                    args.add(info2.type.toString());
                    args.add(vm);
                    args.add(Boolean.toString(info2.live));
                    args.add(Boolean.toString(info2.compress));
                    args.add(preferredLocation.getAbsolutePath());
                    if (info2.dumpdir != null) {
                        args.add(info2.dumpdir.getAbsolutePath());
                    }
                    break block46;
                    do {
                        arg = var15_14[var13_20];
                        args.add("-J" + arg);
                        ++var13_20;
lbl53:
                        // 2 sources

                    } while (var13_20 < var14_19);
                }
                args.add(vm);
                switch (IBMExecDumpProvider.$SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType()[info2.type.ordinal()]) {
                    case 2: {
                        args.add("Dump.heap");
                        break;
                    }
                    case 4: {
                        args.add("GC.heap_dump");
                        if (info2.live) break;
                        args.add("-all");
                        break;
                    }
                    case 3: {
                        args.add("Dump.java");
                        break;
                    }
                    case 1: {
                        args.add("Dump.system");
                        break;
                    }
                }
                args.add(preferredLocation.getAbsolutePath());
            }
            pb.command(args);
            p = pb.start();
            berr = new ByteArrayOutputStream();
            bin = new ByteArrayOutputStream();
            try {
                block47: {
                    rc = 0;
                    while (true) {
                        if (p.getInputStream().available() > 0) {
                            r = p.getInputStream().read();
                            if (r >= 0) {
                                bin.write(r);
                                continue;
                            }
                        }
                        while (p.getErrorStream().available() > 0) {
                            r = p.getErrorStream().read();
                            if (r < 0) break;
                            if (r == 46) {
                                listener.worked(1);
                            }
                            berr.write(r);
                        }
                        try {
                            rc = p.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e1) {
                                listener.setCanceled(true);
                            }
                            if (listener.isCanceled()) ** break;
                            continue;
                            try {
                                p.exitValue();
                                return null;
                            }
                            catch (IllegalThreadStateException e) {
                                p.destroy();
                            }
                            return null;
                        }
                        break;
                    }
                    in = bin.toString(encoding);
                    err = berr.toString(encoding);
                    if (rc == 0) break block47;
                    dot = 0;
                    if (true) ** GOTO lbl161
                }
                ss = in.toString().split("[\\n\\r]+");
                filename = ss[0];
                if (info2.javaexecutable.getName().startsWith("jcmd")) {
                    filename = filename.matches("^[0-9]+:$") != false ? preferredLocation.getAbsolutePath() : filename.replaceFirst("^Dump written to ", "");
                }
                listener.done();
                file = new File(filename);
                if (!file.canRead() || !file.isFile()) {
                    if (err.length() <= 0) {
                        if (ss.length <= 1) throw new FileNotFoundException(filename);
                    }
                    throw new IOException(MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ReturnCode"), (Object[])new Object[]{args, rc, String.valueOf(err.toString()) + "\n" + in.toString()}));
                }
                if (info2.javaexecutable.getName().startsWith("jcmd")) {
                    help1 = new IBMDumpProvider();
                    helper = help1.getDumpProvider(info2);
                    dumps = Collections.singletonList(file);
                    javahome = this.javaexecutable.getParentFile();
                    if (javahome != null) {
                        javahome = javahome.getParentFile();
                    }
                    try {
                        file = helper.jextract(preferredLocation, info2.compress, dumps, file.getParentFile(), javahome, listener);
                    }
                    catch (InterruptedException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.Interrupted"), (Throwable)e);
                        throw new SnapshotException(Messages.getString("IBMDumpProvider.Interrupted"), (Throwable)e);
                    }
                    var26_38 = file;
                    return var26_38;
                }
                var26_39 = file;
                return var26_39;
            }
            finally {
                try {
                    p.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    p.destroy();
                }
            }
            do {
                ++dot;
lbl161:
                // 2 sources

            } while (dot < err.length() && err.charAt(dot) == '.');
            if ((err = err.substring(dot)).indexOf(IBMDumpProvider.AttachNotSupportedException.class.getName()) >= 0) {
                info.setHeapDumpEnabled(false);
            }
            throw new IOException(MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ReturnCode"), (Object[])new Object[]{args, rc, err}));
        }
        catch (FileNotFoundException e) {
            throw new SnapshotException((Throwable)e);
        }
        catch (IOException e) {
            throw new SnapshotException((Throwable)e);
        }
    }

    private File javaExec(String dir) {
        if (dir != null) {
            return IBMExecDumpProvider.jvmExec(new File(dir), JAVA_EXEC);
        }
        return IBMExecDumpProvider.jvmExec(null, JAVA_EXEC);
    }

    private File javaExec(File dir) {
        return IBMExecDumpProvider.jvmExec(dir, JAVA_EXEC);
    }

    static File jvmExec(File javaDir, String exec) {
        File javaExec = javaDir != null ? new File(javaDir, exec) : new File(exec);
        return javaExec;
    }

    public List<VmInfo> getAvailableVMs(IProgressListener listener) {
        List<VmInfo> ret;
        String javaDir;
        if (abort) {
            return Collections.emptyList();
        }
        File javaExec = this.javaexecutable;
        if (this.javaList == null || this.javaList.isEmpty() || this.defaultTypeCopy == DumpType.HPROF != (this.defaultType == DumpType.HPROF)) {
            this.fillJavaList();
        }
        this.defaultTypeCopy = this.defaultType;
        if (javaExec != null) {
            javaDir = javaExec.getParent();
        } else {
            File javaExec2;
            javaDir = IBMExecDumpProvider.lastJavaDir();
            if (javaDir == null) {
                if (this.javaList == null || this.javaList.isEmpty()) {
                    this.fillJavaList();
                }
                if (this.javaList.size() >= 1) {
                    javaDir = this.javaList.get(0).getParent();
                }
            }
            if (!(javaExec = this.javaExec(javaDir)).canExecute() && (javaExec2 = IBMExecDumpProvider.jvmExec(new File(javaDir), JAVA_EXEC_WINDOWS)).canExecute()) {
                javaExec = javaExec2;
            }
        }
        if (javaExec != null && javaExec.canExecute() && !javaExec.equals(this.javaexecutableCopy)) {
            String mod;
            if (this.defaultType == DumpType.HPROF) {
                String[] stringArray = ibmmodules;
                int n = ibmmodules.length;
                int n2 = 0;
                while (n2 < n) {
                    mod = stringArray[n2];
                    File modf = new File(javaExec.getParentFile(), mod);
                    if (modf.canExecute()) {
                        this.defaultType = DumpType.SYSTEM;
                        break;
                    }
                    ++n2;
                }
            } else {
                String[] stringArray = hprofmodules;
                int n = hprofmodules.length;
                int n3 = 0;
                while (n3 < n) {
                    mod = stringArray[n3];
                    File modf = new File(javaExec.getParentFile(), mod);
                    if (modf.canExecute()) {
                        this.defaultType = DumpType.HPROF;
                        break;
                    }
                    ++n3;
                }
            }
        }
        if ((ret = this.execGetVMs(javaExec, listener)) != null) {
            IBMExecDumpProvider.setJavaDir(javaDir);
            this.javaexecutable = javaExec;
            this.javaexecutableCopy = javaExec;
        }
        return ret;
    }

    private void fillJavaList() {
        List<File> dirs = this.defaultJavaDirs();
        this.javaList = new ArrayList<File>();
        for (File d : dirs) {
            File javaExec = this.javaExec(d);
            if (javaExec.canExecute()) {
                this.javaList.add(javaExec);
                continue;
            }
            javaExec = IBMExecDumpProvider.jvmExec(d, JAVA_EXEC_WINDOWS);
            if (!javaExec.canExecute()) continue;
            this.javaList.add(javaExec);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<File> defaultJavaDirs() {
        String path;
        Object f2;
        String s1;
        ArrayList<File> ret = new ArrayList<File>();
        String[] modules = this.defaultType == DumpType.HPROF ? hprofmodules : ibmmodules;
        ArrayList<Object> paths = new ArrayList<Object>();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
        if (prefs != null && (s1 = prefs.get("org.eclipse.jdt.launching.PREF_VM_XML", null)) != null) {
            try {
                List<File> list = IBMExecDumpProvider.parseJDTvmSettings(s1);
                for (File file : list) {
                    f2 = new File(file, "bin");
                    paths.add(f2);
                    if (((File)f2).exists()) continue;
                    File f3 = new File(file, "jre");
                    File f4 = new File(f3, "bin");
                    paths.add(f4);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((path = System.getenv("PATH")) != null) {
            void var7_18;
            f2 = path.split(File.pathSeparator);
            int n = ((String[])f2).length;
            boolean bl = false;
            while (var7_18 < n) {
                String string = f2[var7_18];
                paths.add(new File(string));
                ++var7_18;
            }
        }
        block4: for (File file : paths) {
            File parentDir = file.getParentFile();
            File dir2 = new File(parentDir, "jre");
            dir2 = new File(file, "bin");
            String[] stringArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                String mod = stringArray[n2];
                File dll = new File(file, mod);
                if (dll.canExecute() && !ret.contains(file)) {
                    ret.add(file);
                    continue block4;
                }
                dll = new File(dir2, mod);
                if (dll.canExecute() && !ret.contains(dir2)) {
                    ret.add(dir2);
                    continue block4;
                }
                ++n2;
            }
        }
        String string = System.getProperty("java.home");
        File file = new File(string, "bin");
        if (!ret.contains(file)) {
            ret.add(file);
        }
        return ret;
    }

    private static final List<File> parseJDTvmSettings(String input) throws IOException {
        try {
            JDTLaunchingSAXHandler handler = new JDTLaunchingSAXHandler();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader saxXmlReader = parser.getXMLReader();
            saxXmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxXmlReader.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            saxXmlReader.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            saxXmlReader.setContentHandler(handler);
            saxXmlReader.setErrorHandler(handler);
            saxXmlReader.parse(new InputSource(new StringReader(input)));
            ArrayList<File> homes = new ArrayList<File>();
            for (String home : handler.getJavaHome()) {
                File homedir = new File(home);
                File dir = new File(homedir, "bin");
                if (!dir.exists()) continue;
                File jps1 = new File(dir, "jps");
                File jps2 = new File(dir, "jps.exe");
                if (!jps1.canExecute() && !jps2.canExecute()) continue;
                homes.add(homedir);
            }
            return homes;
        }
        catch (SAXException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (ParserConfigurationException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static synchronized String lastJavaDir() {
        String home = Platform.getPreferencesService().getString(PLUGIN_ID, last_directory_key, savedJavaDir, null);
        return home;
    }

    private static synchronized void setJavaDir(String home) {
        if (home != null && !home.equals(savedJavaDir)) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            prefs.put(last_directory_key, home);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            savedJavaDir = home;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<VmInfo> execGetVMs(File javaExec, IProgressListener listener) {
        block36: {
            block35: {
                ar = new ArrayList<VmInfo>();
                listener.beginTask(Messages.getString("IBMExecDumpProvider.ListingIBMVMs"), this.lastCount);
                count = 0;
                encoding = System.getProperty("file.encoding", "UTF-8");
                encodingOpt = "-Dfile.encoding=" + encoding;
                pb = new ProcessBuilder(new String[0]);
                p = null;
                execPath = javaExec.getPath();
                args = new ArrayList<String>(4);
                args.add(execPath);
                useJcmd = javaExec.getName().startsWith("jcmd");
                if (useJcmd) {
                    args.add("-J" + encodingOpt);
                    if (this.vmoptions != null) {
                        var15_14 = this.vmoptions;
                        var14_19 = this.vmoptions.length;
                        var13_20 = 0;
                        while (var13_20 < var14_19) {
                            arg = var15_14[var13_20];
                            args.add("-J" + arg);
                            ++var13_20;
                        }
                    }
                    args.add("-l");
                } else {
                    args.add(encodingOpt);
                    if (this.vmoptions != null) {
                        args.addAll(Arrays.asList(this.vmoptions));
                    }
                    args.add("-jar");
                    jar = IBMExecDumpProvider.getExecJar().getAbsolutePath();
                    args.add(jar);
                    args.add(Boolean.toString(this.listAttach));
                }
                pb.command(args);
                p = pb.start();
                berr = new ByteArrayOutputStream();
                bin = new ByteArrayOutputStream();
                rc = 0;
                while (true) {
                    if (p.getInputStream().available() > 0) {
                        r = p.getInputStream().read();
                        if (r >= 0) {
                            bin.write(r);
                            if (!useJcmd) continue;
                            listener.worked(1);
                            ++count;
                            continue;
                        }
                    }
                    while (p.getErrorStream().available() > 0) {
                        r = p.getErrorStream().read();
                        if (r < 0) break;
                        if (r == 46) {
                            listener.worked(1);
                        }
                        berr.write(r);
                    }
                    try {
                        rc = p.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        Thread.sleep(500L);
                        if (listener.isCanceled()) ** break;
                        continue;
                        p.destroy();
                        this.listAttach = false;
                    }
                    break;
                }
                in = bin.toString(encoding);
                err = berr.toString(encoding);
                if (rc == 0) break block35;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMsRC"), (Object[])new Object[]{execPath, rc, err}), null);
                var27_24 = ar;
                try {
                    p.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    p.destroy();
                }
                return var27_24;
            }
            try {
                var21_29 = ss = in.toString().split("[\\n\\r]+");
                var20_30 = ss.length;
                var19_31 = 0;
                while (var19_31 < var20_30) {
                    s = var21_29[var19_31];
                    s2 = s.split(IBMExecDumpProvider.INFO_SEPARATOR, 6);
                    if (s2.length >= 5) {
                        if (IBMExecDumpProvider.execJar == null || !s2[5].contains(IBMExecDumpProvider.execJar.getName())) {
                            enableDump = Boolean.parseBoolean(s2[1]);
                            ifo = new IBMExecVmInfo(s2[0], s2[5], enableDump, null, this);
                            ifo.javaexecutable = javaExec;
                            ifo.vmoptions = this.vmoptions;
                            t = DumpType.valueOf(s2[2]);
                            ifo.type = this.isIBMDumpType(t) != false && this.isIBMDumpType(this.defaultType) != false ? this.defaultType : t;
                            ifo.live = this.defaultLive;
                            ifo.compress = this.defaultCompress;
                            if (s2[4].length() > 0) {
                                ifo.dumpdir = new File(s2[4]);
                            }
                            if (s2[3].length() > 0 && !s2[3].equals(ifo.getProposedFileName())) {
                                ifo.setProposedFileName(s2[3]);
                            }
                            ar.add(ifo);
                        }
                    } else {
                        s2 = s.split(" ", 2);
                        if (s2.length == 2 && s2[0].matches("[0-9]+")) {
                            v0 = enableDump = s2[1].contains(execPath) == false;
                            if (s2[1].contains("JCmd -l")) {
                                enableDump = false;
                            }
                            ifo = new IBMExecVmInfo(s2[0], s2[1], enableDump, null, this);
                            ifo.javaexecutable = javaExec;
                            ifo.vmoptions = this.vmoptions;
                            ifo.type = this.defaultType;
                            ifo.live = this.defaultLive;
                            ifo.compress = this.defaultCompress;
                            ar.add(ifo);
                        }
                    }
                    ++var19_31;
                }
                break block36;
                {
                    catch (Throwable var26_37) {
                        throw var26_37;
                    }
                }
                finally {
                    try {
                        p.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        p.destroy();
                    }
                }
            }
            catch (IOException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMs"), (Object[])new Object[]{execPath}), (Throwable)e);
            }
            catch (InterruptedException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMs"), (Object[])new Object[]{execPath}), (Throwable)e);
            }
        }
        listener.done();
        if (count > 0) {
            this.lastCount = count;
        }
        return ar;
    }

    private boolean isIBMDumpType(DumpType t) {
        return t == DumpType.SYSTEM || t == DumpType.HEAP || t == DumpType.JAVA;
    }

    static synchronized File getExecJar() throws IOException {
        if (execJar == null || !execJar.canRead() || !execJar.isFile()) {
            String jarname = "org.eclipse.mat.ibmexecdumps";
            String[] classesNames = new String[]{"org.eclipse.mat.ibmvm.acquire.IBMDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AgentInitializationException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AgentLoadException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AttachNotSupportedException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AttachOperationFailedException", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AttachProvider", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$VirtualMachine", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$VirtualMachineDescriptor", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AgentLoader", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$FileComparator", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$NewFileFilter", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$StderrProgressListener", "org.eclipse.mat.ibmvm.acquire.BaseProvider", "org.eclipse.mat.ibmvm.acquire.HprofDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMHeapDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMSystemDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMJavaDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMVmInfo", "org.eclipse.mat.ibmvm.acquire.AgentLoader2", "org.eclipse.mat.ibmvm.acquire.DumpType", "org.eclipse.mat.ibmvm.agent.DumpAgent"};
            Class[] classes = new Class[]{SnapshotException.class, IHeapDumpProvider.class, VmInfo.class, IProgressListener.class, IProgressListener.OperationCanceledException.class, IProgressListener.Severity.class, Messages.class};
            execJar = IBMExecDumpProvider.makeJar(jarname, "Main-Class: ", classesNames, classes);
        }
        return execJar;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType() {
        if ($SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType != null) {
            return $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType;
        }
        int[] nArray = new int[DumpType.values().length];
        try {
            nArray[DumpType.HEAP.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DumpType.HPROF.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DumpType.JAVA.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DumpType.SYSTEM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$mat$ibmvm$acquire$DumpType = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JDTLaunchingSAXHandler
    extends DefaultHandler {
        List<String> javaHomes = new ArrayList<String>();
        private String defVM;
        private String type;

        private JDTLaunchingSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("vmSettings")) {
                String[] s;
                String settings = attributes.getValue("defaultVM");
                if (settings != null && (s = settings.split(",")).length >= 3) {
                    this.defVM = s[2];
                }
            } else if (name.equals("vmType")) {
                this.type = attributes.getValue("id");
            } else if (name.equals("vm") && "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType".equals(this.type)) {
                String id = attributes.getValue("id");
                String path = attributes.getValue("path");
                if (path != null) {
                    if (id != null && id.equals(this.defVM)) {
                        this.javaHomes.add(0, path);
                    } else {
                        this.javaHomes.add(path);
                    }
                }
            }
        }

        public List<String> getJavaHome() {
            return this.javaHomes;
        }
    }
}

