/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.webapp.AbstractButton;

public class ButtonData
extends RequestData {
    private static final String BUTTON_EXTENSION_POINT = "org.eclipse.help.webapp.toolbarButton";
    private List<AbstractButton> allButtons;

    public ButtonData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractButton[] getButtons() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(BUTTON_EXTENSION_POINT);
        if (this.allButtons == null) {
            this.allButtons = new ArrayList<AbstractButton>();
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object obj = null;
                try {
                    obj = element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    ILog.of(this.getClass()).error("Create extension failed:[org.eclipse.help.webapp.toolbarButton].", (Throwable)e);
                }
                Object object = obj;
                if (object instanceof AbstractButton) {
                    void button;
                    AbstractButton cfr_ignored_0 = (AbstractButton)object;
                    AbstractButton cfr_ignored_1 = (AbstractButton)object;
                    this.allButtons.add((AbstractButton)button);
                }
                ++n2;
            }
            this.allButtons.sort(null);
        }
        ArrayList<AbstractButton> buttonList = new ArrayList<AbstractButton>();
        buttonList.addAll(this.allButtons);
        AbstractButton[] buttons = buttonList.toArray(new AbstractButton[buttonList.size()]);
        return buttons;
    }

    public String getImageUrl(AbstractButton button) {
        return this.request.getContextPath() + button.getImageURL();
    }
}

