/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.ArgumentDescriptor;

public class AnnotatedObjectDescriptor
implements IAnnotatedObjectDescriptor {
    protected final String identifier;
    protected String name;
    protected String usage;
    protected final String help;
    protected final String helpUrl;
    protected final Locale helpLocale;
    protected final URL icon;
    protected final List<ArgumentDescriptor> arguments;

    public AnnotatedObjectDescriptor(String identifier, String name, String usage, URL icon, String help, String helpUrl, Locale helpLocale) {
        this.identifier = identifier;
        this.name = name;
        this.usage = usage;
        this.icon = icon;
        this.help = help;
        this.helpUrl = helpUrl;
        this.helpLocale = helpLocale;
        this.arguments = new ArrayList<ArgumentDescriptor>();
    }

    @Override
    public synchronized String getUsage(IQueryContext context) {
        if (this.usage != null) {
            return this.usage;
        }
        if (context == null) {
            this.usage = this.identifier;
            return this.usage;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.identifier);
        for (ArgumentDescriptor param : this.arguments) {
            if (context.available(param.getType(), param.getAdvice())) continue;
            param.appendUsage(buf);
        }
        this.usage = buf.toString();
        return this.usage;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public String getHelpUrl() {
        return this.helpUrl;
    }

    @Override
    public Locale getHelpLocale() {
        return this.helpLocale;
    }

    @Override
    public List<ArgumentDescriptor> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isHelpAvailable() {
        if (this.help != null) {
            return true;
        }
        for (ArgumentDescriptor arg : this.arguments) {
            if (arg.getHelp() == null) continue;
            return true;
        }
        return false;
    }

    public void addParameter(ArgumentDescriptor descriptor) {
        this.arguments.add(descriptor);
    }
}

