/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.JobInfo;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.osgi.util.NLS;

class GroupInfo
extends JobTreeElement
implements IProgressMonitor {
    private List<JobInfo> infos = new ArrayList<JobInfo>();
    private Object lock = new Object();
    private String taskName = ProgressMessages.SubTaskInfo_UndefinedTaskName;
    boolean isActive = false;
    double total = -1.0;
    double currentWork;
    private ProgressManager progressManager;
    private FinishedJobs finishedJobs;

    public GroupInfo(ProgressManager progressManager, FinishedJobs finishedJobs) {
        this.progressManager = progressManager;
        this.finishedJobs = finishedJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean hasChildren() {
        Object object = this.lock;
        synchronized (object) {
            return !this.infos.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object[] getChildren() {
        Object object = this.lock;
        synchronized (object) {
            return this.infos.toArray();
        }
    }

    @Override
    String getDisplayString() {
        if (this.total < 0.0) {
            return this.taskName;
        }
        Object[] messageValues = new String[]{this.taskName, String.valueOf(this.getPercentDone())};
        return NLS.bind((String)ProgressMessages.JobInfo_NoTaskNameDoneMessage, (Object[])messageValues);
    }

    int getPercentDone() {
        return (int)(this.currentWork * 100.0 / this.total);
    }

    @Override
    boolean isJobInfo() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(String name, int totalWork) {
        this.taskName = name != null && !name.isEmpty() ? name : ProgressMessages.SubTaskInfo_UndefinedTaskName;
        this.total = totalWork;
        Object object = this.lock;
        synchronized (object) {
            this.isActive = true;
        }
        this.progressManager.refreshGroup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object object = this.lock;
        synchronized (object) {
            this.isActive = false;
        }
        this.updateInProgressManager();
    }

    private void updateInProgressManager() {
        for (JobInfo next : this.infos) {
            if (next.getJob().getState() == 0) continue;
            this.progressManager.refreshGroup(this);
            return;
        }
        if (this.finishedJobs.isKept(this)) {
            this.progressManager.refreshGroup(this);
        } else {
            this.progressManager.removeGroup(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalWorked(double work) {
        Object object = this.lock;
        synchronized (object) {
            this.currentWork += work;
        }
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskName(String name) {
        GroupInfo groupInfo = this;
        synchronized (groupInfo) {
            this.isActive = true;
        }
        this.taskName = name == null ? ProgressMessages.SubTaskInfo_UndefinedTaskName : name;
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeJobInfo(JobInfo job) {
        Object object = this.lock;
        synchronized (object) {
            this.infos.remove(job);
            if (this.infos.isEmpty()) {
                this.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJobInfo(JobInfo job) {
        Object object = this.lock;
        synchronized (object) {
            this.infos.add(job);
        }
    }

    @Override
    boolean isActive() {
        return this.isActive;
    }

    @Override
    public void cancel() {
        Object[] jobInfos;
        Object[] objectArray = jobInfos = this.getChildren();
        int n = jobInfos.length;
        int n2 = 0;
        while (n2 < n) {
            Object jobInfo = objectArray[n2];
            ((JobInfo)jobInfo).cancel();
            ++n2;
        }
        this.updateInProgressManager();
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    String getTaskName() {
        return this.taskName;
    }
}

