/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.DominatorsSummary;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="immediate_dominators")
@Icon(value="/META-INF/icons/immediate_dominators.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/immediate_dominators.html#ref_inspections_immediate_dominators__result")
public class ImmediateDominatorsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false, advice=Argument.Advice.CLASS_NAME_PATTERN, flag="skip")
    public Pattern skipPattern = Pattern.compile("java\\..*|javax\\..*|com\\.sun\\..*|sun\\..*|jdk\\..*");

    public IResult execute(IProgressListener listener) throws Exception {
        SimpleMonitor monitor = new SimpleMonitor(MessageUtil.format((String)Messages.ImmediateDominatorsQuery_ProgressName, (Object[])new Object[]{this.objects.getLabel()}), listener, new int[]{10, 100});
        DominatorsSummary summary = this.snapshot.getDominatorsOf(this.objects.getIds(monitor.nextMonitor()), this.skipPattern, monitor.nextMonitor());
        return new ResultImpl(summary);
    }

    public static class ResultImpl
    implements IResultTable,
    IIconProvider {
        DominatorsSummary summary;

        public ResultImpl(DominatorsSummary summary) {
            this.summary = summary;
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addContext(new ContextProvider(Messages.ImmediateDominatorsQuery_Objects){

                public IContextObject getContext(Object row) {
                    return this.getObjects(row);
                }
            }).addContext(new ContextProvider(Messages.ImmediateDominatorsQuery_DominatedObjects){

                public IContextObject getContext(Object row) {
                    return this.getDominatedObjects(row);
                }
            }).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName), new Column(Messages.Column_Objects, Long.class), new Column(Messages.ImmediateDominatorsQuery_ColumnDominatedObjects, Long.class), new Column(Messages.Column_ShallowHeap, Bytes.class), new Column(Messages.ImmediateDominatorsQuery_Column_DominatedShallowHeap, Bytes.class).sorting(Column.SortDirection.DESC)};
        }

        public int getRowCount() {
            return this.summary.getClassDominatorRecords().length;
        }

        public DominatorsSummary.ClassDominatorRecord getRow(int rowId) {
            return this.summary.getClassDominatorRecords()[rowId];
        }

        public URL getIcon(Object row) {
            return Icons.CLASS;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            switch (columnIndex) {
                case 0: {
                    return record.getClassName();
                }
                case 1: {
                    return record.getDominatorCount();
                }
                case 2: {
                    return record.getDominatedCount();
                }
                case 3: {
                    return new Bytes(record.getDominatorNetSize());
                }
                case 4: {
                    return new Bytes(record.getDominatedNetSize());
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            final DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            if (record.getClassId() >= 0) {
                return new IContextObject(){

                    public int getObjectId() {
                        return record.getClassId();
                    }
                };
            }
            return null;
        }

        IContextObject getObjects(Object row) {
            final DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            if (record.getClassId() >= 0) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassId();
                    }

                    public int[] getObjectIds() {
                        return record.getDominators();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            return null;
        }

        IContextObject getDominatedObjects(Object row) {
            final DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            return new IContextObjectSet(){

                public int getObjectId() {
                    return record.getClassId();
                }

                public int[] getObjectIds() {
                    return record.getDominated();
                }

                public String getOQL() {
                    return null;
                }
            };
        }
    }
}

