/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;

public class BindingServiceImpl
implements EBindingService {
    static final String USER_TYPE = "user";
    @Inject
    private IEclipseContext context;
    @Inject
    private BindingTableManager manager;
    @Inject
    private ContextManager contextManager;
    private ContextSet contextSet = ContextSet.EMPTY;

    @Override
    public Binding createBinding(TriggerSequence sequence, ParameterizedCommand command, String contextId, Map<String, String> attributes) {
        String schemeId = "org.eclipse.ui.defaultAcceleratorConfiguration";
        String locale = null;
        String platform = null;
        int bindingType = 0;
        if (sequence != null && !sequence.isEmpty() && contextId != null) {
            if (attributes != null) {
                String tmp = attributes.get("schemeId");
                if (tmp != null && tmp.length() > 0) {
                    schemeId = tmp;
                }
                locale = attributes.get("locale");
                platform = attributes.get("platform");
                if (USER_TYPE.equals(attributes.get("type"))) {
                    bindingType = 1;
                }
            }
            return new KeyBinding((KeySequence)sequence, command, schemeId, contextId, locale, platform, null, bindingType);
        }
        return null;
    }

    @Override
    public void activateBinding(Binding binding) {
        String contextId = binding.getContextId();
        BindingTable table = this.manager.getTable(contextId);
        if (table == null) {
            return;
        }
        table.addBinding(binding);
    }

    @Override
    public void deactivateBinding(Binding binding) {
        String contextId = binding.getContextId();
        BindingTable table = this.manager.getTable(contextId);
        if (table == null) {
            return;
        }
        table.removeBinding(binding);
    }

    @Override
    public TriggerSequence createSequence(String sequence) {
        try {
            return KeySequence.getInstance((String)sequence);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Collection<Binding> getConflictsFor(TriggerSequence sequence) {
        return this.manager.getConflictsFor(this.contextSet, sequence);
    }

    @Override
    public Collection<Binding> getAllConflicts() {
        return this.manager.getAllConflicts();
    }

    @Override
    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.manager.getPerfectMatch(this.contextSet, trigger);
    }

    @Override
    public boolean isPartialMatch(TriggerSequence keySequence) {
        return this.manager.isPartialMatch(this.contextSet, keySequence);
    }

    @Override
    public TriggerSequence getBestSequenceFor(ParameterizedCommand command) {
        Binding binding = this.manager.getBestSequenceFor(this.contextSet, command);
        return binding == null ? null : binding.getTriggerSequence();
    }

    @Override
    public Collection<TriggerSequence> getSequencesFor(ParameterizedCommand command) {
        Collection<Binding> bindings = this.manager.getSequencesFor(this.contextSet, command);
        ArrayList<TriggerSequence> sequences = new ArrayList<TriggerSequence>(bindings.size());
        for (Binding binding : bindings) {
            sequences.add(binding.getTriggerSequence());
        }
        return sequences;
    }

    @Override
    public Collection<Binding> getBindingsFor(ParameterizedCommand command) {
        return this.manager.getBindingsFor(this.contextSet, command);
    }

    @Override
    public boolean isPerfectMatch(TriggerSequence sequence) {
        return this.getPerfectMatch(sequence) != null;
    }

    @Override
    public Collection<Binding> getPartialMatches(TriggerSequence sequence) {
        return this.manager.getPartialMatches(this.contextSet, sequence);
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    @Inject
    private void setContextIds(@Named(value="activeContexts") @Optional Set<String> set) {
        if (set == null || set.isEmpty() || this.contextManager == null) {
            this.contextSet = ContextSet.EMPTY;
            return;
        }
        HashSet<Context> contexts = new HashSet<Context>();
        block2: for (String id : set) {
            while (id != null) {
                Context context = this.contextManager.getContext(id);
                if (!contexts.add(context) || !context.isDefined()) continue block2;
                try {
                    id = context.getParentId();
                }
                catch (NotDefinedException notDefinedException) {
                    // empty catch block
                }
            }
        }
        this.contextSet = this.manager.createContextSet(contexts);
    }

    @Override
    public Collection<Binding> getActiveBindings() {
        return this.manager.getActiveBindings();
    }
}

