/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.snapshot.SnapshotFormat;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.RegistryReader;
import org.eclipse.mat.util.SimpleStringTokenizer;

public class ParserRegistry
extends RegistryReader<Parser> {
    private static final String ID = "id";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String NAME = "name";
    private static final String DYNAMIC = "dynamic";
    public static final String INDEX_BUILDER = "indexBuilder";
    public static final String OBJECT_READER = "objectReader";
    public static final String CONTENT_TYPE_BINDING = "contentTypeBinding";
    public static final String CONTENT_TYPE_ID = "contentTypeId";

    public ParserRegistry(IExtensionTracker tracker) {
        this.init(tracker, "org.eclipse.mat.parser.parser");
    }

    public Parser createDelegate(IConfigurationElement configElement) {
        String dynamic = configElement.getAttribute(DYNAMIC);
        String fileExtensions = configElement.getAttribute(FILE_EXTENSION);
        if ((fileExtensions == null || fileExtensions.length() == 0) && dynamic == null) {
            return null;
        }
        try {
            String[] extensions = SimpleStringTokenizer.split((String)fileExtensions, (char)',');
            Pattern[] patterns = new Pattern[extensions.length];
            int ii = 0;
            while (ii < extensions.length) {
                patterns[ii] = Pattern.compile("(.*\\.)((?i)" + extensions[ii] + ")(\\.[0-9]*)?");
                ++ii;
            }
            SnapshotFormat snapshotFormat = new SnapshotFormat(configElement.getAttribute(NAME), extensions);
            if (dynamic != null) {
                return new DynamicParser(configElement, snapshotFormat, patterns);
            }
            return new Parser(configElement, snapshotFormat, patterns, null, null);
        }
        catch (PatternSyntaxException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, MessageUtil.format((String)Messages.ParserRegistry_ErrorCompilingFileNamePattern, (Object[])new Object[]{configElement.getNamespaceIdentifier()}), e);
            return null;
        }
    }

    protected void removeDelegate(Parser delegate) {
    }

    public Parser lookupParser(String uniqueIdentifier) {
        for (Parser p : this.delegates()) {
            if (!uniqueIdentifier.equals(p.getUniqueIdentifier())) continue;
            return p;
        }
        return null;
    }

    public List<Parser> matchParser(String fileName) {
        ArrayList<Parser> answer = new ArrayList<Parser>();
        block0: for (Parser p : this.delegates()) {
            Pattern[] patternArray = p.pattern;
            int n = patternArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern regex = patternArray[n2];
                if (regex.matcher(fileName).matches()) {
                    answer.add(p);
                    continue block0;
                }
                ++n2;
            }
        }
        return answer;
    }

    public List<Parser> matchParser(IContentType contentType) {
        ArrayList<Parser> answer = new ArrayList<Parser>();
        block0: for (Parser p : this.delegates()) {
            IContentType tp = contentType;
            while (tp != null) {
                String[] stringArray = p.contentTypes;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    if (tp.getId().equals(type)) {
                        answer.add(p);
                        continue block0;
                    }
                    ++n2;
                }
                tp = tp.getBaseType();
            }
        }
        return answer;
    }

    public Collection<Parser> delegates() {
        Collection<Parser> res = super.delegates();
        HashSet<Parser> res2 = new HashSet<Parser>();
        boolean foundDynamic = false;
        for (Parser p : res) {
            if (p instanceof DynamicParser) {
                foundDynamic = true;
                Map mp = p.create(Map.class, DYNAMIC);
                if (mp == null) continue;
                for (Map m : mp.values()) {
                    String id = (String)m.get(ID);
                    String name = (String)m.get(NAME);
                    String fileExtensions = (String)m.get(FILE_EXTENSION);
                    if (fileExtensions == null || fileExtensions.length() == 0) continue;
                    try {
                        String[] extensions = SimpleStringTokenizer.split((String)fileExtensions, (char)',');
                        Pattern[] patterns = new Pattern[extensions.length];
                        int ii = 0;
                        while (ii < extensions.length) {
                            patterns[ii] = Pattern.compile("(.*\\.)((?i)" + extensions[ii] + ")(\\.[0-9]*)?");
                            ++ii;
                        }
                        SnapshotFormat snapshotFormat = new SnapshotFormat(name, extensions);
                        String contentType = (String)m.get(CONTENT_TYPE_BINDING);
                        if (contentType != null) {
                            String[] contentTypes = SimpleStringTokenizer.split((String)contentType, (char)',');
                            res2.add(new Parser(p.configElement, id, snapshotFormat, patterns, contentTypes));
                            continue;
                        }
                        res2.add(new Parser(p.configElement, id, snapshotFormat, patterns));
                    }
                    catch (PatternSyntaxException e) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, MessageUtil.format((String)Messages.ParserRegistry_ErrorCompilingFileNamePattern, (Object[])new Object[]{p.configElement.getNamespaceIdentifier()}), e);
                    }
                }
                continue;
            }
            res2.add(p);
        }
        return foundDynamic ? Collections.unmodifiableCollection(res2) : res;
    }

    public class DynamicParser
    extends Parser {
        public DynamicParser(IConfigurationElement configElement, SnapshotFormat snapshotFormat, Pattern[] pattern) {
            super(configElement, snapshotFormat, pattern);
        }
    }

    public class Parser {
        private String id;
        private IConfigurationElement configElement;
        private SnapshotFormat snapshotFormat;
        private Pattern[] pattern;
        private String[] contentTypes;

        private Parser(IConfigurationElement configElement, String id, SnapshotFormat snapshotFormat, Pattern[] pattern, String[] contentTypes) {
            this.id = id;
            this.configElement = configElement;
            this.snapshotFormat = snapshotFormat;
            this.pattern = pattern;
            this.contentTypes = contentTypes;
        }

        private Parser(IConfigurationElement configElement, String id, SnapshotFormat snapshotFormat, Pattern[] pattern) {
            this.id = id;
            this.configElement = configElement;
            this.snapshotFormat = snapshotFormat;
            this.pattern = pattern;
            IConfigurationElement[] bindings = configElement.getChildren(ParserRegistry.CONTENT_TYPE_BINDING);
            this.contentTypes = new String[bindings.length];
            int i = 0;
            while (i < bindings.length) {
                this.contentTypes[i] = bindings[i].getAttribute(ParserRegistry.CONTENT_TYPE_ID);
                ++i;
            }
        }

        private Parser(IConfigurationElement configElement, SnapshotFormat snapshotFormat, Pattern[] pattern) {
            this(configElement, configElement.getDeclaringExtension().getSimpleIdentifier(), snapshotFormat, pattern);
        }

        public String getId() {
            return this.id;
        }

        public String getUniqueIdentifier() {
            IExtension extension = this.configElement.getDeclaringExtension();
            return String.valueOf(extension.getNamespaceIdentifier()) + "." + this.id;
        }

        public SnapshotFormat getSnapshotFormat() {
            return this.snapshotFormat;
        }

        public <I> I create(Class<I> type, String attribute) {
            try {
                return (I)this.configElement.createExecutableExtension(attribute);
            }
            catch (CoreException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageUtil.format((String)Messages.ParserRegistry_ErrorWhileCreating, (Object[])new Object[]{type.getSimpleName(), attribute}), e);
                return null;
            }
        }

        /* synthetic */ Parser(IConfigurationElement iConfigurationElement, SnapshotFormat snapshotFormat, Pattern[] patternArray, Parser parser, Parser parser2) {
            this(iConfigurationElement, snapshotFormat, patternArray);
        }
    }
}

