/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.query.results.DisplayFileResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.util.FileUtils;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class ImportReportAction
extends Action {
    private MultiPaneEditor editor;
    private File reportZipFile;

    public ImportReportAction(MultiPaneEditor editor) {
        this(editor, null);
    }

    public ImportReportAction(MultiPaneEditor editor, File reportZipFile) {
        super(Messages.ImportReportAction_OpenReport, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/import_report.gif"));
        this.editor = editor;
        this.reportZipFile = reportZipFile;
    }

    public void run() {
        block6: {
            block5: {
                if (this.reportZipFile != null) break block5;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4098);
                dialog.setText(Messages.ImportReportAction_ImportReport);
                dialog.setFilterExtensions(new String[]{"*_*.zip"});
                dialog.setFilterNames(new String[]{Messages.ImportReportAction_MemoryAnalyzerReports});
                this.prepareFilterSelection(dialog);
                dialog.open();
                String[] names = dialog.getFileNames();
                if (names == null) break block6;
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    try {
                        ImportReportAction.openReport(this.editor, new File(dialog.getFilterPath(), name));
                    }
                    catch (IOException e) {
                        ErrorHelper.logThrowableAndShowMessage(e);
                    }
                    ++n2;
                }
                break block6;
            }
            try {
                ImportReportAction.openReport(this.editor, this.reportZipFile);
            }
            catch (IOException e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        }
    }

    public static void openReport(MultiPaneEditor editor, File reportZipFile) throws IOException {
        IResult result = ImportReportAction.unzipAndOpen(reportZipFile);
        QueryResult queryResult = new QueryResult(null, String.valueOf(Messages.ImportReportAction_Report) + reportZipFile.getName(), result);
        QueryExecution.displayResult(editor, null, null, queryResult, false);
    }

    public static IResult unzipAndOpen(File reportZipFile) throws IOException {
        File targetDir = FileUtils.createTempDirectory((String)"report", null);
        FileUtils.unzipFile((File)reportZipFile, (File)targetDir);
        return new DisplayFileResult(new File(targetDir, "index.html"));
    }

    private void prepareFilterSelection(FileDialog dialog) {
        File prefixFile = new File(this.editor.getQueryContext().getPrefix());
        String prefix = prefixFile.getName();
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        dialog.setFilterPath(prefixFile.getParentFile().getAbsolutePath());
        dialog.setFileName(String.valueOf(prefix) + "_");
    }
}

