/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.presentations;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURL;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURLParser;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;

public class BrowserIntroPartLocationListener
implements LocationListener {
    private final BrowserIntroPartImplementation implementation;

    public BrowserIntroPartLocationListener(BrowserIntroPartImplementation implementation) {
        this.implementation = implementation;
    }

    public void changed(LocationEvent event) {
        String url = event.location;
        if (url == null) {
            return;
        }
        Browser browser = (Browser)event.getSource();
        if (browser.getData("navigation") != null && browser.getData("navigation").equals("true")) {
            return;
        }
        IntroModelRoot model = this.implementation.getModel();
        IntroURLParser parser = new IntroURLParser(url);
        if (!parser.hasProtocol() || parser.getHost() == null || parser.getHost().isEmpty()) {
            return;
        }
        if (model.isDynamic()) {
            if (browser.getData("frameNavigation") != null && !event.top && browser.getData("tempUrl") != null && browser.getData("tempUrl").equals("true")) {
                this.implementation.getHistory().removeLastHistory();
                this.flagRemovedTempUrl();
            }
            if (event.top) {
                this.flagStartOfFrameNavigation();
                this.implementation.updateHistory(url);
            }
            if (browser.getData("frameNavigation") == null && !event.top) {
                AbstractIntroPage currentPage = model.getCurrentPage();
                if (currentPage.isIFramePage()) {
                    currentPage.setIFrameURL(url);
                    this.implementation.updateHistory(currentPage);
                } else {
                    this.flagStartOfFrameNavigation();
                    this.flagStoredTempUrl();
                    this.implementation.updateHistory(url);
                }
            }
        }
    }

    public void changing(LocationEvent event) {
        String url = event.location;
        if (url == null) {
            return;
        }
        IntroModelRoot model = this.implementation.getModel();
        IntroURLParser parser = new IntroURLParser(url);
        if (parser.hasIntroUrl()) {
            event.doit = false;
            IntroURL introURL = parser.getIntroURL();
            introURL.execute();
            if (model.isDynamic() && introURL.getParameter("embedTarget") != null && introURL.getAction().equals("showPage")) {
                this.flagStartOfNavigation();
            }
            return;
        }
    }

    public void flagStartOfFrameNavigation() {
        if (this.implementation.getBrowser().getData("frameNavigation") == null) {
            this.implementation.getBrowser().setData("frameNavigation", (Object)"true");
        }
    }

    public void flagEndOfFrameNavigation() {
        this.implementation.getBrowser().setData("frameNavigation", null);
    }

    public void flagStartOfNavigation() {
        if (this.implementation.getBrowser().getData("navigation") == null) {
            this.implementation.getBrowser().setData("navigation", (Object)"true");
        }
    }

    public void flagEndOfNavigation() {
        this.implementation.getBrowser().setData("navigation", null);
    }

    public void flagStoredTempUrl() {
        if (this.implementation.getBrowser().getData("tempUrl") == null) {
            this.implementation.getBrowser().setData("tempUrl", (Object)"true");
        }
    }

    public void flagRemovedTempUrl() {
        this.implementation.getBrowser().setData("tempUrl", null);
    }
}

