/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.PseudoReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

public class ClassImpl
extends AbstractObjectImpl
implements IClass,
Comparable<ClassImpl> {
    private static final long serialVersionUID = 22L;
    private static final transient AtomicIntegerFieldUpdater<ClassImpl> instanceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ClassImpl.class, "instanceCount");
    private static final transient AtomicLongFieldUpdater<ClassImpl> totalSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClassImpl.class, "totalSize");
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    protected String name;
    protected int superClassId = -1;
    protected long superClassAddress;
    protected int classLoaderId = -1;
    protected long classLoaderAddress;
    protected Field[] staticFields;
    protected FieldDescriptor[] fields;
    protected int usedHeapSize;
    protected int instanceSize;
    protected volatile int instanceCount;
    protected volatile long totalSize;
    protected boolean isArrayType;
    private List<IClass> subClasses;
    private Serializable cacheEntry;

    public ClassImpl(long address, String name, long superAddress, long loaderAddress, Field[] staticFields, FieldDescriptor[] fields) {
        super(-1, address, null);
        this.name = name;
        this.superClassAddress = superAddress;
        this.classLoaderAddress = loaderAddress;
        this.staticFields = staticFields;
        this.fields = fields;
        this.instanceSize = -1;
        this.totalSize = 0L;
        this.isArrayType = name.endsWith("[]");
    }

    public Serializable getCacheEntry() {
        return this.cacheEntry;
    }

    public void setCacheEntry(Serializable cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    public void setSuperClassIndex(int superClassIndex) {
        this.superClassId = superClassIndex;
    }

    public void setClassLoaderIndex(int classLoaderIndex) {
        this.classLoaderId = classLoaderIndex;
    }

    public int[] getObjectIds() throws UnsupportedOperationException, SnapshotException {
        try {
            return this.source.getIndexManager().c2objects().getObjectsOf(this.cacheEntry);
        }
        catch (IOException e) {
            throw new SnapshotException((Throwable)e);
        }
    }

    public long getRetainedHeapSizeOfObjects(boolean calculateIfNotAvailable, boolean approximation, IProgressListener listener) throws SnapshotException {
        long answer = this.source.getRetainedSizeCache().get(this.getObjectId());
        if (answer > 0L || !calculateIfNotAvailable) {
            return answer;
        }
        if (answer < 0L && approximation) {
            return answer;
        }
        if (listener == null) {
            listener = new VoidProgressListener();
        }
        ArrayInt ids = new ArrayInt(1 + this.getNumberOfObjects());
        ids.add(this.getObjectId());
        ids.addAll(this.getObjectIds());
        long retainedSize = 0L;
        if (!approximation) {
            int[] retainedSet = this.source.getRetainedSet(ids.toArray(), listener);
            if (listener.isCanceled()) {
                return 0L;
            }
            retainedSize = this.source.getHeapSize(retainedSet);
        } else {
            retainedSize = this.source.getMinRetainedSize(ids.toArray(), listener);
            if (listener.isCanceled()) {
                return 0L;
            }
        }
        if (approximation) {
            retainedSize = -retainedSize;
        }
        this.source.getRetainedSizeCache().put(this.getObjectId(), retainedSize);
        return retainedSize;
    }

    @Override
    public long getUsedHeapSize() {
        return this.usedHeapSize;
    }

    @Override
    public ArrayLong getReferences() {
        ArrayLong answer = new ArrayLong(this.staticFields.length);
        answer.add(this.classInstance.getObjectAddress());
        if (this.superClassAddress != 0L) {
            answer.add(this.superClassAddress);
        }
        answer.add(this.classLoaderAddress);
        int ii = 0;
        while (ii < this.staticFields.length) {
            if (this.staticFields[ii].getValue() instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)this.staticFields[ii].getValue();
                answer.add(ref.getObjectAddress());
            }
            ++ii;
        }
        return answer;
    }

    public List<NamedReference> getOutboundReferences() {
        LinkedList<NamedReference> answer = new LinkedList<NamedReference>();
        answer.add((NamedReference)new PseudoReference((ISnapshot)this.source, this.classInstance.getObjectAddress(), "<class>"));
        if (this.superClassAddress != 0L) {
            answer.add((NamedReference)new PseudoReference((ISnapshot)this.source, this.superClassAddress, "<super>"));
        }
        answer.add((NamedReference)new PseudoReference((ISnapshot)this.source, this.classLoaderAddress, "<classloader>"));
        int ii = 0;
        while (ii < this.staticFields.length) {
            if (this.staticFields[ii].getValue() instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)this.staticFields[ii].getValue();
                String fieldName = this.staticFields[ii].getName();
                if (fieldName.startsWith("<")) {
                    answer.add((NamedReference)new PseudoReference((ISnapshot)this.source, ref.getObjectAddress(), fieldName));
                } else {
                    answer.add(new NamedReference((ISnapshot)this.source, ref.getObjectAddress(), fieldName));
                }
            }
            ++ii;
        }
        return answer;
    }

    public long getClassLoaderAddress() {
        return this.classLoaderAddress;
    }

    public void setClassLoaderAddress(long address) {
        this.classLoaderAddress = address;
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return Arrays.asList(this.fields);
    }

    public int getNumberOfObjects() {
        return this.instanceCount;
    }

    public long getHeapSizePerInstance() {
        return this.instanceSize;
    }

    public void setHeapSizePerInstance(long size) {
        this.instanceSize = (int)Math.min(size, Integer.MAX_VALUE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Field> getStaticFields() {
        return Arrays.asList(this.staticFields);
    }

    public long getSuperClassAddress() {
        return this.superClassAddress;
    }

    public int getSuperClassId() {
        return this.superClassId;
    }

    public ClassImpl getSuperClass() {
        try {
            return this.superClassAddress != 0L ? (ClassImpl)this.source.getObject(this.superClassId) : null;
        }
        catch (SnapshotException e) {
            throw new IllegalStateException(e);
        }
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public boolean hasSuperClass() {
        return this.superClassAddress != 0L;
    }

    @Override
    public int compareTo(ClassImpl other) {
        long otherAddress;
        long myAddress = this.getObjectAddress();
        return myAddress > (otherAddress = other.getObjectAddress()) ? 1 : (myAddress == otherAddress ? 0 : -1);
    }

    public void addInstance(long usedHeapSize) {
        instanceCountUpdater.getAndAdd(this, 1);
        totalSizeUpdater.getAndAdd(this, usedHeapSize);
    }

    public void removeInstance(long heapSizePerInstance) {
        instanceCountUpdater.getAndAdd(this, -1);
        totalSizeUpdater.getAndAdd(this, -heapSizePerInstance);
    }

    void removeInstanceBulk(int instanceCount, long heapSize) {
        instanceCountUpdater.getAndAdd(this, -instanceCount);
        totalSizeUpdater.getAndAdd(this, heapSize);
    }

    public List<IClass> getSubclasses() {
        return this.subClasses != null ? this.subClasses : Collections.EMPTY_LIST;
    }

    public List<IClass> getAllSubclasses() {
        if (this.subClasses == null || this.subClasses.isEmpty()) {
            return new ArrayList<IClass>();
        }
        ArrayList<IClass> answer = new ArrayList<IClass>(this.subClasses.size() * 2);
        answer.addAll(this.subClasses);
        for (IClass subClass : this.subClasses) {
            answer.addAll(subClass.getAllSubclasses());
        }
        return answer;
    }

    @Override
    protected StringBuffer appendFields(StringBuffer buf) {
        return super.appendFields(buf).append(";name=").append(this.getName());
    }

    public boolean isArrayType() {
        return this.isArrayType;
    }

    @Override
    public String getTechnicalName() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("class ");
        builder.append(this.getName());
        builder.append(" @ 0x");
        builder.append(Long.toHexString(this.getObjectAddress()));
        return builder.toString();
    }

    @Override
    protected Field internalGetField(String name) {
        Field[] fieldArray = this.staticFields;
        int n = this.staticFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getName().equals(name)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public int getClassLoaderId() {
        return this.classLoaderId;
    }

    public void addSubClass(ClassImpl clazz) {
        if (this.subClasses == null) {
            this.subClasses = new ArrayList<IClass>();
        }
        this.subClasses.add(clazz);
    }

    public void removeSubClass(ClassImpl clazz) {
        this.subClasses.remove(clazz);
    }

    public void setUsedHeapSize(long usedHeapSize) {
        this.usedHeapSize = (int)Math.min(usedHeapSize, Integer.MAX_VALUE);
    }

    public boolean doesExtend(String className) throws SnapshotException {
        if (className.equals(this.name)) {
            return true;
        }
        return this.hasSuperClass() ? ((ClassImpl)this.source.getObject(this.superClassId)).doesExtend(className) : false;
    }

    @Override
    public void setSnapshot(ISnapshot dump) {
        super.setSnapshot(dump);
        Field[] fieldArray = this.staticFields;
        int n = this.staticFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getValue() instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)f.getValue();
                f.setValue((Object)new ObjectReference(dump, ref.getObjectAddress()));
            }
            ++n2;
        }
    }
}

