/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.edit.provider;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.mdht.uml.common.notation.NotationUtil;
import org.eclipse.mdht.uml.edit.IUMLTableProperties;
import org.eclipse.mdht.uml.edit.internal.Logger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.edit.providers.ExtensionItemProvider;

public class ExtensionExtItemProvider
extends ExtensionItemProvider
implements ITableItemLabelProvider,
ICellModifier {
    public ExtensionExtItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getImage(Object object) {
        return super.getImage(object);
    }

    public String getText(Object object) {
        return "metaclass";
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        return Collections.emptyList();
    }

    public Object getParent(Object object) {
        Extension extension = (Extension)object;
        return extension.getStereotype();
    }

    public Collection<?> getChildren(Object object) {
        return super.getChildren(object);
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        Extension extension = (Extension)object;
        if (extension.getNearestPackage() == null) {
            return null;
        }
        Class metaclass = extension.getMetaclass();
        switch (columnIndex) {
            case 0: {
                return this.getImage(object);
            }
            case 1: {
                IItemLabelProvider provider;
                if (metaclass != null && (provider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)metaclass, IItemLabelProvider.class)) != null) {
                    return provider.getImage((Object)metaclass);
                }
            }
            case 5: {
                return NotationUtil.getAnnotationImage((Element)extension);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Extension extension = (Extension)element;
        if (extension.getNearestPackage() == null) {
            return null;
        }
        Class metaclass = extension.getMetaclass();
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                return metaclass == null ? null : metaclass.getName();
            }
            case 4: {
                if (VisibilityKind.PUBLIC_LITERAL == extension.getVisibility()) {
                    return "";
                }
                return extension.getVisibility().getName();
            }
            case 5: {
                return NotationUtil.getAnnotation((Element)extension);
            }
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return false;
        }
        if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
            return true;
        }
        if ("multiplicity".equals(property)) {
            return false;
        }
        if (IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
            return false;
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        Extension extension = (Extension)element;
        if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
            return extension.getMetaclass();
        }
        return null;
    }

    public void modify(Object element, final String property, final Object value) {
        final Extension extension = (Extension)element;
        final Profile profile = (Profile)extension.getPackage();
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)extension);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (IUMLTableProperties.TYPE_PROPERTY.equals(property) && value instanceof Class) {
                        Class metaclass = (Class)value;
                        this.setLabel("Set Metaclass");
                        extension.metaclassEnd().setType((Type)metaclass);
                        if (!profile.getReferencedMetaclasses().contains((Object)metaclass) && !profile.getReferencedMetamodels().contains((Object)metaclass.getModel())) {
                            profile.createMetaclassReference((PackageableElement)metaclass);
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected Command createCreateCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return null;
    }
}

