/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.internal.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.emf.runtime.resource.XSITypeProvider;
import org.eclipse.mdht.uml.cda.CDAPackage;
import org.eclipse.mdht.uml.cda.RegistryDelegate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDAXSITypeProvider
implements XSITypeProvider {
    protected static final String CDA_ANNOTATION_SOURCE = "http://www.openhealthtools.org/mdht/uml/cda/annotation";
    protected static final String TEMPLATE_ID_ROOT = "templateId.root";
    protected static final String TEMPLATE_ID_EXTENSION = "templateId.extension";
    private static final String CONTEXT_DEPENDENT = "contextDependent";
    private static final String REGISTRY_DELEGATE = "registryDelegate";
    private final Map<String, EClass> allDocumentClasses = new HashMap<String, EClass>();
    private final Map<String, EClass> classes = new HashMap<String, EClass>();
    private final Map<EClass, RegistryDelegate> delegates = new HashMap<EClass, RegistryDelegate>();
    private final EClass documentClass;
    private String preffered = null;

    public CDAXSITypeProvider() {
        this((EClass)null);
    }

    public CDAXSITypeProvider(EClass documentClass) {
        this.load();
        this.documentClass = documentClass;
    }

    public CDAXSITypeProvider(String documentClassQName) {
        this.load();
        this.documentClass = documentClassQName == null ? null : this.allDocumentClasses.get(documentClassQName);
    }

    public EClass getXSIType(Element element) {
        EClass result = null;
        int last = 0;
        NodeList nodeList = element.getChildNodes();
        ArrayList<EClass> potentialTemplates = new ArrayList<EClass>();
        int i = 0;
        while (i < nodeList.getLength()) {
            EClass eClass;
            Element e;
            if (nodeList.item(i) instanceof Element && "templateId".equals((e = (Element)nodeList.item(i)).getLocalName()) && (eClass = this.getEClass(e.getAttributeNS(null, "root"), e.getAttributeNS(null, "extension"), element)) != null) {
                potentialTemplates.add(eClass);
            }
            ++i;
        }
        if (!potentialTemplates.isEmpty()) {
            EClass type = this.getType(element);
            if (potentialTemplates.size() == 1) {
                result = (EClass)potentialTemplates.get(0);
            } else if (this.preffered != null) {
                for (EClass potentialTemplate : potentialTemplates) {
                    if (!this.preffered.equals(potentialTemplate.getEPackage().getNsURI()) || potentialTemplate == null || potentialTemplate.isAbstract() || !this.conformsTo(potentialTemplate, type) || potentialTemplate.getEAllSuperTypes().size() <= last) continue;
                    result = potentialTemplate;
                    last = potentialTemplate.getEAllSuperTypes().size();
                }
                if (result == null) {
                    for (EClass potentialTemplate : potentialTemplates) {
                        if (potentialTemplate == null || potentialTemplate.isAbstract() || !this.conformsTo(potentialTemplate, type) || potentialTemplate.getEAllSuperTypes().size() <= last) continue;
                        result = potentialTemplate;
                        last = potentialTemplate.getEAllSuperTypes().size();
                    }
                }
            } else {
                for (EClass potentialTemplate : potentialTemplates) {
                    if (potentialTemplate == null || potentialTemplate.isAbstract() || !this.conformsTo(potentialTemplate, type) || potentialTemplate.getEAllSuperTypes().size() <= last) continue;
                    result = potentialTemplate;
                    last = potentialTemplate.getEAllSuperTypes().size();
                }
            }
        }
        if (result != null && element.getLocalName().equals("ClinicalDocument")) {
            this.preffered = result.getEPackage().getNsURI();
        }
        return result;
    }

    private List<String> getPath(Element element) {
        LinkedList<String> result = new LinkedList<String>();
        result.addFirst(element.getLocalName());
        Node parent = element.getParentNode();
        while (parent instanceof Element) {
            Element e = (Element)parent;
            result.addFirst(e.getLocalName());
            parent = e.getParentNode();
        }
        return result;
    }

    protected EClass getType(Element element) {
        EClass eClass = CDAPackage.Literals.DOCUMENT_ROOT;
        List<String> path = this.getPath(element);
        for (String component : path) {
            EStructuralFeature feature = this.getEStructuralFeature(eClass, component);
            if (feature instanceof EReference) {
                eClass = (EClass)feature.getEType();
                continue;
            }
            return null;
        }
        return eClass;
    }

    private EStructuralFeature getEStructuralFeature(EClass eClass, String name) {
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!name.equals(this.getName((ENamedElement)feature))) continue;
            return feature;
        }
        return null;
    }

    protected boolean conformsTo(EClass eClass, EClass type) {
        if (eClass == null || type == null) {
            return false;
        }
        return type.isSuperTypeOf(eClass);
    }

    private String getName(ENamedElement eNamedElement) {
        String result = EcoreUtil.getAnnotation((EModelElement)eNamedElement, (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"name");
        if (result != null) {
            return result;
        }
        return eNamedElement.getName();
    }

    protected EClass getEClass(String templateId, String versionId, Object context) {
        if (this.documentClass != null && context instanceof Element && ((Element)context).getLocalName().equals("ClinicalDocument")) {
            return this.documentClass;
        }
        String key = null;
        key = !CDAXSITypeProvider.isEmpty(versionId) ? String.valueOf(templateId) + "v" + versionId : templateId;
        EClass eClass = this.classes.get(key);
        if (this.delegates.containsKey(eClass)) {
            RegistryDelegate delegate = this.delegates.get(eClass);
            eClass = delegate.getEClass(key, context);
        }
        return eClass;
    }

    public Map<String, EClass> getAllDocumentClasses() {
        return this.allDocumentClasses;
    }

    public EClass getDocumentClass() {
        return this.documentClass;
    }

    protected static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void load() {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        EClass clinicalDocumentClass = (EClass)CDAPackage.eINSTANCE.getEClassifier("ClinicalDocument");
        String[] stringArray = registry.keySet().toArray(new String[registry.size()]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            try {
                EPackage ePackage = registry.getEPackage(key);
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    try {
                        String templateId;
                        if (!(eClassifier instanceof EClass)) continue;
                        if (clinicalDocumentClass != null && clinicalDocumentClass.isSuperTypeOf((EClass)eClassifier)) {
                            String qname = String.valueOf(eClassifier.getEPackage().getNsPrefix()) + "::" + eClassifier.getName();
                            this.allDocumentClasses.put(qname, (EClass)eClassifier);
                        }
                        if (CDAXSITypeProvider.isEmpty(templateId = EcoreUtil.getAnnotation((EModelElement)eClassifier, (String)CDA_ANNOTATION_SOURCE, (String)TEMPLATE_ID_ROOT))) continue;
                        String templateVersion = EcoreUtil.getAnnotation((EModelElement)eClassifier, (String)CDA_ANNOTATION_SOURCE, (String)TEMPLATE_ID_EXTENSION);
                        if (!CDAXSITypeProvider.isEmpty(templateVersion)) {
                            templateId = String.valueOf(templateId) + "v" + templateVersion;
                        }
                        if (this.classes.keySet().contains(templateId)) continue;
                        String contextDependent = EcoreUtil.getAnnotation((EModelElement)eClassifier, (String)CDA_ANNOTATION_SOURCE, (String)CONTEXT_DEPENDENT);
                        if ("true".equals(contextDependent)) {
                            String registryDelegate = EcoreUtil.getAnnotation((EModelElement)ePackage, (String)CDA_ANNOTATION_SOURCE, (String)REGISTRY_DELEGATE);
                            EClass eClass = (EClass)ePackage.getEClassifier(registryDelegate);
                            this.classes.put(templateId, eClass);
                            if (this.delegates.containsKey(eClass)) continue;
                            this.delegates.put(eClass, (RegistryDelegate)EcoreUtil.create((EClass)eClass));
                            continue;
                        }
                        this.classes.put(templateId, (EClass)eClassifier);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }
}

