/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.dita.DitaTransformerOptions;
import org.eclipse.mdht.uml.cda.dita.TransformCDA;
import org.eclipse.mdht.uml.cda.dita.TransformClass;
import org.eclipse.mdht.uml.cda.dita.TransformClassContent;
import org.eclipse.mdht.uml.cda.dita.TransformPackage;
import org.eclipse.mdht.uml.cda.dita.TransformValueSet;
import org.eclipse.mdht.uml.cda.dita.internal.Logger;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class DitaTransformer {
    private DitaTransformerOptions transformerOptions;
    Set<Class> alreadyHandledClassesForTerminologyChecking = new HashSet<Class>();

    public DitaTransformer() {
        this(new DitaTransformerOptions());
    }

    public DitaTransformer(DitaTransformerOptions options) {
        this.transformerOptions = options;
        if (this.transformerOptions.getBaseURL() != null) {
            CDAModelUtil.INFOCENTER_URL = this.transformerOptions.getBaseURL();
        }
    }

    public void transformElement(Element element) {
        Boolean prevCard = CDAModelUtil.cardinalityAfterElement;
        CDAModelUtil.cardinalityAfterElement = this.transformerOptions.isCardinalityAfterElement();
        CDAModelUtil.isAppendConformanceRules = this.transformerOptions.isAppendConformanceRules();
        UMLSwitch<Object> pubList = new UMLSwitch<Object>(){

            public Object caseClassifier(Classifier classifier) {
                DitaTransformer.this.transformerOptions.getPubClassifiers().add(classifier);
                return classifier;
            }

            public Object caseElementImport(ElementImport elementImport) {
                if (elementImport.getImportedElement() instanceof Classifier) {
                    DitaTransformer.this.transformerOptions.getPubClassifiers().add((Classifier)elementImport.getImportedElement());
                }
                return elementImport;
            }
        };
        TreeIterator pubListIterator = EcoreUtil.getAllContents(Collections.singletonList(element));
        while (pubListIterator != null && pubListIterator.hasNext()) {
            EObject child = (EObject)pubListIterator.next();
            pubList.doSwitch(child);
        }
        TransformPackage transformPackage = new TransformPackage(this.transformerOptions);
        TransformClass transformClass = new TransformClass(this.transformerOptions);
        TransformClassContent transformClassProperties = new TransformClassContent(this.transformerOptions);
        TransformValueSet transformValueSet = new TransformValueSet(this.transformerOptions);
        TransformCDA generateSections = new TransformCDA(this.transformerOptions);
        File templateDirectory = new File(this.transformerOptions.getOutputPath().removeLastSegments(1).append("templates").toOSString());
        boolean useTemplates = templateDirectory.isDirectory();
        try {
            TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
            while (iterator != null && iterator.hasNext()) {
                EObject child = (EObject)iterator.next();
                if (child instanceof ElementImport) {
                    child = ((ElementImport)child).getImportedElement();
                }
                if (child == null) continue;
                transformPackage.doSwitch(child);
                if (child instanceof Class && (!CDAModelUtil.isInlineClass((Class)((Class)child)) || CDAModelUtil.isPublishSeperately((Class)((Class)child)))) {
                    if (useTemplates) {
                        generateSections.doSwitch(child);
                    } else {
                        transformClass.doSwitch(child);
                    }
                    transformClassProperties.doSwitch(child);
                    this.checkTerminologyReferences((Class)child, transformValueSet);
                }
                transformValueSet.doSwitch(child);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.logException(e);
        }
        for (Package umlPackage : this.transformerOptions.getPackageContentMap().keySet()) {
            String normalizedPackageName = UML2Util.getValidJavaIdentifier((String)umlPackage.getName());
            this.writeMapFile("classes", "package_" + normalizedPackageName, "Package: " + umlPackage.getName(), this.transformerOptions.getPackageContentList(umlPackage));
        }
        this.writeMapFile("classes", "document", "Document Templates", this.transformerOptions.getDocumentList());
        this.writeMapFile("classes", "section", "Section Templates", this.transformerOptions.getSectionList());
        this.writeMapFile("classes", "clinicalstatement", "Clinical Statement Templates", this.transformerOptions.getClinicalStatementList());
        this.writeMapFile("classes", "classes", "Other Classes", this.transformerOptions.getClassList());
        this.writeMapFile("terminology", "valueset", "Value Sets", this.transformerOptions.getValueSetList());
        this.writeMapFile("classes", "references", "References", this.transformerOptions.getReferencesList());
        CDAModelUtil.cardinalityAfterElement = prevCard;
    }

    private void writeMapFile(String folder, String name, String title, List<String> fileNames) {
        Collections.sort(fileNames);
        IPath filePath = this.transformerOptions.getOutputPath().append(folder).addTrailingSeparator().append(name).addFileExtension("ditamap");
        File file = filePath.toFile();
        try (PrintWriter writer = null;){
            try {
                file.createNewFile();
                writer = new PrintWriter(file);
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<!DOCTYPE map PUBLIC \"-//OASIS//DTD DITA Map//EN\" \"map.dtd\">");
                writer.println("<map title=\"" + title + "\">");
                for (String fileName : fileNames) {
                    writer.println("<topicref href=\"" + fileName + "\" type=\"topic\" />");
                }
                writer.println("</map>");
            }
            catch (FileNotFoundException e) {
                Logger.logException(e);
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                Logger.logException(e1);
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private void checkTerminologyReferences(Class umlClass, UMLSwitch<Object> transformValueSet) {
        Class class1;
        if (!this.alreadyHandledClassesForTerminologyChecking.add(umlClass)) {
            return;
        }
        if (CDAModelUtil.isCDAModel((Element)umlClass) || CDAModelUtil.isDatatypeModel((Element)umlClass)) {
            return;
        }
        for (Property property : umlClass.getOwnedAttributes()) {
            if (property.getType() instanceof Class) {
                class1 = (Class)property.getType();
                this.checkTerminologyReferences(class1, transformValueSet);
            }
            Enumeration enumeration = null;
            if (property.getType() instanceof Enumeration) {
                enumeration = (Enumeration)property.getType();
            }
            Stereotype codeSystemConstraint = TermProfileUtil.getAppliedStereotype((Element)property, (String)"CodeSystemConstraint");
            ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)property);
            if (property.getAssociation() == null && codeSystemConstraint == null && valueSetConstraint != null && valueSetConstraint.getReference() != null && valueSetConstraint.getReference().getBase_Enumeration() != null) {
                enumeration = valueSetConstraint.getReference().getBase_Enumeration();
            }
            if (enumeration == null || enumeration.eResource() == null || !enumeration.eResource().getURI().toString().endsWith("-vocab.uml")) continue;
            transformValueSet.doSwitch((EObject)enumeration);
        }
        for (Generalization generalization : umlClass.getGeneralizations()) {
            if (!(generalization.getGeneral() instanceof Class)) continue;
            class1 = (Class)generalization.getGeneral();
            this.checkTerminologyReferences(class1, transformValueSet);
        }
    }
}

