/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mdht.uml.cda.dita.internal.Activator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class DitaTransformerOptions {
    public static final String BASE_URL = "baseURL";
    public static final String INCLUDE_TABLE_VIEW = "includeTableView";
    public static final String INCLUDE_USAGE_NOTES = "includeUsageNotes";
    public static final String INCLUDE_VOCABULARY_CONSTRAINTS = "includeVocabularyConstraints";
    public static final String CARDINALITY_AFTER_ELEMENT = "cardinalityAfterElement";
    public static final String APPEND_CONFORMANCE_RULES_ATTRIBUTE = "appendConformanceRules";
    public static final String EXAMPLE_DEPTH = "exampleDepth";
    private IPath outputPath = null;
    private String baseURL = null;
    private boolean includeTableView = false;
    private boolean includeUsageNotes = false;
    private boolean cardinalityAfterElement = false;
    private boolean appendConformanceRules = false;
    private boolean noVerticalLinesInTables;
    private boolean includeVocabularyConstraints = false;
    private boolean printTerminologyConstraintAsList = false;
    private boolean printAssigningAuthorityName = false;
    private boolean reset = false;
    private int exampleDepth;
    private List<EPackage> ePackages = new Vector<EPackage>();
    private List<Element> deletedElementList = new Vector<Element>();
    private Map<Package, List<String>> packageContentMap = new HashMap<Package, List<String>>();
    private List<String> documentList = new Vector<String>();
    private List<String> sectionList = new Vector<String>();
    private List<String> clinicalStatementList = new Vector<String>();
    private List<String> classList = new Vector<String>();
    private List<String> valueSetList = new Vector<String>();
    private HashMap<String, String> referenceList = new HashMap();
    private List<Classifier> pubClassifiers = new Vector<Classifier>();
    private String xmlGeneratorType = null;

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public int getExampleDepth() {
        return this.exampleDepth;
    }

    public void setExampleDepth(int exampleDepth) {
        this.exampleDepth = exampleDepth;
    }

    public DitaTransformerOptions() {
        this.initializePreferences();
    }

    private void initializePreferences() {
        Preferences store = Activator.getDefault().getPluginPreferences();
        if (store.getString(BASE_URL) != null && store.getString(BASE_URL).length() > 0) {
            this.baseURL = store.getString(BASE_URL);
        }
        this.includeTableView = store.getBoolean(INCLUDE_TABLE_VIEW);
        this.includeUsageNotes = store.getBoolean(INCLUDE_USAGE_NOTES);
        this.includeVocabularyConstraints = store.getBoolean(INCLUDE_VOCABULARY_CONSTRAINTS);
        this.cardinalityAfterElement = store.getBoolean(CARDINALITY_AFTER_ELEMENT);
        this.appendConformanceRules = store.getBoolean(APPEND_CONFORMANCE_RULES_ATTRIBUTE);
        this.exampleDepth = store.getInt(EXAMPLE_DEPTH);
    }

    public boolean isIncludeUsageNotes() {
        return this.includeUsageNotes;
    }

    public boolean isCardinalityAfterElement() {
        return this.cardinalityAfterElement;
    }

    public boolean isAppendConformanceRules() {
        return this.appendConformanceRules;
    }

    public boolean isNoVerticalLinesInTables() {
        return this.noVerticalLinesInTables;
    }

    public boolean isIncludeTableView() {
        return this.includeTableView;
    }

    public void setIncludeTableView(boolean includeTableView) {
        this.includeTableView = includeTableView;
    }

    public void setIncludeUsageNotes(boolean includeUsageNotes) {
        this.includeUsageNotes = includeUsageNotes;
    }

    public void setCardinalityAfterElement(boolean cardinalityAfterElement) {
        this.cardinalityAfterElement = cardinalityAfterElement;
    }

    public void setXmlGeneratorType(String xmlGeneratorType) {
        this.xmlGeneratorType = xmlGeneratorType;
    }

    public String getXmlGeneratorType() {
        return this.xmlGeneratorType;
    }

    public void setAppendConformanceRules(boolean appendConformanceRules) {
        this.appendConformanceRules = appendConformanceRules;
    }

    public void setNoVerticalLinesInTables(Boolean noVerticalLinesInTables) {
        this.noVerticalLinesInTables = noVerticalLinesInTables;
    }

    public boolean isIncludeVocabularyConstraints() {
        return this.includeVocabularyConstraints;
    }

    public void setIncludeVocabularyConstraints(boolean includeVocabularyConstraints) {
        this.includeVocabularyConstraints = includeVocabularyConstraints;
    }

    public boolean isPrintTerminologyConstraintAsList() {
        return this.printTerminologyConstraintAsList;
    }

    public void setPrintTerminologyConstraintAsList(boolean printTerminologyConstraintAsList) {
        this.printTerminologyConstraintAsList = printTerminologyConstraintAsList;
    }

    public boolean isPrintAssigningAuthorityName() {
        return this.printAssigningAuthorityName;
    }

    public void setPrintAssigningAuthorityName(boolean printAssigningAuthorityName) {
        this.printAssigningAuthorityName = printAssigningAuthorityName;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    public IPath getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(IPath path) {
        this.outputPath = path;
        if (!this.outputPath.hasTrailingSeparator()) {
            this.outputPath = this.outputPath.addTrailingSeparator();
        }
    }

    protected List<Classifier> getPubClassifiers() {
        return this.pubClassifiers;
    }

    protected List<Element> getDeletedElementList() {
        return this.deletedElementList;
    }

    protected Map<Package, List<String>> getPackageContentMap() {
        return this.packageContentMap;
    }

    protected List<String> getPackageContentList(Package pkg) {
        List<String> contentList = this.packageContentMap.get(pkg);
        if (contentList == null) {
            contentList = new Vector<String>();
            this.packageContentMap.put(pkg, contentList);
        }
        return contentList;
    }

    protected List<String> getDocumentList() {
        return this.documentList;
    }

    protected List<String> getSectionList() {
        return this.sectionList;
    }

    protected void addReference(String key, String value) {
        if (!this.referenceList.containsKey(key)) {
            this.referenceList.put(key, value);
        }
    }

    protected List<String> getClinicalStatementList() {
        return this.clinicalStatementList;
    }

    protected List<String> getClassList() {
        return this.classList;
    }

    protected List<String> getValueSetList() {
        return this.valueSetList;
    }

    public List<EPackage> getEPackages() {
        return this.ePackages;
    }

    public void setEPackages(List<EPackage> packages) {
        this.ePackages = packages;
    }

    public void addEPackage(Class<EPackage> ePackageClass) {
        try {
            EPackage ePackage = (EPackage)ePackageClass.getField("eINSTANCE").get(null);
            this.ePackages.add(ePackage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> getReferencesList() {
        ArrayList<String> ls = new ArrayList<String>();
        ls.addAll(this.referenceList.values());
        return ls;
    }
}

