/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.core.AntClasspathEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimeVersion;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mdht.dita.ui.util.DitaUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.ui.actions.ImportDitaReferences;
import org.eclipse.mdht.uml.cda.ui.editors.MDHTPreferences;
import org.eclipse.mdht.uml.cda.ui.internal.Activator;
import org.eclipse.mdht.uml.cda.ui.util.CDAUIUtil;
import org.eclipse.uml2.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ecore.importer.UMLImporter;

public class CDABuilder
extends IncrementalProjectBuilder {
    private static final QualifiedName cleanStatus = new QualifiedName("org.eclipse.mdht.uml.cda.ui.builder", "status");
    public static final String BUILDER_ID = "org.eclipse.mdht.uml.cda.ui.org.eclipse.mdht.uml.cda.builder.id";
    private static final String ANNOTATIONSOURCE = "http://www.eclipse.org/emf/2002/GenModel/importer/org.eclipse.uml2.uml.ecore.importer";
    private static final String ECOREIMPORTER = "org.eclipse.uml2.uml.ecore.importer";
    private static final String VALIDATEPREFIX = "validate";
    private static final String TEMPLATESDIR = "/org.eclipse.mdht.uml.cda/templates";
    private static final ArrayList<String> EMPTYLIST = new ArrayList();

    private static boolean checkBuildStatus(IProject modelProject, IProject project) {
        long lastGenerated;
        long modelModification;
        block11: {
            modelModification = -1L;
            lastGenerated = -1L;
            Boolean projectStatus = (Boolean)project.getSessionProperty(cleanStatus);
            if (projectStatus == null || !projectStatus.equals(Boolean.TRUE)) break block11;
            project.setSessionProperty(cleanStatus, (Object)Boolean.FALSE);
            return true;
        }
        try {
            IResource[] iResourceArray = modelProject.getFolder((IPath)new Path("model")).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource umlResources = iResourceArray[n2];
                if (umlResources.getName().endsWith(".uml") && umlResources.getLocalTimeStamp() > modelModification) {
                    modelModification = umlResources.getLocalTimeStamp();
                }
                ++n2;
            }
            if (project.getName().endsWith(".doc")) {
                iResourceArray = project.getFolder((IPath)new Path("dita/classes/generated")).members();
                n = iResourceArray.length;
                n2 = 0;
                while (n2 < n) {
                    IResource pdfResources = iResourceArray[n2];
                    if (pdfResources.getName().endsWith(".dita") && pdfResources.getLocalTimeStamp() > lastGenerated) {
                        lastGenerated = pdfResources.getLocalTimeStamp();
                    }
                    ++n2;
                }
            } else {
                iResourceArray = project.getFolder((IPath)new Path("model")).members();
                n = iResourceArray.length;
                n2 = 0;
                while (n2 < n) {
                    IResource ecoreUMLResources = iResourceArray[n2];
                    if (ecoreUMLResources.getName().endsWith("_Ecore.uml") && ecoreUMLResources.getLocalTimeStamp() > lastGenerated) {
                        lastGenerated = ecoreUMLResources.getLocalTimeStamp();
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            return true;
        }
        return modelModification > lastGenerated;
    }

    private static String getTemplatesDirectory() {
        try {
            CDAModelUtil.FindResourcesByNameVisitor visitor = new CDAModelUtil.FindResourcesByNameVisitor("cda.uml");
            IWorkspace iw = ResourcesPlugin.getWorkspace();
            iw.getRoot().accept((IResourceVisitor)visitor);
            if (!visitor.getResources().isEmpty() && visitor.getResources().size() == 1) {
                return "/" + ((IResource)visitor.getResources().get(0)).getProject().getName() + "/templates";
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return TEMPLATESDIR;
    }

    public static void createGenModel(IProject project, IProgressMonitor monitor) {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI umlEcoreModelURI = CDAUIUtil.getUMLEcoreModel(project);
        Package pe = (Package)EcoreUtil.getObjectByType((Collection)resourceSet.getResource(umlEcoreModelURI, true).getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        String basePackage = (String)pe.getValue(pe.getAppliedStereotype("Ecore::EPackage"), "basePackage");
        String nsPrefix = (String)pe.getValue(pe.getAppliedStereotype("Ecore::EPackage"), "nsPrefix");
        String nsURI = (String)pe.getValue(pe.getAppliedStereotype("Ecore::EPackage"), "nsURI");
        String prefix = (String)pe.getValue(pe.getAppliedStereotype("Ecore::EPackage"), "prefix");
        String modelName = pe.getName();
        Path filePath = new Path(String.format("model/%s.genmodel", modelName));
        IFile file = CDAUIUtil.getBundleRelativeFile(project, (IPath)filePath);
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String genmodelPath = String.valueOf(myWorkspaceRoot.getLocation().toOSString()) + file.getFullPath().toOSString();
        URI genmodelURI = URI.createFileURI((String)genmodelPath);
        Resource genmodelResource = resourceSet.createResource(genmodelURI);
        org.eclipse.uml2.codegen.ecore.genmodel.GenModel genmodel = GenModelFactory.eINSTANCE.createGenModel();
        genmodel.setModelName(String.format("%s_Ecore", modelName));
        genmodel.setModelDirectory(String.format("%s/src", project.getName()));
        genmodel.setModelPluginClass(String.valueOf(prefix) + "Plugin");
        genmodel.setModelPluginID(String.valueOf(basePackage) + "." + modelName);
        genmodel.setImporterID(ECOREIMPORTER);
        genmodel.setInvariantPrefix(VALIDATEPREFIX);
        genmodel.setCopyrightFields(false);
        genmodel.setComplianceLevel(GenJDKLevel.JDK70_LITERAL);
        genmodel.setRuntimeVersion(GenRuntimeVersion.EMF25);
        genmodel.setTemplateDirectory(CDABuilder.getTemplatesDirectory());
        genmodel.setDynamicTemplates(true);
        genmodel.getForeignModel().add((Object)String.format("%s.uml", genmodel.getModelName()));
        genmodel.setPluralizedGetters(true);
        GenAnnotation ga = org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory.eINSTANCE.createGenAnnotation();
        ga.setSource(ANNOTATIONSOURCE);
        ga.getDetails().put((Object)"ECORE_TAGGED_VALUES", (Object)"PROCESS");
        ga.getDetails().put((Object)"UNION_PROPERTIES", (Object)"PROCESS");
        ga.getDetails().put((Object)"DUPLICATE_FEATURES", (Object)"PROCESS");
        ga.getDetails().put((Object)"SUBSETTING_PROPERTIES", (Object)"PROCESS");
        ga.getDetails().put((Object)"COMMENTS", (Object)"PROCESS");
        ga.getDetails().put((Object)"DUPLICATE_FEATURE_INHERITANCE", (Object)"PROCESS");
        ga.getDetails().put((Object)"DUPLICATE_OPERATIONS", (Object)"PROCESS");
        ga.getDetails().put((Object)"INVARIANT_CONSTRAINTS", (Object)"PROCESS");
        ga.getDetails().put((Object)"REDEFINING_PROPERTIES", (Object)"PROCESS");
        ga.getDetails().put((Object)"ANNOTATION_DETAILS", (Object)"PROCESS");
        ga.getDetails().put((Object)"DUPLICATE_OPERATION_INHERITANCE", (Object)"PROCESS");
        ga.getDetails().put((Object)"REDEFINING_OPERATIONS", (Object)"PROCESS");
        ga.getDetails().put((Object)"DERIVED_FEATURES", (Object)"IGNORE");
        ga.getDetails().put((Object)"OPERATION_BODIES", (Object)"PROCESS");
        ga.getDetails().put((Object)"CAMEL_CASE_NAMES", (Object)"IGNORE");
        ga.getDetails().put((Object)"SUPER_CLASS_ORDER", (Object)"PROCESS");
        genmodel.getGenAnnotations().add((Object)ga);
        CollectGenPackages lgmv = new CollectGenPackages((ResourceSet)resourceSet);
        try {
            project.getWorkspace().getRoot().accept((IResourceVisitor)lgmv);
            for (GenPackage genPackage : lgmv.genPackages) {
                genmodel.getUsedGenPackages().add((Object)genPackage);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        org.eclipse.uml2.codegen.ecore.genmodel.GenPackage genPackage = GenModelFactory.eINSTANCE.createGenPackage();
        genPackage.setDisposableProviderFactory(true);
        genPackage.setBasePackage(basePackage);
        genPackage.setOperationsPackage(String.format("%s.%s.operations", basePackage, modelName));
        genPackage.setPrefix(prefix);
        EPackage value = EcoreFactory.eINSTANCE.createEPackage();
        value.setName(modelName);
        value.setNsPrefix(nsPrefix);
        value.setNsURI(nsURI);
        Path epackageFilePath = new Path(String.format("model/%s.ecore", modelName));
        IFile epackage = CDAUIUtil.getBundleRelativeFile(project, (IPath)epackageFilePath);
        String epackagePath = String.valueOf(myWorkspaceRoot.getLocation().toOSString()) + epackage.getFullPath().toOSString();
        URI epackageURI = URI.createFileURI((String)epackagePath);
        Resource ecoreResource = resourceSet.createResource(epackageURI);
        ecoreResource.getContents().add((Object)value);
        try {
            ecoreResource.save(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        genPackage.setEcorePackage(value);
        genmodel.getGenPackages().add((Object)genPackage);
        genmodelResource.getContents().add((Object)genmodel);
        try {
            ecoreResource.save(null);
            genmodelResource.save(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void runGenerate(boolean cleanBuild, IProject project, IProgressMonitor monitor) {
        if (project.getName().endsWith(".doc")) {
            if (cleanBuild) {
                try {
                    CDABuilder.runPublishDita(project, monitor);
                    project.refreshLocal(2, monitor);
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else {
            UMLImporter umlImporter = new UMLImporter();
            try {
                Monitor umlImportMonitor = BasicMonitor.toMonitor((IProgressMonitor)monitor);
                if (CDAUIUtil.getGeneratorModelFile(project) == null) {
                    CDABuilder.createGenModel(project, monitor);
                }
                umlImporter.setGenModelProjectLocation(project.getFullPath());
                umlImporter.defineOriginalGenModelPath(CDAUIUtil.getGeneratorModelFile(project));
                umlImporter.computeEPackages(umlImportMonitor);
                for (EPackage ePackage : umlImporter.getEPackages()) {
                    EcoreUtil.resolveAll((EObject)ePackage);
                }
                umlImporter.prepareGenModelAndEPackages(umlImportMonitor);
                umlImporter.saveGenModelAndEPackages(umlImportMonitor);
                GenModel genmodel = umlImporter.getGenModel();
                genmodel.setUpdateClasspath(false);
                genmodel.setCanGenerate(true);
                Generator generator = new Generator();
                generator.setInput((Object)umlImporter.getGenModel());
                genmodel.setCanGenerate(true);
                generator.generate((Object)genmodel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", umlImportMonitor);
                IProject testProject = project.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + ".tests");
                if (testProject.isOpen()) {
                    generator.generate((Object)genmodel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", umlImportMonitor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void runPublishDita(IProject project, IProgressMonitor monitor) throws IOException, CoreException, URISyntaxException {
        IFile ditaMapFile = CDAUIUtil.getProjectFile(project, CDAUIUtil.DITA_PATH, "book.ditamap");
        boolean disablePdf = Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.PDF_GEN_STORE_VALUE);
        if (ditaMapFile != null && !disablePdf) {
            DitaUtil.publish((IFile)ditaMapFile, (String)"pdf,eclipsehelp");
        }
    }

    public static void runTransformation(IProject project, IProgressMonitor monitor) {
        CDABuilder.runTransformation(project, monitor, EMPTYLIST);
    }

    /*
     * WARNING - void declaration
     */
    private static void runTransformation(IProject project, IProgressMonitor monitor, ArrayList<String> deleteDitaFolder) {
        IFolder ditaGeneratedFolder;
        try {
            int n;
            String antFileName = null;
            antFileName = project.getName().endsWith(".doc") ? "dita-transform.xml" : "transform.xml";
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            String launchMemento = String.format("%s.%s", project.getName(), antFileName);
            ArrayList<Object> classpathEntries = new ArrayList<Object>();
            IAntClasspathEntry[] additionalClassPathEntries = AntCorePlugin.getPlugin().getPreferences().getAdditionalClasspathEntries();
            if (additionalClassPathEntries != null) {
                IAntClasspathEntry[] iAntClasspathEntryArray = additionalClassPathEntries;
                n = additionalClassPathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IAntClasspathEntry antClasspathEntry = iAntClasspathEntryArray[n2];
                    classpathEntries.add(antClasspathEntry);
                    ++n2;
                }
            }
            String BIN = "bin";
            IProject[] iProjectArray = project.getWorkspace().getRoot().getProjects();
            int n3 = iProjectArray.length;
            n = 0;
            while (n < n3) {
                IFolder binFolder;
                IProject wsProject = iProjectArray[n];
                if (wsProject.isOpen() && !wsProject.getName().startsWith(".") && (binFolder = wsProject.getFolder("bin")).exists()) {
                    String binFolderString = binFolder.getLocation().toOSString();
                    boolean needToAdd = true;
                    for (IAntClasspathEntry iAntClasspathEntry : classpathEntries) {
                        if (!iAntClasspathEntry.getEntryURL().toString().endsWith(binFolderString)) continue;
                        needToAdd = false;
                        break;
                    }
                    if (needToAdd) {
                        classpathEntries.add(new AntClasspathEntry(String.valueOf(binFolderString) + "/"));
                    }
                }
                ++n;
            }
            AntCorePlugin.getPlugin().getPreferences().setAdditionalClasspathEntries(classpathEntries.toArray(new IAntClasspathEntry[classpathEntries.size()]));
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
            IFile transformxml = project.getFile(antFileName);
            String name = launchMemento;
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", transformxml.getLocation().toOSString());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS", false);
            workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            workingCopy.setAttribute("org.eclipse.debug.ui.build_before_launch", false);
            ILaunch launch = workingCopy.launch("run", monitor);
            boolean terminated = false;
            while (!terminated) {
                void var16_31;
                IProcess[] iProcessArray = launch.getProcesses();
                int n2 = iProcessArray.length;
                boolean n5 = false;
                while (var16_31 < n2) {
                    IProcess process = iProcessArray[var16_31];
                    terminated = process.isTerminated();
                    ++var16_31;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    terminated = true;
                }
            }
            workingCopy.delete();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (project.getName().endsWith(".doc") && (ditaGeneratedFolder = project.getFolder("dita/classes")).exists()) {
            try {
                IResource[] iResourceArray = ditaGeneratedFolder.members();
                int n = iResourceArray.length;
                int n6 = 0;
                while (n6 < n) {
                    IProject sourceProject;
                    IResource member = iResourceArray[n6];
                    if (member.exists() && member instanceof IFolder && !deleteDitaFolder.contains(member.getName()) && (sourceProject = project.getWorkspace().getRoot().getProject(member.getName())).exists() && sourceProject.isOpen()) {
                        ImportDitaReferences.importDitaProject(project.getWorkspace(), sourceProject, project);
                    }
                    ++n6;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    boolean isModelValid(IProject modelProject) {
        boolean status = true;
        IFile statusFile = modelProject.getFile((IPath)new Path("model/.modelStatus"));
        if (statusFile != null) {
            try {
                String line;
                statusFile.refreshLocal(0, null);
                BufferedReader reader = new BufferedReader(new InputStreamReader(statusFile.getContents()));
                StringBuilder out = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
                if (Integer.valueOf(out.toString()) > 1) {
                    status = false;
                }
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        boolean isDocumentProject = false;
        String modelProjectName = null;
        IResourceDelta docProjectDelta = null;
        CheckForDitaDelete cfdd = new CheckForDitaDelete();
        if (this.getProject().getName().endsWith(".doc")) {
            docProjectDelta = this.getDelta(this.getProject());
            if (docProjectDelta != null) {
                docProjectDelta.accept((IResourceDeltaVisitor)cfdd);
            }
            modelProjectName = this.getProject().getName().replace(".doc", ".model");
            isDocumentProject = true;
        } else {
            modelProjectName = String.valueOf(this.getProject().getName()) + ".model";
        }
        IProject modelProject = root.getProject(modelProjectName);
        IProject[] projects = new IProject[]{modelProject};
        IResourceDelta modelProjectDelta = this.getDelta(modelProject);
        CheckForModelChanged cfmc = new CheckForModelChanged();
        if (modelProjectDelta != null) {
            modelProjectDelta.accept((IResourceDeltaVisitor)cfmc);
        }
        if ((cfmc.hasModelChanged || CDABuilder.checkBuildStatus(modelProject, this.getProject())) && (6 == kind || !isDocumentProject || this.isModelValid(modelProject))) {
            CDABuilder.runTransformation(this.getProject(), monitor, cfdd.deletedDitaFolders);
            CDABuilder.runGenerate(6 == kind, this.getProject(), monitor);
        }
        return projects;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().setSessionProperty(cleanStatus, (Object)Boolean.TRUE);
    }

    class CheckForDitaDelete
    implements IResourceDeltaVisitor {
        public ArrayList<String> deletedDitaFolders = new ArrayList();

        CheckForDitaDelete() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (delta.getKind() == 2 && resource instanceof IFolder && resource.getName().endsWith(".doc")) {
                this.deletedDitaFolders.add(resource.getName());
            }
            return true;
        }
    }

    class CheckForModelChanged
    implements IResourceDeltaVisitor {
        public boolean hasModelChanged = false;

        CheckForModelChanged() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (delta.getKind() == 4 && resource.getName().endsWith(".uml")) {
                this.hasModelChanged = true;
            }
            return true;
        }
    }

    public static class CollectGenPackages
    implements IResourceVisitor {
        Set<GenPackage> genPackages = new LinkedHashSet<GenPackage>();
        private ResourceSet resourceSet = null;

        public CollectGenPackages(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        public boolean visit(IResource resource) throws CoreException {
            GenModel sourceGenModel;
            if (resource.getFileExtension() != null && "genmodel".equals(resource.getFileExtension()) && (sourceGenModel = (GenModel)EcoreUtil.getObjectByType((Collection)this.resourceSet.getResource(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true), true).getContents(), (EClassifier)GenModelPackage.eINSTANCE.getGenModel())) != null) {
                for (GenPackage usedGenPackage : sourceGenModel.getAllGenAndUsedGenPackagesWithClassifiers()) {
                    this.genPackages.add(usedGenPackage);
                }
            }
            return true;
        }
    }
}

