/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class EntryRelationshipSection
extends ResettableModelerPropertySection {
    private NamedElement namedElement;
    private CCombo typeCodeCombo;
    private boolean typeCodeModified = false;
    private TabbedPropertySheetPage myTabbedPropertySheetPage;

    private void modifyFields() {
        if (!this.typeCodeModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.namedElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Stereotype associationSterotype = CDAProfileUtil.getAppliedCDAStereotype((Element)EntryRelationshipSection.this.namedElement, (String)"AssociationValidation");
                    Stereotype entryRelationshipStereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)EntryRelationshipSection.this.namedElement, (String)"EntryRelationship");
                    if (entryRelationshipStereotype == null) {
                        entryRelationshipStereotype = CDAProfileUtil.applyCDAStereotype((Element)EntryRelationshipSection.this.namedElement, (String)"EntryRelationship");
                        if (associationSterotype != null) {
                            EntryRelationshipSection.this.namedElement.setValue(entryRelationshipStereotype, "severity", EntryRelationshipSection.this.namedElement.getValue(associationSterotype, "severity"));
                            EntryRelationshipSection.this.namedElement.setValue(entryRelationshipStereotype, "message", EntryRelationshipSection.this.namedElement.getValue(associationSterotype, "message"));
                            EntryRelationshipSection.this.namedElement.unapplyStereotype(associationSterotype);
                        }
                    }
                    Profile cdaProfile = CDAProfileUtil.getCDAProfile((ResourceSet)EntryRelationshipSection.this.namedElement.eResource().getResourceSet());
                    Enumeration entryKind = (Enumeration)cdaProfile.getOwnedType("EntryRelationshipKind");
                    if (EntryRelationshipSection.this.typeCodeModified) {
                        EntryRelationshipSection.this.typeCodeModified = false;
                        this.setLabel("Set Entry Relationship Type Code");
                        if (entryRelationshipStereotype != null && entryKind != null) {
                            if (EntryRelationshipSection.this.typeCodeCombo.getSelectionIndex() == 0) {
                                EntryRelationshipSection.this.namedElement.setValue(entryRelationshipStereotype, "typeCode", null);
                            } else {
                                EnumerationLiteral literal = (EnumerationLiteral)entryKind.getOwnedLiterals().get(EntryRelationshipSection.this.typeCodeCombo.getSelectionIndex() - 1);
                                EntryRelationshipSection.this.namedElement.setValue(entryRelationshipStereotype, "typeCode", (Object)literal);
                            }
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void resetFields() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.namedElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Restore Default Values"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Stereotype entryRelationshipStereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)EntryRelationshipSection.this.namedElement, (String)"EntryRelationship");
                    if (entryRelationshipStereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    EntryRelationshipSection.this.namedElement.unapplyStereotype(entryRelationshipStereotype);
                    ISelection currentSelection = EntryRelationshipSection.this.getSelection();
                    EntryRelationshipSection.this.myTabbedPropertySheetPage.selectionChanged(EntryRelationshipSection.this.getPart(), (ISelection)new StructuredSelection());
                    EntryRelationshipSection.this.myTabbedPropertySheetPage.selectionChanged(EntryRelationshipSection.this.getPart(), currentSelection);
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void fillTypeCodeCombo() {
        Enumeration entryKind = null;
        if (this.namedElement != null) {
            Profile cdaProfile = CDAProfileUtil.getCDAProfile((ResourceSet)this.namedElement.eResource().getResourceSet());
            entryKind = (Enumeration)cdaProfile.getOwnedType("EntryRelationshipKind");
        }
        if (entryKind == null) {
            this.typeCodeCombo.setItems(new String[0]);
        } else {
            ArrayList<String> items = new ArrayList<String>();
            items.add("");
            for (EnumerationLiteral literal : entryKind.getOwnedLiterals()) {
                items.add(literal.getLabel(true));
            }
            this.typeCodeCombo.setItems(items.toArray(new String[items.size()]));
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.myTabbedPropertySheetPage = aTabbedPropertySheetPage;
        Group composite = this.getWidgetFactory().createGroup(parent, "Entry Relationship");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        FormData data = null;
        this.typeCodeCombo = this.getWidgetFactory().createCCombo((Composite)composite, 0x800808);
        this.fillTypeCodeCombo();
        this.typeCodeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EntryRelationshipSection.this.typeCodeModified = true;
                EntryRelationshipSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                EntryRelationshipSection.this.typeCodeModified = true;
                EntryRelationshipSection.this.modifyFields();
            }
        });
        CLabel typeCodeLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Type Code:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 1);
        typeCodeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)typeCodeLabel, 0);
        data.top = new FormAttachment((Control)typeCodeLabel, 0, 0x1000000);
        this.typeCodeCombo.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)typeCodeLabel, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.namedElement != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.namedElement)) != null && editingDomain.isReadOnly(this.namedElement.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof NamedElement));
        this.namedElement = (NamedElement)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)this.namedElement, (String)"EntryRelationship");
        Enumeration entryRelKind = null;
        Profile cdaProfile = CDAProfileUtil.getCDAProfile((ResourceSet)this.namedElement.eResource().getResourceSet());
        if (cdaProfile != null) {
            entryRelKind = (Enumeration)cdaProfile.getOwnedType("EntryRelationshipKind");
        }
        this.fillTypeCodeCombo();
        this.typeCodeCombo.select(0);
        if (stereotype != null) {
            EnumerationLiteral literal;
            Object value = this.namedElement.getValue(stereotype, "typeCode");
            String typeCode = null;
            if (value instanceof EnumerationLiteral) {
                typeCode = ((EnumerationLiteral)value).getName();
            } else if (value instanceof Enumerator) {
                typeCode = ((Enumerator)value).getName();
            }
            if (typeCode != null && (literal = entryRelKind.getOwnedLiteral(typeCode)) != null) {
                int index = entryRelKind.getOwnedLiterals().indexOf((Object)literal);
                this.typeCodeCombo.select(index + 1);
            }
        }
        if (this.isReadOnly()) {
            this.typeCodeCombo.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.typeCodeCombo.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(stereotype != null);
        }
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!EntryRelationshipSection.this.isDisposed() && EntryRelationshipSection.this.namedElement.eResource() != null) {
                        EntryRelationshipSection.this.refresh();
                    }
                }
            });
        }
    }
}

