/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mdht.uml.cda.core.profile.CDATemplate;
import org.eclipse.mdht.uml.cda.core.profile.CodegenSupport;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.ui.builder.CDABuilder;
import org.eclipse.mdht.uml.cda.ui.builder.ToggleNatureAction;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.mdht.uml.cda.ui.util.CDAUIUtil;
import org.eclipse.mdht.uml.cda.ui.wizards.CDAWizard;
import org.eclipse.mdht.uml.cda.ui.wizards.NewCDAModelPage;
import org.eclipse.mdht.uml.common.UmlPlugin;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UML22UMLResource;
import org.osgi.framework.Bundle;

public class NewCDAModelProjectWizard
extends CDAWizard {
    protected NewCDAModelPage newCDATemplatePage;
    private final String TEMPLATEURI = String.format("%s/resources/model/%s", "org.eclipse.mdht.uml.cda.ui", "example.uml");
    private final String VOCABURI = String.format("%s/resources/model/%s", "org.eclipse.mdht.uml.cda.ui", "example-vocab.uml");

    private boolean checkForSpaces() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mdht.uml.cda.ui");
        URL url = bundle.getEntry("/");
        if (url.getPath().indexOf(" ") >= 0) {
            return true;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath rootPath = root.getLocation();
        return rootPath.toOSString().indexOf(" ") >= 0;
    }

    public void addPages() {
        this.loadCDAModels();
        if (this.cdaDocuments.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"MDHT CDA Project Wizard Exception", (String)"Unable to create CDA Project, No Available CDA Documents in Workspace!");
            return;
        }
        if (this.checkForSpaces()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"MDHT CDA Project Wizard Exception", (String)"Unable to create CDA Project, Unable to support Spaces ' ' within installation or workspace location");
            return;
        }
        this.newCDATemplatePage = new NewCDAModelPage("MDHT CDA Model", "Eclipse Modeling Project ", null, this.cdaDocuments);
        this.newCDATemplatePage.setDescription("Creates the CDA Model");
        this.newCDATemplatePage.setMessage("Use to create CDA Implementation Guide Model Project");
        this.addPage((IWizardPage)this.newCDATemplatePage);
    }

    public boolean performFinish() {
        try {
            ProgressMonitorDialog pd = new ProgressMonitorDialog(this.getShell());
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            final String modelName = this.newCDATemplatePage.getModelName().toLowerCase();
            this.modelProject = root.getProject(String.format("%s.%s.model", this.newCDATemplatePage.getBasePackage(), modelName));
            this.generatedProject = root.getProject(String.format("%s.%s", this.newCDATemplatePage.getBasePackage(), modelName));
            this.docProject = root.getProject(String.format("%s.%s.doc", this.newCDATemplatePage.getBasePackage(), modelName));
            pd.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Creating Projects", 9);
                    try {
                        NewCDAModelProjectWizard.this.modelProject.create(monitor);
                        NewCDAModelProjectWizard.this.modelProject.open(monitor);
                        NewCDAModelProjectWizard.this.generatedProject.create(monitor);
                        NewCDAModelProjectWizard.this.generatedProject.open(monitor);
                        NewCDAModelProjectWizard.this.docProject.create(monitor);
                        NewCDAModelProjectWizard.this.docProject.open(monitor);
                        IProjectProvider generatedProjectProvider = new IProjectProvider(){

                            public IProject getProject() {
                                return (this).NewCDAModelProjectWizard.this.generatedProject;
                            }

                            public String getProjectName() {
                                return (this).NewCDAModelProjectWizard.this.generatedProject.getName();
                            }

                            public IPath getLocationPath() {
                                return (this).NewCDAModelProjectWizard.this.generatedProject.getFullPath();
                            }
                        };
                        NewCDAModelProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation((IFieldData)NewCDAModelProjectWizard.this.fPluginData, generatedProjectProvider, NewCDAModelProjectWizard.this.contentWizard));
                        IProjectProvider docProjectProvider = new IProjectProvider(){

                            public IProject getProject() {
                                return (this).NewCDAModelProjectWizard.this.docProject;
                            }

                            public String getProjectName() {
                                return (this).NewCDAModelProjectWizard.this.docProject.getName();
                            }

                            public IPath getLocationPath() {
                                return (this).NewCDAModelProjectWizard.this.docProject.getFullPath();
                            }
                        };
                        NewCDAModelProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation((IFieldData)NewCDAModelProjectWizard.this.fPluginData, docProjectProvider, NewCDAModelProjectWizard.this.contentWizard));
                        monitor.worked(1);
                        monitor.setTaskName("Create Manifest for Generated Project");
                        NewCDAModelProjectWizard.this.createGeneratedProjectManifest(NewCDAModelProjectWizard.this.generatedProject, NewCDAModelProjectWizard.this.newCDATemplatePage.getBasePackage(), modelName);
                        monitor.worked(1);
                        monitor.setTaskName("Create Manifest for Doc Project");
                        NewCDAModelProjectWizard.this.createDocumentProjectManifest(NewCDAModelProjectWizard.this.docProject, NewCDAModelProjectWizard.this.newCDATemplatePage.getBasePackage(), modelName);
                        monitor.worked(1);
                        monitor.setTaskName("Create css");
                        NewCDAModelProjectWizard.this.createFolder(NewCDAModelProjectWizard.this.docProject, "css");
                        monitor.setTaskName("Create dita");
                        NewCDAModelProjectWizard.this.createFolder(NewCDAModelProjectWizard.this.docProject, "dita");
                        NewCDAModelProjectWizard.this.createDocProject(NewCDAModelProjectWizard.this.docProject, modelName);
                        NewCDAModelProjectWizard.this.createPluginProperties(NewCDAModelProjectWizard.this.docProject, modelName);
                        NewCDAModelProjectWizard.this.updateBuildProperties(NewCDAModelProjectWizard.this.docProject);
                        NewCDAModelProjectWizard.this.createDitaProperties(NewCDAModelProjectWizard.this.docProject, NewCDAModelProjectWizard.this.newCDATemplatePage.getBasePackage(), modelName);
                        monitor.setTaskName("Create UML Model");
                        NewCDAModelProjectWizard.this.createFolder(NewCDAModelProjectWizard.this.modelProject, "model");
                        NewCDAModelProjectWizard.this.createUMLModel(NewCDAModelProjectWizard.this.modelProject, NewCDAModelProjectWizard.this.newCDATemplatePage.getNamespaceURI(), NewCDAModelProjectWizard.this.newCDATemplatePage.getBasePackage(), modelName);
                        monitor.worked(1);
                        monitor.setTaskName("Create Model Plugin");
                        NewCDAModelProjectWizard.this.createModelPlugin(NewCDAModelProjectWizard.this.modelProject, modelName);
                        monitor.setTaskName("Create Manifest for Model Project");
                        NewCDAModelProjectWizard.this.createModelProjectManifest(NewCDAModelProjectWizard.this.modelProject, NewCDAModelProjectWizard.this.newCDATemplatePage.getBasePackage(), modelName);
                        monitor.worked(1);
                        monitor.setTaskName("Create Transformation XML");
                        NewCDAModelProjectWizard.this.createTransformation(NewCDAModelProjectWizard.this.generatedProject, modelName);
                        monitor.worked(1);
                        monitor.setTaskName("Add Properties");
                        NewCDAModelProjectWizard.this.createPluginProperties(NewCDAModelProjectWizard.this.generatedProject, modelName);
                        NewCDAModelProjectWizard.this.updateBuildProperties(NewCDAModelProjectWizard.this.generatedProject);
                        monitor.setTaskName("Run MDHT Transformation");
                        CDABuilder.runTransformation(NewCDAModelProjectWizard.this.generatedProject, monitor);
                        monitor.worked(1);
                        monitor.setTaskName("Create GenModel");
                        CDABuilder.createGenModel(NewCDAModelProjectWizard.this.generatedProject, monitor);
                        monitor.worked(1);
                        monitor.setTaskName("Run MDHT Transformation");
                        CDABuilder.runTransformation(NewCDAModelProjectWizard.this.generatedProject, monitor);
                        monitor.worked(1);
                        monitor.setTaskName("Generate");
                        CDABuilder.runGenerate(false, NewCDAModelProjectWizard.this.generatedProject, monitor);
                        monitor.worked(1);
                        NewCDAModelProjectWizard.this.generatedProject.build(10, monitor);
                        monitor.setTaskName("Toggle Build Nature");
                        ToggleNatureAction.toggleNature(NewCDAModelProjectWizard.this.generatedProject);
                        ToggleNatureAction.toggleNature(NewCDAModelProjectWizard.this.docProject);
                        monitor.worked(1);
                        NewCDAModelProjectWizard.this.setupWorkspace(NewCDAModelProjectWizard.this.modelProject, modelName);
                    }
                    catch (Exception exception) {
                        monitor.setCanceled(true);
                        Logger.logException(exception);
                        throw new InvocationTargetException(exception);
                    }
                }
            });
            this.docProject.refreshLocal(2, null);
            this.modelProject.refreshLocal(2, null);
            this.generatedProject.refreshLocal(2, null);
        }
        catch (InvocationTargetException exception) {
            Logger.logException(exception);
            Status status = new Status(4, "org.eclipse.mdht.uml.cda.ui", 0, exception.getCause().getLocalizedMessage(), exception.getCause());
            ErrorDialog.openError((Shell)this.getShell(), (String)"MDHT CDA Project Wizard Exception", (String)"Unable to create new CDA Project", (IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            Logger.logException(interruptedException);
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
        }
        return true;
    }

    protected void setupWorkspace(IProject modelProject, String modelName) throws Exception {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
        activePage.closeEditors(activePage.getEditorReferences(), true);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(modelProject.getFolder("model").getFile(String.valueOf(modelName) + ".uml").getLocation());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    private void copyDocResources(Bundle bundle, String sourcepath, IProject project) throws Exception {
        Enumeration entries = bundle.findEntries(sourcepath, "*", true);
        while (entries.hasMoreElements()) {
            URL next = (URL)entries.nextElement();
            if (next.getPath().contains("model")) continue;
            Path spath = new Path(next.getPath());
            Path tpath = new Path(next.getPath().replace("/resources", ""));
            String[] segments = tpath.segments();
            IFolder f = null;
            int ctr = 0;
            while (ctr < segments.length - 1) {
                f = f == null ? project.getFolder(tpath.segments()[ctr]) : f.getFolder(tpath.segments()[ctr]);
                try {
                    if (!f.exists()) {
                        f.create(true, true, null);
                    }
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
                ++ctr;
            }
            try {
                InputStream stream = FileLocator.openStream((Bundle)bundle, (IPath)spath, (boolean)false);
                IFile file = project.getFile((IPath)tpath);
                file.create(stream, true, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void createDocProject(IProject project, String modelName) throws Exception {
        IFolder binFolder;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mdht.uml.cda.ui");
        IProjectDescription description = project.getDescription();
        String[] newNatures = new String[]{};
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        IFolder srcFolder = project.getFolder("src");
        if (srcFolder.exists()) {
            srcFolder.delete(true, null);
        }
        if ((binFolder = project.getFolder("bin")).exists()) {
            binFolder.delete(true, null);
        }
    }

    private Package cloneModel(IProject project, ResourceSet resourceSet, Map<String, String> options, String sourcePathName, String clonePath, String packageName) throws IOException {
        URI cloneModelURI = URI.createPlatformPluginURI((String)sourcePathName, (boolean)false);
        Package sourcePackage = (Package)EcoreUtil.getObjectByType((Collection)resourceSet.getResource(cloneModelURI, true).getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackageableElement());
        Package clonedPackage = (Package)EcoreUtil.copy((EObject)sourcePackage);
        clonedPackage.setName(packageName);
        Path cloneFilePath = new Path(clonePath);
        IFile file = CDAUIUtil.getBundleRelativeFile(project, (IPath)cloneFilePath);
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String cdaUMLPath = String.valueOf(myWorkspaceRoot.getLocation().toOSString()) + file.getFullPath().toOSString();
        URI targetModelURI = URI.createFileURI((String)cdaUMLPath);
        Resource umlResource = UML22UMLResource.Factory.INSTANCE.createResource(targetModelURI);
        umlResource.getContents().add((Object)clonedPackage);
        umlResource.save(options);
        return clonedPackage;
    }

    void createUMLModel(IProject project, String namespaceURI, String basePackage, String modelName) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        UmlPlugin.computeModelPathMapExtensions();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        HashMap<String, String> options = new HashMap<String, String>();
        Package templatePackage = this.cloneModel(project, (ResourceSet)resourceSet, options, this.TEMPLATEURI, String.format("model/%s.uml", modelName.toLowerCase()), modelName.toLowerCase());
        Package vocabPackage = this.cloneModel(project, (ResourceSet)resourceSet, options, this.VOCABURI, String.format("model/%s-vocab.uml", modelName.toLowerCase()), String.format("%s-vocab", modelName.toLowerCase()));
        CodegenSupport codegenSupport = (CodegenSupport)templatePackage.applyStereotype(templatePackage.getApplicableStereotype("CDA::CodegenSupport"));
        codegenSupport.setBase_Namespace((Namespace)templatePackage);
        codegenSupport.setBasePackage(basePackage);
        codegenSupport.setNsURI(namespaceURI);
        codegenSupport.setNsPrefix(this.newCDATemplatePage.getNsPrefix());
        codegenSupport.setPackageName(modelName.toLowerCase());
        codegenSupport.setPrefix(this.newCDATemplatePage.getPrefix());
        Class cdaClass = templatePackage.createOwnedClass(this.newCDATemplatePage.getCDADocumentName(), false);
        CDATemplate template = (CDATemplate)cdaClass.applyStereotype(cdaClass.getApplicableStereotype("CDA::CDATemplate"));
        template.setBase_Class(cdaClass);
        template.setTemplateId(this.newCDATemplatePage.getTemplateId());
        template.setAssigningAuthorityName(this.newCDATemplatePage.getTemplateAssigningAuthority());
        Type t = (Type)this.cdaDocuments.get(this.newCDATemplatePage.getCDADocument());
        if (t instanceof Class) {
            Class documentClass = (Class)t;
            cdaClass.createGeneralization((Classifier)documentClass);
            Package documentPackage = documentClass.getNearestPackage();
            EcoreUtil.resolveAll((EObject)documentPackage);
            templatePackage.createPackageImport(documentClass.getNearestPackage());
        }
        templatePackage.createPackageImport(vocabPackage);
        templatePackage.eResource().save(options);
    }

    void createTransformation(IProject project, String modelName) throws Exception {
        CDAModelUtil.FindResourcesByNameVisitor visitor = new CDAModelUtil.FindResourcesByNameVisitor("transform-common.xml");
        IWorkspace iw = ResourcesPlugin.getWorkspace();
        iw.getRoot().accept((IResourceVisitor)visitor);
        String transformCommonProject = "org.eclipse.mdht.uml.cda";
        if (!visitor.getResources().isEmpty() && visitor.getResources().size() == 1) {
            transformCommonProject = ((IResource)visitor.getResources().get(0)).getProject().getName();
        }
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("<?eclipse version=\"3.0\"?>");
        writer.println("<project name=\"CDA Model Transformation\"  basedir=\".\" default=\"all\">");
        writer.println("<eclipse.convertPath resourcePath=\"" + transformCommonProject + "\" property=\"cdaPluginPath\"/>");
        writer.println("<property name=\"modelName\" value=\"" + modelName.toLowerCase() + "\"/>");
        writer.println("<macrodef name=\"convertEcorePaths\">");
        writer.println("<attribute name=\"filePath\"/>");
        writer.println("<sequential>");
        writer.println("<replace file=\"@{filePath}\" token=\"pathmap://" + modelName.toUpperCase() + "_MODEL///" + modelName + ".uml\" value=\"" + modelName + "_Ecore.uml\"/>");
        for (String cdaPackage : this.cdaPackages.keySet()) {
            Package aPackage = (Package)this.cdaPackages.get(cdaPackage);
            if ("cda".equals(cdaPackage)) continue;
            CDAModelUtil.FindResourcesByNameVisitor ecoreModel = new CDAModelUtil.FindResourcesByNameVisitor(String.valueOf(cdaPackage) + "_Ecore.uml");
            iw.getRoot().accept((IResourceVisitor)ecoreModel);
            if (aPackage.eResource() != null && aPackage.eResource().getURI() != null && ecoreModel.getResources().size() == 1) {
                writer.println("<replace file=\"@{filePath}\" token=\"" + aPackage.eResource().getURI() + "\" value=\"" + "../.." + ((IResource)ecoreModel.getResources().get(0)).getFullPath().toFile() + "\"/> ");
            }
            if (((Package)this.cdaPackages.get(cdaPackage)).eResource() == null) continue;
            for (Resource controlledResource : UMLUtil.getControlledResources((Resource)((Package)this.cdaPackages.get(cdaPackage)).eResource())) {
                if (controlledResource == null || controlledResource.getURI() == null || ecoreModel.getResources().size() != 1) continue;
                writer.println("<replace file=\"@{filePath}\" token=\"" + controlledResource.getURI() + "\" value=\"" + "../.." + ((IResource)ecoreModel.getResources().get(0)).getFullPath().toFile() + "\"/> ");
            }
        }
        writer.println("</sequential>");
        writer.println("</macrodef>");
        writer.println("<import file=\"${cdaPluginPath}/transform-common.xml\"/>");
        writer.println("</project>");
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        this.createFile(project, "transform.xml", is);
    }

    void createModelPlugin(IProject project, String modelName) throws Exception {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<?eclipse version=\"3.0\"?>");
        writer.println("<plugin>");
        writer.println("<extension point=\"org.eclipse.emf.ecore.uri_mapping\">");
        writer.println("<mapping source=\"pathmap://" + modelName.toUpperCase() + "_MODEL/\" target=\"model/\">");
        writer.println("</mapping>");
        writer.println("</extension>");
        writer.println("</plugin>");
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        this.createFile(project, "plugin.xml", is);
    }

    void createDitaProperties(IProject project, String basePackage, String modelName) throws Exception {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("basePackage = " + basePackage);
        writer.println("projectName = " + modelName);
        writer.println("modelName = " + modelName);
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        this.createFile(project, "dita.properties", is);
    }

    void createPluginProperties(IProject project, String modelName) throws Exception {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("pluginName = " + modelName + " Model");
        writer.println("providerName = Provider Name Here");
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        this.createFile(project, "plugin.properties", is);
    }

    void updateBuildProperties(IProject project) throws Exception {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("source.. = src/");
        writer.println("output.. = bin/");
        if (project.equals((Object)this.docProject)) {
            writer.println("bin.includes = META-INF/,\\");
        } else {
            writer.println("bin.includes = plugin.xml,\\");
            writer.println("               META-INF/,\\");
        }
        writer.println("               .,\\");
        writer.println("               plugin.properties");
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        Path path = new Path("build.properties");
        IFile file = CDAUIUtil.getBundleRelativeFile(project, (IPath)path);
        file.setContents((InputStream)is, true, false, null);
    }

    void createGeneratedProjectManifest(IProject project, String basePackage, String modelName) throws Exception {
        IFile manfiestFile = (IFile)this.cdaDocumentsManifest.get(this.newCDATemplatePage.getCDADocument());
        FileInputStream input = new FileInputStream(manfiestFile.getRawLocation().toOSString());
        Manifest projectManifest = new Manifest(input);
        Attributes attributes = projectManifest.getMainAttributes();
        IFile manifest = CDAUIUtil.getManifest(project);
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("Bundle-Name: %pluginName");
        writer.println(String.format("Bundle-SymbolicName: %s;singleton:=true", project.getName()));
        writer.println("Bundle-ActivationPolicy: lazy");
        writer.println(String.format("Bundle-Activator: %s.%s.%sPlugin$Implementation", basePackage, modelName, String.valueOf(modelName.substring(0, 1).toUpperCase()) + modelName.substring(1)));
        writer.println("Bundle-ClassPath: .");
        writer.println("Bundle-Vendor: %providerName");
        writer.println("Bundle-Localization: plugin");
        String requiredBundles = attributes.getValue("Require-Bundle");
        String sourceBundle = attributes.getValue("Bundle-SymbolicName");
        String[] rb = requiredBundles.split(",");
        String[] sb = sourceBundle.split(";");
        int index = 0;
        while (index < rb.length) {
            if (index == 0) {
                writer.print("Require-Bundle: " + rb[index]);
            } else if (index > 0) {
                writer.println(",");
                writer.print(" " + rb[index]);
            }
            ++index;
        }
        if (sb.length > 0) {
            writer.println(",");
            writer.println(" " + sb[0] + ";visibility:=reexport");
        }
        writer.println(String.format("Export-Package: %s.%s,", basePackage, modelName));
        writer.println(String.format(" %s.%s.impl,", basePackage, modelName));
        writer.println(String.format(" %s.%s.operations,", basePackage, modelName));
        writer.println(String.format(" %s.%s.util", basePackage, modelName));
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        manifest.appendContents((InputStream)is, true, false, null);
    }

    void createDocumentProjectManifest(IProject project, String basePackage, String modelName) throws Exception {
        IFile manifest = CDAUIUtil.getManifest(project);
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("Bundle-Name: Document Bundle " + modelName);
        writer.println(String.format("Bundle-SymbolicName: %s;singleton:=true", project.getName()));
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        manifest.appendContents((InputStream)is, true, false, null);
    }

    void createModelProjectManifest(IProject project, String basePackage, String modelName) throws Exception {
        IFile manifest = CDAUIUtil.getManifest(project);
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("Bundle-Name: Model Bundle " + modelName);
        writer.println(String.format("Bundle-SymbolicName: %s;singleton:=true", project.getName()));
        writer.flush();
        swriter.close();
        ByteArrayInputStream is = new ByteArrayInputStream(swriter.toString().getBytes("UTF-8"));
        this.createFolder(project, "META-INF");
        this.createFile(project, manifest.getProjectRelativePath().toString(), is);
    }
}

