/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mdht.uml.common.ui.dialogs.ElementSelectionDialog;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConstrainedElementsSection
extends WrapperAwareModelerPropertySection {
    private Constraint constraint;
    private ListViewer constrainedElementsList;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private final UMLMetamodelCache uml = new UMLMetamodelCache();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        CLabel listLabel = this.getWidgetFactory().createCLabel(composite, "Constrained Elements:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        listLabel.setLayoutData((Object)data);
        this.constrainedElementsList = new ListViewer(this.getWidgetFactory().createList(composite, 2818));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.width = 300;
        data.right = new FormAttachment(100, -100);
        data.top = new FormAttachment((Control)listLabel, 0, 1024);
        data.bottom = new FormAttachment(100, 0);
        this.constrainedElementsList.getControl().setLayoutData((Object)data);
        this.constrainedElementsList.setContentProvider((IContentProvider)new ConstrainedElementsContentProvider());
        this.constrainedElementsList.setLabelProvider((IBaseLabelProvider)new ConstrainedElementsLabelProvider());
        this.addButton = this.getWidgetFactory().createButton(composite, "Add...", 8);
        data = new FormData();
        data.left = new FormAttachment(this.constrainedElementsList.getControl(), 0, 131072);
        data.top = new FormAttachment(this.constrainedElementsList.getControl(), 0, 128);
        data.right = new FormAttachment(100, 0);
        this.addButton.setLayoutData((Object)data);
        this.removeButton = this.getWidgetFactory().createButton(composite, "Remove", 8);
        data = new FormData();
        data.left = new FormAttachment(this.constrainedElementsList.getControl(), 0, 131072);
        data.top = new FormAttachment((Control)this.addButton, 0, 1024);
        data.right = new FormAttachment(100, 0);
        this.removeButton.setLayoutData((Object)data);
        this.upButton = this.getWidgetFactory().createButton(composite, "Up", 8);
        data = new FormData();
        data.left = new FormAttachment(this.constrainedElementsList.getControl(), 0, 131072);
        data.top = new FormAttachment((Control)this.removeButton, 0, 1024);
        data.right = new FormAttachment(100, 0);
        this.upButton.setLayoutData((Object)data);
        this.downButton = this.getWidgetFactory().createButton(composite, "Down", 8);
        data = new FormData();
        data.left = new FormAttachment(this.constrainedElementsList.getControl(), 0, 131072);
        data.top = new FormAttachment((Control)this.upButton, 0, 1024);
        data.right = new FormAttachment(100, 0);
        this.downButton.setLayoutData((Object)data);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ConstrainedElementsSection.this.addButton) {
                    ConstrainedElementsSection.this.addConstrainedElements();
                } else if (e.getSource() == ConstrainedElementsSection.this.removeButton) {
                    ConstrainedElementsSection.this.removeConstrainedElements();
                } else if (e.getSource() == ConstrainedElementsSection.this.upButton) {
                    ConstrainedElementsSection.this.moveConstrainedElement(-1);
                } else if (e.getSource() == ConstrainedElementsSection.this.downButton) {
                    ConstrainedElementsSection.this.moveConstrainedElement(1);
                }
            }
        };
        this.addButton.addSelectionListener((SelectionListener)buttonListener);
        this.removeButton.addSelectionListener((SelectionListener)buttonListener);
        this.upButton.addSelectionListener((SelectionListener)buttonListener);
        this.downButton.addSelectionListener((SelectionListener)buttonListener);
        this.constrainedElementsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConstrainedElementsSection.this.updateButtons();
            }
        });
    }

    @Override
    protected boolean isReadOnly() {
        boolean result = super.isReadOnly();
        if (!result && this.constraint != null) {
            if (ConstrainedElementsSection.isProfileClassifier(this.constraint.getContext())) {
                result = true;
            } else {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.constraint);
                if (editingDomain != null && editingDomain.isReadOnly(this.constraint.eResource())) {
                    result = true;
                }
            }
        }
        return result;
    }

    static boolean isProfileClassifier(Namespace context) {
        return context instanceof Classifier && context.getNearestPackage() instanceof Profile;
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Constraint));
        this.constraint = (Constraint)element;
        this.uml.update((Element)this.constraint);
    }

    public void dispose() {
        this.uml.dispose();
        super.dispose();
    }

    public void refresh() {
        if (this.constrainedElementsList != null) {
            this.constrainedElementsList.setInput((Object)this.constraint);
            this.constrainedElementsList.refresh();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean disableAll = this.isReadOnly();
        int selection = this.constrainedElementsList.getList().getSelectionIndex();
        boolean multi = this.constrainedElementsList.getList().getSelectionCount() > 1;
        int lastItem = this.constrainedElementsList.getList().getItemCount() - 1;
        this.addButton.setEnabled(!disableAll);
        this.removeButton.setEnabled(!disableAll && selection >= 0);
        this.upButton.setEnabled(!disableAll && !multi && selection > 0);
        this.downButton.setEnabled(!disableAll && !multi && selection >= 0 && selection < lastItem);
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ConstrainedElementsSection.this.isDisposed() && ConstrainedElementsSection.this.constraint.eResource() != null) {
                        ConstrainedElementsSection.this.refresh();
                    }
                }
            });
        }
    }

    private void addConstrainedElements() {
        final List<? extends Element> elementsToAdd = this.constraint.getNearestPackage() instanceof Profile ? this.selectElements(this.uml.getUMLMetaclasses(), "Add Constrained Element", "Select an UML metaclass to constrain.") : this.selectElements(this.find(this.constraint.getContext(), UMLPackage.Literals.CLASSIFIER, UMLPackage.Literals.CONSTRAINT, UMLPackage.Literals.FEATURE), "Add Constrained Elements", "Select an element to constrain.");
        elementsToAdd.removeAll((Collection<?>)this.constraint.getConstrainedElements());
        if (!elementsToAdd.isEmpty()) {
            this.execute((IUndoableOperation)new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)this.constraint), "Add Constrained Element"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable uiContext) throws ExecutionException {
                    ConstrainedElementsSection.this.constraint.getConstrainedElements().addAll((Collection)elementsToAdd);
                    if (ConstrainedElementsSection.this.constraint.getNearestPackage() instanceof Profile) {
                        ConstrainedElementsSection.this.ensureMetaclassReferences(ConstrainedElementsSection.this.constraint, elementsToAdd);
                    }
                    return Status.OK_STATUS;
                }
            });
            this.constrainedElementsList.refresh();
            this.getPart().getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ConstrainedElementsSection.this.constrainedElementsList.getControl().isDisposed()) {
                        ConstrainedElementsSection.this.constrainedElementsList.setSelection((ISelection)new StructuredSelection(elementsToAdd), true);
                    }
                }
            });
        }
    }

    private Shell getShell() {
        return this.getPart().getSite().getShell();
    }

    private List<? extends Element> selectElements(List<?> scope, String title, String message) {
        scope = new ArrayList(scope);
        scope.removeAll((Collection<?>)this.constraint.getConstrainedElements());
        scope.remove(this.constraint);
        ArrayList<Element> result = new ArrayList<Element>();
        ElementSelectionDialog dialog = new ElementSelectionDialog(this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), scope);
        dialog.setTitle(title);
        dialog.setMessage(message);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                result.add((Element)next);
                ++n2;
            }
        }
        return result;
    }

    private Resource getUMLMetamodel() {
        return this.constraint.eResource().getResourceSet().getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
    }

    private void ensureMetaclassReferences(Constraint constraint, Collection<?> constrainedElements) {
        Profile profile = (Profile)constraint.getNearestPackage();
        URI uml = URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml");
        for (Object next : profile.getReferencedMetamodels()) {
            if (!EcoreUtil.getURI((EObject)next).trimFragment().equals(uml)) continue;
            return;
        }
        for (Object next : constrainedElements) {
            if (!(next instanceof Class)) continue;
            Class metaclass = (Class)next;
            profile.getMetaclassReference((PackageableElement)metaclass, true);
        }
    }

    private List<? extends NamedElement> find(Object scope, EClass ... type) {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(scope));
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof NamedElement)) continue;
            int i = 0;
            while (i < type.length) {
                if (type[i].isInstance(next)) {
                    result.add((NamedElement)next);
                }
                ++i;
            }
        }
        return result;
    }

    private void removeConstrainedElements() {
        this.execute((IUndoableOperation)new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)this.constraint), "Remove Constrained Elements"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable uiContext) throws ExecutionException {
                ConstrainedElementsSection.this.constraint.getConstrainedElements().removeAll(ConstrainedElementsSection.this.getSelectedConstrainedElements());
                return Status.OK_STATUS;
            }
        });
        this.constrainedElementsList.refresh();
    }

    private void moveConstrainedElement(int delta) {
        final int index = this.constrainedElementsList.getList().getSelectionIndex();
        final int newIndex = Math.min(Math.max(0, index + delta), this.constrainedElementsList.getList().getItemCount() - 1);
        this.execute((IUndoableOperation)new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)this.constraint), "Reorder Constrained Elements"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable uiContext) throws ExecutionException {
                ConstrainedElementsSection.this.constraint.getConstrainedElements().move(newIndex, index);
                return Status.OK_STATUS;
            }
        });
        this.constrainedElementsList.refresh();
        this.constrainedElementsList.setSelection((ISelection)new StructuredSelection(this.constraint.getConstrainedElements().get(newIndex)));
    }

    private Collection<?> getSelectedConstrainedElements() {
        return ((IStructuredSelection)this.constrainedElementsList.getSelection()).toList();
    }

    private static class ConstrainedElementsContentProvider
    implements IStructuredContentProvider {
        private ConstrainedElementsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Constraint constraint;
            Constraint constraint2 = constraint = inputElement instanceof Constraint ? (Constraint)inputElement : null;
            List<Object> result = constraint == null ? Collections.EMPTY_LIST : (ConstrainedElementsSection.isProfileClassifier(constraint.getContext()) ? Collections.singletonList(constraint.getContext()) : constraint.getConstrainedElements());
            return result.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class ConstrainedElementsLabelProvider
    extends LabelProvider {
        private ConstrainedElementsLabelProvider() {
        }

        public String getText(Object element) {
            String result = element instanceof NamedElement ? org.eclipse.mdht.uml.common.util.UMLUtil.getPackageQualifiedName((NamedElement)((NamedElement)element)) : UMLUtil.getQualifiedText((EObject)((EObject)element));
            return result;
        }
    }

    private class UMLMetamodelCache {
        private ResourceSet context;
        private List<Class> umlMetaclasses;

        private UMLMetamodelCache() {
        }

        void update(Element element) {
            ResourceSet newContext = element.eResource().getResourceSet();
            if (newContext != this.context) {
                this.umlMetaclasses = null;
                this.context = newContext;
            }
        }

        void dispose() {
            this.umlMetaclasses = null;
            this.context = null;
        }

        List<Class> getUMLMetaclasses() {
            Model uml;
            if (this.umlMetaclasses == null && (uml = (Model)EcoreUtil.getObjectByType((Collection)ConstrainedElementsSection.this.getUMLMetamodel().getContents(), (EClassifier)UMLPackage.Literals.MODEL)) != null) {
                this.umlMetaclasses = new ArrayList<Class>();
                for (Object next : uml.getPackagedElements()) {
                    if (!(next instanceof Class) || !((Class)next).isMetaclass()) continue;
                    this.umlMetaclasses.add((Class)next);
                }
            }
            return this.umlMetaclasses;
        }
    }
}

