/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.profile.SeverityKind;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.GreenDatatypesUtil;
import org.eclipse.mdht.uml.common.util.ModelFilter;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class CDAModelFilter
extends ModelFilter {
    private Package valueSetPackage;
    private GreenDatatypesUtil greenDatatypesUtil = new GreenDatatypesUtil();

    public CDAModelFilter(Package sourcePackage, Package filteredPackage) {
        super(sourcePackage, filteredPackage);
        this.greenDatatypesUtil.loadGreenDatatypesFromBase(sourcePackage.eResource().getResourceSet(), sourcePackage.eResource().getURI().trimSegments(1));
    }

    public Package getValueSetPackage() {
        return this.valueSetPackage;
    }

    protected boolean isDefaultHidden(NamedElement element) {
        Association association;
        Validation validation;
        boolean hidden = false;
        if (element instanceof Property) {
            Validation validation2;
            CodeSystemConstraint codeSystemConstraint;
            Property property = (Property)element;
            if (property.getType() instanceof Enumeration) {
                hidden = true;
            }
            if ("text".equals(element.getName()) || "title".equals(element.getName())) {
                hidden = true;
            }
            if ((codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property)) != null && codeSystemConstraint.getCode() != null) {
                hidden = true;
            }
            if ((validation2 = CDAProfileUtil.getValidation((Element)property)) == null && property.getLower() == 0) {
                hidden = true;
            }
            if (validation2 != null && SeverityKind.INFO == validation2.getSeverity()) {
                hidden = true;
            } else if (property.getAssociation() != null && (validation2 = CDAProfileUtil.getValidation((Element)property.getAssociation())) != null && SeverityKind.INFO == validation2.getSeverity()) {
                hidden = true;
            }
        }
        if (element instanceof Association && (validation = CDAProfileUtil.getValidation((Element)(association = (Association)element))) != null && SeverityKind.INFO == validation.getSeverity()) {
            hidden = true;
        }
        return hidden;
    }

    protected boolean isDefaultCollapsed(NamedElement element) {
        boolean collapsed = false;
        return collapsed;
    }

    public Class filterClass(Class sourceClass) {
        Class filteredClass = super.filterClass(sourceClass);
        return filteredClass;
    }

    protected void assignFilteredNamespaceURI(Package sourcePackage, Package filteredPackage) {
    }

    protected Classifier getFilteredPropertyType(Property property) {
        ValueSetVersion valueSet;
        ValueSetConstraint constraint;
        Classifier newType = super.getFilteredPropertyType(property);
        if (newType == null && (constraint = TermProfileUtil.getValueSetConstraint((Property)property)) != null && (valueSet = constraint.getReference()) != null && valueSet.getBase_Enumeration() != null && valueSet.getBase_Enumeration().getOwnedLiterals().size() > 0) {
            Enumeration filteredEnum = this.addValueSetEnum(valueSet);
            newType = filteredEnum;
        }
        if (newType == null) {
            newType = this.greenDatatypesUtil.getGreenTypeFor((Classifier)property.getType());
        }
        return newType;
    }

    private Enumeration addValueSetEnum(ValueSetVersion valueSet) {
        if (this.valueSetPackage == null) {
            this.valueSetPackage = this.getFilteredPackage();
        }
        Enumeration valueSetEnum = null;
        if (valueSet.getBase_Enumeration() != null) {
            String normalizedName = this.normalizeCodeName(valueSet.getBase_Enumeration().getName());
            String enumName = UML2Util.getValidJavaIdentifier((String)normalizedName);
            valueSetEnum = (Enumeration)this.valueSetPackage.getOwnedType(enumName = String.valueOf(enumName.substring(0, 1).toUpperCase()) + enumName.substring(1), false, UMLPackage.eINSTANCE.getEnumeration(), false);
            if (valueSetEnum == null) {
                valueSetEnum = (Enumeration)EcoreUtil.copy((EObject)valueSet.getBase_Enumeration());
                valueSetEnum.setName(enumName);
                this.valueSetPackage.getOwnedTypes().add((Object)valueSetEnum);
                UMLUtil.cloneStereotypes((Enumeration)valueSet.getBase_Enumeration(), (Enumeration)valueSetEnum);
            }
        }
        return valueSetEnum;
    }

    protected List<Property> getCollapsedContent(Property property) {
        List collapsedContent = super.getCollapsedContent(property);
        return collapsedContent;
    }
}

