/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.TermPackage;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;

public class CodeSystemVersionSection
extends ResettableModelerPropertySection {
    private Enumeration umlEnumeration;
    private Text idText;
    private boolean idModified = false;
    private Text nameText;
    private boolean nameModified = false;
    private Text fullNameText;
    private boolean fullNameModified = false;
    private Text versionText;
    private boolean versionModified = false;
    private Text sourceText;
    private boolean sourceModified = false;
    private Text urlText;
    private boolean urlModified = false;
    private Text effectiveDateText;
    private boolean effectiveDateModified = false;
    private Text releaseDateText;
    private boolean releaseDateModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (CodeSystemVersionSection.this.idText == event.getSource()) {
                CodeSystemVersionSection.this.idModified = true;
            }
            if (CodeSystemVersionSection.this.nameText == event.getSource()) {
                CodeSystemVersionSection.this.nameModified = true;
            }
            if (CodeSystemVersionSection.this.versionText == event.getSource()) {
                CodeSystemVersionSection.this.versionModified = true;
            }
            if (CodeSystemVersionSection.this.fullNameText == event.getSource()) {
                CodeSystemVersionSection.this.fullNameModified = true;
            }
            if (CodeSystemVersionSection.this.sourceText == event.getSource()) {
                CodeSystemVersionSection.this.sourceModified = true;
            }
            if (CodeSystemVersionSection.this.urlText == event.getSource()) {
                CodeSystemVersionSection.this.urlModified = true;
            }
            if (CodeSystemVersionSection.this.effectiveDateText == event.getSource()) {
                CodeSystemVersionSection.this.effectiveDateModified = true;
            }
            if (CodeSystemVersionSection.this.releaseDateText == event.getSource()) {
                CodeSystemVersionSection.this.releaseDateModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                CodeSystemVersionSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            CodeSystemVersionSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!(this.idModified || this.nameModified || this.versionModified || this.fullNameModified || this.sourceModified || this.urlModified || this.effectiveDateModified || this.releaseDateModified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    CodeSystemVersion codeSystemVersion = TermProfileUtil.getCodeSystemVersion((Enumeration)CodeSystemVersionSection.this.umlEnumeration);
                    if (codeSystemVersion == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (CodeSystemVersionSection.this.idModified) {
                        CodeSystemVersionSection.this.idModified = false;
                        this.setLabel("Set CodeSystem ID");
                        String value = CodeSystemVersionSection.this.idText.getText().trim();
                        codeSystemVersion.setIdentifier(value.length() > 0 ? value : null);
                    } else if (CodeSystemVersionSection.this.nameModified) {
                        CodeSystemVersionSection.this.nameModified = false;
                        this.setLabel("Set CodeSystem Name");
                        String value = CodeSystemVersionSection.this.nameText.getText().trim();
                        codeSystemVersion.setEnumerationName(value.length() > 0 ? value : null);
                    } else if (CodeSystemVersionSection.this.fullNameModified) {
                        CodeSystemVersionSection.this.fullNameModified = false;
                        this.setLabel("Set CodeSystem Full Name");
                        String value = CodeSystemVersionSection.this.fullNameText.getText().trim();
                        codeSystemVersion.setFullName(value.length() > 0 ? value : null);
                    } else if (CodeSystemVersionSection.this.versionModified) {
                        CodeSystemVersionSection.this.versionModified = false;
                        this.setLabel("Set CodeSystem Version");
                        String value = CodeSystemVersionSection.this.versionText.getText().trim();
                        codeSystemVersion.setVersion(value.length() > 0 ? value : null);
                    } else if (CodeSystemVersionSection.this.sourceModified) {
                        CodeSystemVersionSection.this.sourceModified = false;
                        this.setLabel("Set CodeSystem Source");
                        String value = CodeSystemVersionSection.this.sourceText.getText().trim();
                        codeSystemVersion.setSource(value.length() > 0 ? value : null);
                    } else if (CodeSystemVersionSection.this.urlModified) {
                        CodeSystemVersionSection.this.urlModified = false;
                        this.setLabel("Set CodeSystem URL");
                        String value = CodeSystemVersionSection.this.urlText.getText().trim();
                        codeSystemVersion.setUrl(value.length() > 0 ? value : null);
                    } else if (CodeSystemVersionSection.this.effectiveDateModified) {
                        CodeSystemVersionSection.this.effectiveDateModified = false;
                        this.setLabel("Set CodeSystem Effective Date");
                        String value = CodeSystemVersionSection.this.effectiveDateText.getText().trim();
                        codeSystemVersion.setEffectiveDate(value.length() > 0 ? value : null);
                    } else if (CodeSystemVersionSection.this.releaseDateModified) {
                        CodeSystemVersionSection.this.releaseDateModified = false;
                        this.setLabel("Set CodeSystem Release Date");
                        String value = CodeSystemVersionSection.this.releaseDateText.getText().trim();
                        codeSystemVersion.setReleaseDate(value.length() > 0 ? value : null);
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    CodeSystemVersionSection.this.updateViews();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void resetFields() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Restore Default Values"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    CodeSystemVersion codeSystemVersion = TermProfileUtil.getCodeSystemVersion((Enumeration)CodeSystemVersionSection.this.umlEnumeration);
                    if (codeSystemVersion == null) {
                        return Status.CANCEL_STATUS;
                    }
                    codeSystemVersion.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_VERSION__IDENTIFIER);
                    codeSystemVersion.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_VERSION__FULL_NAME);
                    codeSystemVersion.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_VERSION__VERSION);
                    codeSystemVersion.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_VERSION__SOURCE);
                    codeSystemVersion.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_VERSION__URL);
                    codeSystemVersion.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_VERSION__EFFECTIVE_DATE);
                    codeSystemVersion.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_VERSION__RELEASE_DATE);
                    CodeSystemVersionSection.this.updateViews();
                    CodeSystemVersionSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        gc.textExtent("");
        gc.dispose();
        shell.dispose();
        Group composite = this.getWidgetFactory().createGroup(parent, "Code System Version");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        int numberOfRows = 5;
        FormData data = null;
        this.nameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel nameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)nameLabel, 0);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(0, numberOfRows, 4);
        this.nameText.setLayoutData((Object)data);
        this.idText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel idLabel = this.getWidgetFactory().createCLabel((Composite)composite, "ID:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.nameText, 5);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        idLabel.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.idText, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)idLabel, 0);
        data.right = new FormAttachment((Control)this.restoreDefaultsButton, 5);
        data.top = new FormAttachment(0, numberOfRows, 4);
        this.idText.setLayoutData((Object)data);
        this.fullNameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel fullNameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Full Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.fullNameText, 0, 0x1000000);
        fullNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)fullNameLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.fullNameText.setLayoutData((Object)data);
        this.sourceText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel sourceLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Source:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.sourceText, 0, 0x1000000);
        sourceLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)sourceLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(2, numberOfRows, 4);
        this.sourceText.setLayoutData((Object)data);
        this.urlText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel urlLabel = this.getWidgetFactory().createCLabel((Composite)composite, "URL:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.urlText, 0, 0x1000000);
        urlLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)urlLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(3, numberOfRows, 4);
        this.urlText.setLayoutData((Object)data);
        this.versionText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel versionLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Version:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.versionText, 0, 0x1000000);
        versionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)versionLabel, 0);
        data.right = new FormAttachment(25, 0);
        data.top = new FormAttachment(4, numberOfRows, 4);
        this.versionText.setLayoutData((Object)data);
        this.releaseDateText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel releaseDateLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Release Date:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.versionText, 5);
        data.top = new FormAttachment((Control)this.releaseDateText, 0, 0x1000000);
        releaseDateLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)releaseDateLabel, 0);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(4, numberOfRows, 4);
        this.releaseDateText.setLayoutData((Object)data);
        this.effectiveDateText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel effectiveDateLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Effective Date:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.releaseDateText, 5);
        data.top = new FormAttachment((Control)this.releaseDateText, 0, 0x1000000);
        effectiveDateLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)effectiveDateLabel, 0);
        data.right = new FormAttachment(75, 0);
        data.top = new FormAttachment(4, numberOfRows, 4);
        this.effectiveDateText.setLayoutData((Object)data);
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.umlEnumeration != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumeration)) != null && editingDomain.isReadOnly(this.umlEnumeration.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Enumeration));
        this.umlEnumeration = (Enumeration)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        String date;
        CodeSystemVersion codeSystemVersion = TermProfileUtil.getCodeSystemVersion((Enumeration)this.umlEnumeration);
        this.idText.removeModifyListener(this.modifyListener);
        this.idText.removeKeyListener(this.keyListener);
        this.idText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            String id = codeSystemVersion.getIdentifier();
            this.idText.setText(id != null ? id : "");
        } else {
            this.idText.setText("");
        }
        this.idText.addModifyListener(this.modifyListener);
        this.idText.addKeyListener(this.keyListener);
        this.idText.addFocusListener(this.focusListener);
        this.nameText.removeModifyListener(this.modifyListener);
        this.nameText.removeKeyListener(this.keyListener);
        this.nameText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            this.nameText.setText(codeSystemVersion.getEnumerationName());
        } else {
            this.nameText.setText("");
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.nameText.addKeyListener(this.keyListener);
        this.nameText.addFocusListener(this.focusListener);
        this.fullNameText.removeModifyListener(this.modifyListener);
        this.fullNameText.removeKeyListener(this.keyListener);
        this.fullNameText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            String name = codeSystemVersion.getFullName();
            this.fullNameText.setText(name != null ? name : "");
        } else {
            this.fullNameText.setText("");
        }
        this.fullNameText.addModifyListener(this.modifyListener);
        this.fullNameText.addKeyListener(this.keyListener);
        this.fullNameText.addFocusListener(this.focusListener);
        this.sourceText.removeModifyListener(this.modifyListener);
        this.sourceText.removeKeyListener(this.keyListener);
        this.sourceText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            String source = codeSystemVersion.getSource();
            this.sourceText.setText(source != null ? source : "");
        } else {
            this.sourceText.setText("");
        }
        this.sourceText.addModifyListener(this.modifyListener);
        this.sourceText.addKeyListener(this.keyListener);
        this.sourceText.addFocusListener(this.focusListener);
        this.urlText.removeModifyListener(this.modifyListener);
        this.urlText.removeKeyListener(this.keyListener);
        this.urlText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            String url = codeSystemVersion.getUrl();
            this.urlText.setText(url != null ? url : "");
        } else {
            this.urlText.setText("");
        }
        this.urlText.addModifyListener(this.modifyListener);
        this.urlText.addKeyListener(this.keyListener);
        this.urlText.addFocusListener(this.focusListener);
        this.versionText.removeModifyListener(this.modifyListener);
        this.versionText.removeKeyListener(this.keyListener);
        this.versionText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            String version = codeSystemVersion.getVersion();
            this.versionText.setText(version != null ? version : "");
        } else {
            this.versionText.setText("");
        }
        this.versionText.addModifyListener(this.modifyListener);
        this.versionText.addKeyListener(this.keyListener);
        this.versionText.addFocusListener(this.focusListener);
        this.releaseDateText.removeModifyListener(this.modifyListener);
        this.releaseDateText.removeKeyListener(this.keyListener);
        this.releaseDateText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            date = codeSystemVersion.getReleaseDate();
            this.releaseDateText.setText(date != null ? date : "");
        } else {
            this.releaseDateText.setText("");
        }
        this.releaseDateText.addModifyListener(this.modifyListener);
        this.releaseDateText.addKeyListener(this.keyListener);
        this.releaseDateText.addFocusListener(this.focusListener);
        this.effectiveDateText.removeModifyListener(this.modifyListener);
        this.effectiveDateText.removeKeyListener(this.keyListener);
        this.effectiveDateText.removeFocusListener(this.focusListener);
        if (codeSystemVersion != null) {
            date = codeSystemVersion.getEffectiveDate();
            this.effectiveDateText.setText(date != null ? date : "");
        } else {
            this.effectiveDateText.setText("");
        }
        this.effectiveDateText.addModifyListener(this.modifyListener);
        this.effectiveDateText.addKeyListener(this.keyListener);
        this.effectiveDateText.addFocusListener(this.focusListener);
        if (this.isReadOnly()) {
            this.idText.setEnabled(false);
            this.nameText.setEnabled(false);
            this.fullNameText.setEnabled(false);
            this.sourceText.setEnabled(false);
            this.urlText.setEnabled(false);
            this.versionText.setEnabled(false);
            this.releaseDateText.setEnabled(false);
            this.effectiveDateText.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.idText.setEnabled(true);
            this.nameText.setEnabled(true);
            this.fullNameText.setEnabled(true);
            this.sourceText.setEnabled(true);
            this.urlText.setEnabled(true);
            this.versionText.setEnabled(true);
            this.releaseDateText.setEnabled(true);
            this.effectiveDateText.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(codeSystemVersion != null);
        }
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!CodeSystemVersionSection.this.isDisposed() && CodeSystemVersionSection.this.umlEnumeration.eResource() != null) {
                        CodeSystemVersionSection.this.refresh();
                    }
                }
            });
        }
    }

    protected void updateViews() {
        NotificationImpl notification = new NotificationImpl(1, null, this.umlEnumeration.getName()){

            public Object getNotifier() {
                return CodeSystemVersionSection.this.umlEnumeration;
            }

            public int getFeatureID(Class expectedClass) {
                return 5;
            }
        };
        this.umlEnumeration.eNotify((Notification)notification);
    }
}

