/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.cda.xml.ui.internal.Logger;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;

public class OpenCDAViewer
extends AbstractHandler {
    private static void open(IWebBrowser browser) throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mdht.cda.xml.ui");
        URL foo = FileLocator.toFileURL((URL)bundle.getEntry("resources/cdaviewer/index.htm"));
        browser.openURL(foo);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection iss = (IStructuredSelection)selection;
                for (Object o : iss) {
                    if (!(o instanceof IResource)) continue;
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("org.eclipse.mdht.cda.xml.ui");
                    OpenCDAViewer.open(browser);
                }
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return null;
    }

    private static void applyXSL(IFile cdaFileName, File temporaryFile, URL styleSheetURL) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(styleSheetURL.openConnection().getInputStream()));
        Transformer xformer = template.newTransformer();
        StreamSource source = new StreamSource(cdaFileName.getContents());
        StreamResult result = new StreamResult(new FileOutputStream(temporaryFile));
        xformer.transform(source, result);
    }
}

