/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers.html;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.eclipse.mdht.cda.xml.ui.handlers.html.RichTextDetails;
import org.eclipse.mdht.cda.xml.ui.handlers.html.RichTextInfo;
import org.eclipse.mdht.cda.xml.ui.handlers.html.STYLES;
import org.eclipse.mdht.cda.xml.ui.handlers.html.TagInfo;

public class HTMLToExcel {
    private static final Pattern HEAVY_REGEX = Pattern.compile("(<col>)|(</col>)|(<br/>)|(</br>)|(<br />)|(< /br>)");
    private static final int START_TAG = 0;
    private static final int END_TAG = 1;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static RichTextString fromHtmlToCellValue(String html, Workbook workBook) {
        Config.IsHTMLEmptyElementTagRecognised = true;
        Matcher m = HEAVY_REGEX.matcher(html);
        String replacedhtml = m.replaceAll("");
        StringBuilder sb = new StringBuilder();
        sb.insert(0, "<div>");
        sb.append(replacedhtml);
        sb.append("</div>");
        String newhtml = sb.toString();
        Source source = new Source((CharSequence)newhtml);
        ArrayList<RichTextDetails> cellValues = new ArrayList<RichTextDetails>();
        for (Element el : source.getAllElements("div")) {
            cellValues.add(HTMLToExcel.createCellValue(el.toString(), workBook));
        }
        RichTextString cellValue = HTMLToExcel.mergeTextDetails(cellValues);
        return cellValue;
    }

    private static RichTextString mergeTextDetails(List<RichTextDetails> cellValues) {
        Config.IsHTMLEmptyElementTagRecognised = true;
        StringBuilder textBuffer = new StringBuilder();
        LinkedHashMap<Integer, Font> mergedMap = new LinkedHashMap<Integer, Font>(550, 0.95f);
        int currentIndex = 0;
        for (RichTextDetails richTextDetail : cellValues) {
            currentIndex = textBuffer.length();
            for (Map.Entry<Integer, Font> entry : richTextDetail.getFontMap().entrySet()) {
                mergedMap.put(entry.getKey() + currentIndex, entry.getValue());
            }
            textBuffer.append(richTextDetail.getRichText()).append(NEW_LINE);
        }
        XSSFRichTextString richText = new XSSFRichTextString(textBuffer.toString());
        return richText;
    }

    public static RichTextDetails createCellValue(String html, Workbook workBook) {
        Config.IsHTMLEmptyElementTagRecognised = true;
        Source source = new Source((CharSequence)html);
        LinkedHashMap<String, TagInfo> tagMap = new LinkedHashMap<String, TagInfo>(550, 0.95f);
        for (Element e : source.getChildElements()) {
            HTMLToExcel.getInfo(e, tagMap);
        }
        StringBuilder sbPatt = new StringBuilder();
        sbPatt.append("(").append(StringUtils.join(tagMap.keySet(), (String)"|")).append(")");
        String patternString = sbPatt.toString();
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(html);
        StringBuffer textBuffer = new StringBuffer();
        ArrayList<RichTextInfo> textInfos = new ArrayList<RichTextInfo>();
        ArrayDeque<RichTextInfo> richTextBuffer = new ArrayDeque<RichTextInfo>();
        while (matcher.find()) {
            RichTextInfo info;
            matcher.appendReplacement(textBuffer, "");
            TagInfo currentTag = (TagInfo)tagMap.get(matcher.group(1));
            if (currentTag.getTagType() == 0) {
                richTextBuffer.push(HTMLToExcel.getRichTextInfo(currentTag, textBuffer.length(), workBook));
                continue;
            }
            if (richTextBuffer.isEmpty() || (info = (RichTextInfo)richTextBuffer.pop()) == null) continue;
            info.setEndIndex(textBuffer.length());
            textInfos.add(info);
        }
        matcher.appendTail(textBuffer);
        Map<Integer, Font> fontMap = HTMLToExcel.buildFontMap(textInfos, workBook);
        return new RichTextDetails(textBuffer.toString(), fontMap);
    }

    private static Map<Integer, Font> buildFontMap(List<RichTextInfo> textInfos, Workbook workBook) {
        LinkedHashMap<Integer, Font> fontMap = new LinkedHashMap<Integer, Font>(550, 0.95f);
        for (RichTextInfo richTextInfo : textInfos) {
            if (!richTextInfo.isValid()) continue;
            int i = richTextInfo.getStartIndex();
            while (i < richTextInfo.getEndIndex()) {
                fontMap.put(i, HTMLToExcel.mergeFont((Font)fontMap.get(i), richTextInfo.getFontStyle(), richTextInfo.getFontValue(), workBook));
                ++i;
            }
        }
        return fontMap;
    }

    private static Font mergeFont(Font font, STYLES fontStyle, String fontValue, Workbook workBook) {
        if (font == null) {
            font = workBook.createFont();
        }
        switch (fontStyle) {
            case BOLD: 
            case EM: 
            case STRONG: {
                break;
            }
            case UNDERLINE: {
                font.setUnderline((byte)1);
                break;
            }
            case ITALLICS: {
                font.setItalic(true);
                break;
            }
            case PRE: {
                font.setFontName("Courier New");
            }
            case COLOR: {
                if (HTMLToExcel.isEmpty(fontValue)) break;
                font.setColor(IndexedColors.BLACK.getIndex());
                break;
            }
        }
        return font;
    }

    private static RichTextInfo getRichTextInfo(TagInfo currentTag, int startIndex, Workbook workBook) {
        RichTextInfo info = null;
        switch (STYLES.fromValue(currentTag.getTagName())) {
            case SPAN: {
                if (HTMLToExcel.isEmpty(currentTag.getStyle())) break;
                String[] stringArray = currentTag.getStyle().split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String style = stringArray[n2];
                    String[] styleDetails = style.split(":");
                    if (styleDetails != null && styleDetails.length > 1 && "COLOR".equalsIgnoreCase(styleDetails[0].trim())) {
                        info = new RichTextInfo(startIndex, -1, STYLES.COLOR, styleDetails[1]);
                    }
                    ++n2;
                }
                break;
            }
            default: {
                info = new RichTextInfo(startIndex, -1, STYLES.fromValue(currentTag.getTagName()));
            }
        }
        return info;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static void getInfo(Element e, Map<String, TagInfo> tagMap) {
        tagMap.put(e.getStartTag().toString(), new TagInfo(e.getStartTag().getName(), e.getAttributeValue("style"), 0));
        if (e.getChildElements().size() > 0) {
            List children = e.getChildElements();
            for (Element child : children) {
                HTMLToExcel.getInfo(child, tagMap);
            }
        }
        if (e.getEndTag() != null) {
            tagMap.put(e.getEndTag().toString(), new TagInfo(e.getEndTag().getName(), 1));
        } else {
            tagMap.put(e.getStartTag().toString(), new TagInfo(e.getStartTag().getName(), 1));
        }
    }
}

