/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.mdht.uml.cda.tests.DiagnosticOutputHelper;
import org.eclipse.mdht.uml.cda.tests.SystemOutValidationHandler;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_PQ;
import org.eclipse.mdht.uml.hl7.datatypes.IVXB_PQ;
import org.eclipse.mdht.uml.hl7.datatypes.PQ;

public class IVLPQTest {
    private static boolean diagnosticsHaveErrors(Diagnostic oDiagnostic) {
        return oDiagnostic.getSeverity() != 0;
    }

    private static boolean processDiagnostics(Diagnostic oDiagnostic) {
        boolean bResult = true;
        if (IVLPQTest.diagnosticsHaveErrors(oDiagnostic)) {
            SystemOutValidationHandler oValHandler = new SystemOutValidationHandler();
            DiagnosticOutputHelper.processDiagnostic(oDiagnostic, oValHandler);
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption1LowOnly() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        IVXB_PQ oLow = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setLow(oLow);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithWidth() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        IVXB_PQ oLow = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setLow(oLow);
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithHigh() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        IVXB_PQ oLow = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setLow(oLow);
        IVXB_PQ oHigh = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithWidthAndHigh_FailureCase() {
        boolean bResult = true;
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        IVXB_PQ oLow = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setLow(oLow);
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setWidth(oWidth);
        IVXB_PQ oHigh = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        if (!IVLPQTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption2HighOnly() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        IVXB_PQ oHigh = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption2HighWithCenter_FailureCase() {
        boolean bResult = true;
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        IVXB_PQ oHigh = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setHigh(oHigh);
        PQ oCenter = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setCenter(oCenter);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        if (!IVLPQTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption3WidthOnly() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption3WidthAndHigh() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setWidth(oWidth);
        IVXB_PQ oHigh = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterOnly() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        PQ oCenter = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setCenter(oCenter);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterAndWidth() {
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        PQ oCenter = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setCenter(oCenter);
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        return IVLPQTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterAndLow_FailureCase() {
        boolean bResult = true;
        IVL_PQ oIvlPq = DatatypesFactory.eINSTANCE.createIVL_PQ();
        PQ oCenter = DatatypesFactory.eINSTANCE.createPQ();
        oIvlPq.setCenter(oCenter);
        IVXB_PQ oLow = DatatypesFactory.eINSTANCE.createIVXB_PQ();
        oIvlPq.setLow(oLow);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlPq);
        if (!IVLPQTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!IVLPQTest.testOption1LowOnly()) {
            bFailure = true;
            System.out.println("testOption1LowOnly failed!");
        }
        if (!IVLPQTest.testOption1LowWithWidth()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidth failed!");
        }
        if (!IVLPQTest.testOption1LowWithHigh()) {
            bFailure = true;
            System.out.println("testOption1LowWithHigh failed!");
        }
        if (!IVLPQTest.testOption1LowWithWidthAndHigh_FailureCase()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidthAndHigh_FailureCase failed!");
        }
        if (!IVLPQTest.testOption2HighOnly()) {
            bFailure = true;
            System.out.println("testOption2HighOnly failed!");
        }
        if (!IVLPQTest.testOption2HighWithCenter_FailureCase()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidthAndHigh_FailureCase failed!");
        }
        if (!IVLPQTest.testOption3WidthOnly()) {
            bFailure = true;
            System.out.println("testOption3WidthOnly failed!");
        }
        if (!IVLPQTest.testOption3WidthAndHigh()) {
            bFailure = true;
            System.out.println("testOption3WidthAndHigh failed!");
        }
        if (!IVLPQTest.testOption4CenterOnly()) {
            bFailure = true;
            System.out.println("testOption4CenterOnly failed!");
        }
        if (!IVLPQTest.testOption4CenterAndWidth()) {
            bFailure = true;
            System.out.println("testOption4CenterAndWidth failed!");
        }
        if (!IVLPQTest.testOption4CenterAndLow_FailureCase()) {
            bFailure = true;
            System.out.println("testOption4CenterAndLow_FailureCase failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

