/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mdht.uml.transform.internal.Logger;

public class PluginPropertiesUtil {
    private static String CONSTRAINT_MESSAGE_MARKER = "# Constraint messages";
    private IFile pluginProperties;
    private Properties properties;
    private List<String> newProperties = new ArrayList<String>();

    public PluginPropertiesUtil() {
    }

    public PluginPropertiesUtil(IFile pluginProperties) {
        this.initPluginProperties(pluginProperties);
    }

    private void initPluginProperties(IFile pluginProperties) {
        this.pluginProperties = pluginProperties;
        this.properties = new Properties();
        try {
            this.properties.load(pluginProperties.getContents());
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public PluginPropertiesUtil(Resource resource) {
        this(PluginPropertiesUtil.findPluginProperties(resource));
    }

    public void setPluginProperties(IFile pluginProperties) {
        this.initPluginProperties(pluginProperties);
    }

    public void initPluginProperties(Resource resource) {
        this.initPluginProperties(PluginPropertiesUtil.findPluginProperties(resource));
    }

    public void addProperty(String key, String value) {
        if (!this.properties.containsKey(key)) {
            this.newProperties.add(key);
        }
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    private static IFile findPluginProperties(Resource resource) {
        IResource file;
        IResource iResource;
        IFile pluginProperties = null;
        IProject project = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (resource.getURI().isFile()) {
            IPath modelLocation = Path.fromOSString((String)resource.getURI().toFileString());
            IFile[] files = workspace.getRoot().findFilesForLocation(modelLocation);
            if (files.length > 0) {
                project = files[0].getProject();
            }
        } else if (resource.getURI().isPlatformResource() && (iResource = workspace.getRoot().findMember(new Path(resource.getURI().path()).removeFirstSegments(1))) != null) {
            project = iResource.getProject();
        }
        if (project != null && !(pluginProperties = (file = project.findMember("plugin.properties")) instanceof IFile ? (IFile)file : project.getFile("plugin.properties")).exists()) {
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
            try {
                pluginProperties.create((InputStream)is, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return pluginProperties;
    }

    public void save() {
        block20: {
            FileOutputStream out = null;
            PrintStream printStream = null;
            ArrayList<String> propertyKeys = new ArrayList<String>();
            try {
                try {
                    if (this.hasConstraintMessageMarker()) {
                        String header = this.copyFileHeader();
                        out = new FileOutputStream(this.pluginProperties.getLocation().toFile(), false);
                        printStream = new PrintStream(out);
                        printStream.print(header);
                        for (Object key : this.properties.keySet()) {
                            propertyKeys.add(key.toString());
                        }
                    } else {
                        out = new FileOutputStream(this.pluginProperties.getLocation().toFile(), true);
                        printStream = new PrintStream(out);
                        propertyKeys.addAll(this.newProperties);
                    }
                    Collections.sort(propertyKeys);
                    for (String key : propertyKeys) {
                        if ("pluginName".equals(key) || "providerName".equals(key)) continue;
                        String value = (String)this.properties.get(key);
                        printStream.println(String.valueOf(key) + " = " + value);
                    }
                }
                catch (FileNotFoundException e) {
                    Logger.logException(e);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            Logger.logException(e2);
                        }
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
        }
        try {
            this.pluginProperties.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean hasConstraintMessageMarker() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String copyFileHeader() {
        StringBuffer header;
        block16: {
            header = new StringBuffer();
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(this.pluginProperties.getLocation().toFile()));
                    while (reader.ready()) {
                        String line = reader.readLine();
                        header.append(line).append("\n");
                        if (!line.startsWith(CONSTRAINT_MESSAGE_MARKER)) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return header.toString();
    }
}

