/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ecore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.PluginPropertiesUtil;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.AnnotationsUtil;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformAbstract;
import org.eclipse.mdht.uml.transform.internal.Logger;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class TransformInlinedProperties
extends TransformAbstract {
    PluginPropertiesUtil properties = this.transformerOptions.getPluginPropertiesUtil();

    public TransformInlinedProperties(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    public Constraint appendInlinedOCLConstraint(Class classToBeConstrained, String constraintName, IEcoreProfileReflection.ValidationSeverityKind severity, String validationMessage, String oclConstraint) {
        if (classToBeConstrained.getOwnedRule(constraintName) != null) {
            return classToBeConstrained.getOwnedRule(constraintName);
        }
        Constraint inlinedConstraint = classToBeConstrained.createOwnedRule(constraintName, UMLPackage.eINSTANCE.getConstraint());
        inlinedConstraint.getConstrainedElements().add((Object)classToBeConstrained);
        OpaqueExpression expression = (OpaqueExpression)inlinedConstraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
        expression.getLanguages().add((Object)"OCL");
        expression.getBodies().add((Object)oclConstraint);
        switch (severity) {
            case INFO: {
                this.addValidationInfo(classToBeConstrained, constraintName, validationMessage);
                break;
            }
            case WARNING: {
                this.addValidationWarning(classToBeConstrained, constraintName, validationMessage);
                break;
            }
            default: {
                this.addValidationError(classToBeConstrained, constraintName, validationMessage);
            }
        }
        this.annotateQueryConstraint(inlinedConstraint, classToBeConstrained);
        return inlinedConstraint;
    }

    @Deprecated
    protected static boolean isInlineClassLocal(Class _class) {
        boolean inline = false;
        for (Comment comment : _class.getOwnedComments()) {
            if (!comment.getBody().startsWith("INLINE")) continue;
            inline = true;
            break;
        }
        return inline;
    }

    public boolean isInlineClass(Class _class) {
        return TransformInlinedProperties.isInlineClassLocal(_class);
    }

    @Deprecated
    protected static String getInlineFilterLocal(Class inlineClass) {
        String filter = "";
        for (Comment comment : inlineClass.getOwnedComments()) {
            if (!comment.getBody().startsWith("INLINE&")) continue;
            String[] temp = comment.getBody().split("&");
            if (temp.length != 2) break;
            filter = String.format("->select(%s)", temp[1]);
            break;
        }
        if ("".equals(filter)) {
            for (Classifier next : inlineClass.getGenerals()) {
                if (next instanceof Class && !"".equals(filter = TransformInlinedProperties.getInlineFilterLocal((Class)next))) break;
            }
        }
        return filter;
    }

    public String getInlineFilter(Class inlineClass) {
        return TransformInlinedProperties.getInlineFilterLocal(inlineClass);
    }

    public Object caseProperty(Property property) {
        HashMap<String, ArrayList<String>> constraints = new HashMap<String, ArrayList<String>>();
        Class owner = property.getClass_();
        Association association = null;
        Class baseDatatype = null;
        if (owner != null && !(owner instanceof Association) && property.getType() instanceof Class && property.getOwner() != property.getType()) {
            Class propertyType = (Class)property.getType();
            association = property.getAssociation();
            baseDatatype = this.getBaseDatatype(propertyType, (Element)property);
            if (association != null && this.isInlineClass(propertyType) || baseDatatype != null) {
                Class baseOwner = null;
                if (owner != null && (baseOwner = this.getBaseClass(owner)) == null) {
                    baseOwner = this.getBaseDatatype(owner, (Element)property);
                }
                if (baseOwner != null) {
                    AnnotationsUtil bucketAnnotations = this.getEcoreProfile().annotate((Element)owner);
                    Association validationElement = association != null ? association : property;
                    this.collectConstraints(property, property.getClass_(), bucketAnnotations, (Class)property.getType(), this.getEcoreProfile().getValidationMessage((Element)validationElement, IEcoreProfileReflection.ValidationStereotypeKind.ANY), "self." + this.getNullSafePath(baseOwner, propertyType, property) + this.getInlineFilter(propertyType), owner.getName(), constraints, property.getName());
                    bucketAnnotations.saveAnnotations();
                } else {
                    Logger.log(4, String.format("Unsupported inlined association or datatype property %s from %s; %s has no base element", property.getName(), property.getNamespace().getQualifiedName(), property.getNamespace().getQualifiedName()));
                }
            }
        }
        return property;
    }

    public String getNullSafePath(Class baseSourceClass, Class targetClass, Property sourceProperty) {
        String result = this.getPath(baseSourceClass, targetClass, sourceProperty);
        if (result.length() > 0) {
            result = String.valueOf(result) + "->excluding(null)";
        }
        return result;
    }

    public String getPath(Class baseSourceClass, Class targetClass, Property sourceProperty) {
        Property property = null;
        for (Property rededfinedProperty : sourceProperty.getRedefinedProperties()) {
            property = baseSourceClass.getOwnedAttribute(rededfinedProperty.getName(), rededfinedProperty.getType(), true, null, false);
        }
        if (property == null) {
            property = baseSourceClass.getOwnedAttribute(null, (Type)targetClass, true, null, false);
        }
        if (property == null) {
            for (Classifier c : targetClass.allParents()) {
                property = baseSourceClass.getOwnedAttribute(null, (Type)c, true, null, false);
                if (property != null || this.isBaseModel((Element)targetClass, (Element)c)) break;
            }
        }
        if (property == null) {
            property = baseSourceClass.getOwnedAttribute(sourceProperty.getName(), null, true, null, false);
        }
        if (property != null) {
            return property.getName();
        }
        return "";
    }

    private String getRelativeOCL(Constraint constraint) {
        if (constraint.getSpecification() instanceof OpaqueExpression) {
            OpaqueExpression oe = (OpaqueExpression)constraint.getSpecification();
            int index = 0;
            for (String language : oe.getLanguages()) {
                if ("OCL".equals(language)) {
                    return ((String)oe.getBodies().get(index)).replaceAll("self.", "");
                }
                ++index;
            }
        }
        return null;
    }

    private void collectConstraints(Property theProperty, Class bucketClass, AnnotationsUtil bucketAnnotations, Class inlineClass, String message, String path, String stack, HashMap<String, ArrayList<String>> constraints, String associationName) {
        AnnotationsUtil inlineClassAnnotations = this.getEcoreProfile().annotate((Element)inlineClass);
        String warningsAnnotation = inlineClassAnnotations.getAnnotation("constraints.validation.warning");
        String infosAnnotation = inlineClassAnnotations.getAnnotation("constraints.validation.info");
        HashSet<String> warnings = warningsAnnotation == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(warningsAnnotation.split(" ")));
        HashSet<String> infos = infosAnnotation == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(infosAnnotation.split(" ")));
        String splitName = this.getEcoreProfile().getPrefixedSplitName((NamedElement)inlineClass);
        for (Property property : inlineClass.getOwnedAttributes()) {
            Class ownerBaseType;
            Class propertyType;
            Class clazz = propertyType = property.getType() instanceof Class ? (Class)property.getType() : null;
            if (propertyType == null || inlineClass == propertyType || this.isBaseModel((Element)bucketClass, (Element)propertyType) || this.isDatatypesModel((Element)bucketClass, (Element)propertyType) || this.getEcoreProfile().isPrimaryEClass(propertyType) || property.getOwner() == propertyType || this.getBaseClass(inlineClass) == null && this.getBaseDatatype(inlineClass, (Element)bucketClass) == null) continue;
            Property validationElement = property.getAssociation() != null ? property.getAssociation() : property;
            String associationMessage = this.getEcoreProfile().getValidationMessage((Element)validationElement, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
            associationMessage = associationMessage.replaceAll("its type is " + UMLUtil.splitName((NamedElement)property.getType()), "");
            Class propertyBaseType = this.getBaseClass(propertyType);
            if (propertyBaseType == null) {
                propertyBaseType = this.getBaseDatatype(propertyType, (Element)inlineClass);
            }
            if (associationMessage != null && propertyBaseType != null) {
                associationMessage = associationMessage.replaceAll(this.getEcoreProfile().getPrefixedSplitName((NamedElement)property.getType()), propertyBaseType.getName().toLowerCase());
                associationMessage = associationMessage.replaceAll(UMLUtil.splitName((NamedElement)property.getType()), propertyBaseType.getName().toLowerCase());
                associationMessage = associationMessage.replaceAll(this.getEcoreProfile().getPrefixedSplitName((NamedElement)property.getClass_()), "each");
            }
            if ((ownerBaseType = this.getBaseClass(inlineClass)) == null) {
                ownerBaseType = this.getBaseDatatype(inlineClass, (Element)bucketClass);
            }
            this.collectConstraints(property, bucketClass, bucketAnnotations, propertyType, String.valueOf(message) + " " + associationMessage, String.valueOf(path) + "." + this.getNullSafePath(ownerBaseType, propertyType, property) + this.getInlineFilter(propertyType), String.valueOf(stack) + inlineClass.getName(), constraints, property.getName());
        }
        for (Constraint constraint : inlineClass.getOwnedRules()) {
            IEcoreProfileReflection.ValidationSeverityKind constraintSeverity = IEcoreProfileReflection.ValidationSeverityKind.ERROR;
            if (infos.contains(constraint.getName())) {
                constraintSeverity = IEcoreProfileReflection.ValidationSeverityKind.INFO;
            } else if (warnings.contains(constraint.getName())) {
                constraintSeverity = IEcoreProfileReflection.ValidationSeverityKind.WARNING;
            }
            String relativeOCL = this.getRelativeOCL(constraint);
            if (relativeOCL == null) continue;
            String calculatedConstraintName = null;
            if (constraint.getName().startsWith(stack)) {
                calculatedConstraintName = constraint.getName();
            } else {
                boolean override = false;
                if (constraint.getOwner() instanceof Classifier) {
                    block2: for (Classifier parent : ((Classifier)constraint.getOwner()).allParents()) {
                        for (Constraint c : parent.getOwnedRules()) {
                            if (!constraint.getName().equals(this.createConstraintName((NamedElement)c))) continue;
                            override = true;
                            continue block2;
                        }
                    }
                }
                for (Element e : constraint.getConstrainedElements()) {
                    Property p;
                    if (!(e instanceof Property) || (p = (Property)e).getRedefinedElements().isEmpty()) continue;
                    override = true;
                }
                calculatedConstraintName = override ? constraint.getName() : String.valueOf(stack) + constraint.getName();
            }
            String constraintMessage = this.properties.getProperty(this.generatePropertyMessageKey(inlineClass, constraint.getName()));
            constraintMessage = constraintMessage != null ? constraintMessage.replaceAll(splitName, associationName) : this.properties.getProperty(String.valueOf(bucketClass.getName()) + constraint.getName());
            Constraint inlinedConstraint = this.appendInlinedOCLConstraint(bucketClass, calculatedConstraintName, constraintSeverity, String.valueOf(message) + " " + constraintMessage, String.valueOf(path) + this.getInlineFilter(inlineClass) + "->reject(" + relativeOCL + ")");
            String dependency = this.getConstraintDependency(inlineClassAnnotations, constraint.getName());
            if (dependency == null) continue;
            this.setConstraintDependency(bucketAnnotations, inlinedConstraint.getName(), dependency);
        }
    }
}

