/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.transform.CDABaseModelReflection;
import org.eclipse.mdht.uml.transform.AbstractTransformer;
import org.eclipse.mdht.uml.transform.EcoreTransformUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class CDAAbstractTransformer
extends AbstractTransformer {
    protected TransformerOptions transformerOptions;
    private final IBaseModelReflection baseModelReflection = new CDABaseModelReflection();

    public CDAAbstractTransformer() {
        this(new TransformerOptions());
    }

    public CDAAbstractTransformer(TransformerOptions options) {
        this.transformerOptions = options;
    }

    public final IBaseModelReflection getBaseModelReflection() {
        return this.baseModelReflection;
    }

    public abstract void transformModelElement(Element var1);

    public abstract void saveResources();

    protected Package initializeModelPackageFrom(Element element, String newModelPath, String suffix, String nsPrefix, String prefix) {
        Package sourcePkg = element.getNearestPackage();
        Package newModelPkg = null;
        URI newModelURI = null;
        if (newModelPath != null) {
            newModelURI = URI.createFileURI((String)newModelPath);
        }
        if (newModelURI == null) {
            newModelURI = sourcePkg.eResource().getURI();
            newModelURI = newModelURI.trimFileExtension();
            newModelURI = newModelURI.trimSegments(1).appendSegment(String.valueOf(newModelURI.lastSegment()) + "_" + suffix);
            newModelURI = newModelURI.appendFileExtension(sourcePkg.eResource().getURI().fileExtension());
        }
        Resource newModelResource = element.eResource().getResourceSet().createResource(newModelURI);
        newModelPkg = UMLFactory.eINSTANCE.createPackage();
        newModelResource.getContents().add((Object)newModelPkg);
        Profile cdaProfile = CDAProfileUtil.getCDAProfile((ResourceSet)element.eResource().getResourceSet());
        if (cdaProfile != null) {
            newModelPkg.applyProfile(cdaProfile);
        }
        Stereotype ePackage = EcoreTransformUtil.getEcoreStereotype((EObject)sourcePkg, (String)"EPackage");
        UMLUtil.safeApplyStereotype((Element)newModelPkg, (Stereotype)ePackage);
        newModelPkg.setValue(ePackage, "nsPrefix", (Object)nsPrefix);
        newModelPkg.setValue(ePackage, "prefix", (Object)prefix);
        String modelPackageName = null;
        String modelNsURI = null;
        String modelBasePackage = null;
        Stereotype modelCodeGen = CDAProfileUtil.getAppliedCDAStereotype((Element)sourcePkg, (String)"CodegenSupport");
        if (modelCodeGen != null) {
            modelPackageName = (String)sourcePkg.getValue(modelCodeGen, "packageName");
            modelNsURI = (String)sourcePkg.getValue(modelCodeGen, "nsURI");
            modelBasePackage = (String)sourcePkg.getValue(modelCodeGen, "basePackage");
        }
        newModelPkg.setName(sourcePkg.getName());
        newModelPkg.setValue(ePackage, "packageName", (Object)sourcePkg.getName());
        if (modelBasePackage != null && modelPackageName != null) {
            newModelPkg.setValue(ePackage, "basePackage", (Object)(String.valueOf(modelBasePackage) + "." + modelPackageName));
        }
        if (modelNsURI != null) {
            newModelPkg.setValue(ePackage, "nsURI", (Object)(String.valueOf(modelNsURI) + "/" + nsPrefix));
        }
        return newModelPkg;
    }
}

