/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.common.internal.Logger;
import org.eclipse.mdht.uml.common.modelfilter.ModelFilterUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class ModelFilter {
    private Package sourcePackage;
    private Package filteredPackage;
    private Map<String, Class> filteredMapping;

    public ModelFilter(Package sourcePackage, Package filteredPackage) {
        this.sourcePackage = sourcePackage;
        this.filteredPackage = filteredPackage;
        this.filteredMapping = new HashMap<String, Class>();
        if (sourcePackage != null) {
            EcoreUtil.resolveAll((Resource)sourcePackage.eResource());
        }
        if (filteredPackage != null) {
            EcoreUtil.resolveAll((Resource)filteredPackage.eResource());
        }
        URI xsdDatatypesURI = URI.createURI((String)"pathmap://XMLmodeling_LIBRARIES/XSDDataTypes.library.uml");
        sourcePackage.eResource().getResourceSet().getResource(xsdDatatypesURI, true);
        this.assignFilteredNamespaceURI(sourcePackage, filteredPackage);
    }

    public Package getFilteredPackage() {
        return this.filteredPackage;
    }

    protected boolean isDefaultHidden(NamedElement element) {
        boolean hidden = false;
        return hidden;
    }

    protected boolean isDefaultCollapsed(NamedElement element) {
        boolean collapsed = false;
        return collapsed;
    }

    public boolean isHidden(NamedElement element) {
        if (ModelFilterUtil.isHidden(element)) {
            return true;
        }
        if (ModelFilterUtil.isShown(element)) {
            return false;
        }
        if (ModelFilterUtil.isCollapsed(element)) {
            return false;
        }
        return this.isDefaultHidden(element);
    }

    public boolean isCollapsed(NamedElement element) {
        return ModelFilterUtil.isCollapsed(element) ? true : this.isDefaultCollapsed(element);
    }

    public void filterPackage(Package pkg) {
        try {
            TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(pkg));
            while (iterator != null && iterator.hasNext()) {
                EObject child = (EObject)iterator.next();
                if (!(child instanceof Class)) continue;
                this.filterClass((Class)child);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.logException(e);
        }
    }

    public Class filterClass(Class sourceClass) {
        if (this.isHidden((NamedElement)sourceClass)) {
            return null;
        }
        Class filteredClass = this.filteredMapping.get(EcoreUtil.getURI((EObject)sourceClass).toString());
        if (filteredClass == null) {
            Class filteredOwner;
            if (sourceClass.getOwner() instanceof Class && (filteredOwner = this.filteredMapping.get(EcoreUtil.getURI((EObject)sourceClass.getOwner()).toString())) != null) {
                filteredClass = (Class)filteredOwner.getNestedClassifier(sourceClass.getName());
            }
            if (filteredClass == null) {
                filteredClass = (Class)EcoreUtil.copy((EObject)sourceClass);
                this.filteredPackage.getOwnedTypes().add((Object)filteredClass);
                UMLUtil.cloneStereotypes(sourceClass, filteredClass);
            }
            this.filteredMapping.put(EcoreUtil.getURI((EObject)sourceClass).toString(), filteredClass);
            String businessName = this.getFilteredClassName(sourceClass);
            if (businessName != null) {
                filteredClass.setName(businessName);
            }
            ArrayList sourceAttributes = new ArrayList(sourceClass.getOwnedAttributes());
            for (Property property : sourceAttributes) {
                this.processProperty(property, filteredClass);
            }
            ArrayList constraints = new ArrayList(filteredClass.getOwnedRules());
            for (Constraint constraint : constraints) {
                constraint.destroy();
            }
        }
        return filteredClass;
    }

    protected void processProperty(Property property, Class filteredClass) {
        String businessName = this.getFilteredPropertyName(property);
        Property mappedProperty = filteredClass.getOwnedAttribute(property.getName(), null);
        if (mappedProperty == null && (mappedProperty = filteredClass.getOwnedAttribute(businessName, null)) == null) {
            return;
        }
        if (this.isHidden((NamedElement)property)) {
            filteredClass.getOwnedAttributes().remove((Object)mappedProperty);
            mappedProperty.destroy();
            return;
        }
        if (this.isCollapsed((NamedElement)property)) {
            List<Property> collapsedContent = this.getCollapsedContent(property);
            filteredClass.getOwnedAttributes().remove((Object)mappedProperty);
            mappedProperty.destroy();
            for (Property collapsedProperty : collapsedContent) {
                Property clonedProperty = (Property)EcoreUtil.copy((EObject)collapsedProperty);
                filteredClass.getOwnedAttributes().add((Object)clonedProperty);
                UMLUtil.cloneStereotypes((Element)collapsedProperty, (Element)clonedProperty);
                if (clonedProperty.getLower() > property.getLower()) {
                    clonedProperty.setLower(property.getLower());
                }
                this.processProperty(collapsedProperty, filteredClass);
                if (collapsedContent.size() != 1) continue;
                clonedProperty.setName(businessName);
            }
            return;
        }
        mappedProperty.setName(businessName);
        Type filteredType = null;
        if (property.getType() instanceof Class && property.getType().getNearestPackage() == property.getNearestPackage()) {
            filteredType = this.filterClass((Class)property.getType());
            mappedProperty.setType(filteredType);
        } else {
            filteredType = property.getType();
        }
        if (property.getAssociation() != null) {
            Association assocClone = (Association)this.filteredPackage.createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
            assocClone.getMemberEnds().add((Object)mappedProperty);
            Property ownedEnd = UMLFactory.eINSTANCE.createProperty();
            ownedEnd.setType((Type)filteredClass);
            assocClone.getOwnedEnds().add((Object)ownedEnd);
            UMLUtil.cloneStereotypes((Element)property.getAssociation(), (Element)assocClone);
        } else {
            Classifier newType = this.getFilteredPropertyType(property);
            if (newType != null) {
                mappedProperty.setType((Type)newType);
            }
        }
    }

    protected boolean isXMLAttribute(Property property) {
        Stereotype eAttribute = property.getAppliedStereotype("Ecore::EAttribute");
        return eAttribute != null;
    }

    protected String normalizeCodeName(String name) {
        String[] parts;
        String result = "";
        String[] stringArray = parts = name.split(" ");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = String.valueOf(result) + part.substring(0, 1).toUpperCase() + part.substring(1);
            ++n2;
        }
        return result;
    }

    protected void assignFilteredNamespaceURI(Package sourcePackage, Package filteredPackage) {
    }

    protected String getFilteredClassName(Class umlClass) {
        String businessName = NamedElementUtil.getBusinessName((NamedElement)umlClass);
        if (businessName != null) {
            businessName = this.normalizeCodeName(businessName);
            businessName = UML2Util.getValidJavaIdentifier((String)businessName);
            businessName = String.valueOf(businessName.substring(0, 1).toUpperCase()) + businessName.substring(1);
        }
        return businessName;
    }

    protected String getFilteredPropertyName(Property property) {
        String businessName = NamedElementUtil.getBusinessName((NamedElement)property);
        if (businessName != null) {
            businessName = this.normalizeCodeName(businessName);
            businessName = UML2Util.getValidJavaIdentifier((String)businessName);
            businessName = String.valueOf(businessName.substring(0, 1).toLowerCase()) + businessName.substring(1);
        }
        return businessName;
    }

    protected Classifier getFilteredPropertyType(Property property) {
        return this.getPropertyTypeReplacement(property);
    }

    protected List<Property> getCollapsedContent(Property property) {
        ArrayList<Property> collapsedContent = new ArrayList<Property>();
        if (property.getType() instanceof Class) {
            for (Property nestedProperty : ((Class)property.getType()).getOwnedAttributes()) {
                if (this.isHidden((NamedElement)nestedProperty)) continue;
                collapsedContent.add(nestedProperty);
            }
        }
        return collapsedContent;
    }

    protected Classifier getPropertyTypeReplacement(Property property) {
        String qualifiedName = ModelFilterUtil.getTypeReplacement((NamedElement)property);
        if (qualifiedName != null) {
            ResourceSet resourceSet = property.eResource().getResourceSet();
            Collection elements = org.eclipse.uml2.uml.util.UMLUtil.findNamedElements((ResourceSet)resourceSet, (String)qualifiedName);
            for (NamedElement namedElement : elements) {
                if (!(namedElement instanceof Classifier)) continue;
                return (Classifier)namedElement;
            }
        }
        return null;
    }
}

