/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.NamedElement;

public class NamedElementUtil
extends UMLUtil {
    public static final String QUALIFIED_NAME_SEPARATOR = "::";
    private static final String PUBLIC_STRING = "+";
    private static final String PROTECTED_STRING = "#";
    private static final String PRIVATE_STRING = "-";
    private static final String PACKAGE_STRING = "~";

    public static int getQualifiedNameMaxDepth(NamedElement namedElement) {
        int d = 0;
        String s = namedElement.getQualifiedName();
        if (s == null) {
            return 0;
        }
        int n = 0;
        while ((n = s.indexOf(QUALIFIED_NAME_SEPARATOR, n)) != -1) {
            n += 2;
            ++d;
        }
        return d;
    }

    public static String getVisibilityAsSign(NamedElement element) {
        String vKindValue = "";
        switch (element.getVisibility().getValue()) {
            case 0: {
                vKindValue = PUBLIC_STRING;
                break;
            }
            case 1: {
                vKindValue = PRIVATE_STRING;
                break;
            }
            case 3: {
                vKindValue = PACKAGE_STRING;
                break;
            }
            case 2: {
                vKindValue = PROTECTED_STRING;
            }
        }
        return vKindValue;
    }

    public static String getPropertyKey(NamedElement namedElement, String prefix) {
        String qualifiedName = namedElement.getQualifiedName();
        String prefixString = prefix == null ? "" : "_" + prefix + "_";
        return String.valueOf(prefixString) + UML2Util.getValidJavaIdentifier((String)(UML2Util.isEmpty((String)qualifiedName) ? "" : qualifiedName.replace(':', '_')));
    }

    public static String getPropertyValue(NamedElement namedElement, String prefix) {
        int index;
        String property;
        String properties = NamedElementUtil.readProperties(NamedElementUtil.getPropertiesURI(namedElement.eResource()));
        if (properties != null && (property = NamedElementUtil.parseProperties(properties).get(NamedElementUtil.getPropertyKey(namedElement, prefix))) != null && (index = property.indexOf(61)) > 0) {
            return property.substring(index + 1).trim();
        }
        return null;
    }

    public static boolean setPropertyValue(NamedElement namedElement, String prefix, String value) {
        URI uri = NamedElementUtil.getPropertiesURI(namedElement.eResource());
        String properties = NamedElementUtil.readProperties(uri);
        LinkedHashMap<String, String> parsedProperties = properties != null ? NamedElementUtil.parseProperties(properties) : new LinkedHashMap<String, String>();
        String key = NamedElementUtil.getPropertyKey(namedElement, prefix);
        String property = (String)parsedProperties.get(key);
        int index = property != null ? property.indexOf(61) : -1;
        parsedProperties.put(key, String.valueOf(index != -1 && property.indexOf(35) != -1 ? PROTECTED_STRING : "") + key + " = " + value + System.getProperty("line.separator"));
        return NamedElementUtil.writeProperties(uri, parsedProperties);
    }

    public static String removePropertyValue(NamedElement namedElement, String prefix) {
        int index;
        Map<String, String> parsedProperties;
        String property;
        URI uri = NamedElementUtil.getPropertiesURI(namedElement.eResource());
        String properties = NamedElementUtil.readProperties(uri);
        if (properties != null && (property = (parsedProperties = NamedElementUtil.parseProperties(properties)).remove(NamedElementUtil.getPropertyKey(namedElement, prefix))) != null && NamedElementUtil.writeProperties(uri, parsedProperties) && (index = property.indexOf(61)) > 0) {
            return property.substring(index + 1).trim();
        }
        return null;
    }

    public static String getLabelPropertyKey(NamedElement namedElement) {
        String value = NamedElementUtil.getPropertyKey(namedElement, "label");
        return value == null ? namedElement.getName() : value;
    }

    public static String getBusinessName(NamedElement namedElement) {
        String value = NamedElementUtil.getPropertyValue(namedElement, "label");
        return value == null ? namedElement.getName() : value;
    }

    public static String getElementName(NamedElement namedElement) {
        String value = NamedElementUtil.getPropertyValue(namedElement, "name");
        return value == null ? namedElement.getName() : value;
    }

    public static String removeBusinessName(NamedElement namedElement) {
        return NamedElementUtil.removePropertyValue(namedElement, "label");
    }

    public static boolean setElementName(NamedElement namedElement, String name) {
        return NamedElementUtil.setPropertyValue(namedElement, "name", name);
    }

    public static boolean setBusinessName(NamedElement namedElement, String businessName) {
        return NamedElementUtil.setPropertyValue(namedElement, "label", businessName);
    }
}

