/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mdht.uml.common.ui.saveable.ModelDocument;
import org.eclipse.mdht.uml.common.ui.saveable.ModelManager;
import org.eclipse.mdht.uml.ui.navigator.UMLAbstractNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.internal.UMLNavigatorGroup;
import org.eclipse.mdht.uml.ui.navigator.internal.l10n.Messages;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Logger;
import org.eclipse.mdht.uml.ui.navigator.internal.providers.NavigatorUMLItemProviderAdapterFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.resource.UML22UMLResource;
import org.eclipse.uml2.uml.resource.XMI2UMLResource;

public class UMLNavigatorContentProvider
extends SaveablesProvider
implements ICommonContentProvider,
IAdaptable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private TransactionalEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryContentProvider treeContentProvider;
    private StructuredViewer viewer;
    protected boolean disposed = false;
    protected DemultiplexingListener eventListener = new DemultiplexingListener(this.getFilter()){

        protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
            UMLNavigatorContentProvider.this.update(domain, notification);
        }
    };
    private IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            Set affectedResources;
            if (!(event.getEventType() != 4 && event.getEventType() != 10 && event.getEventType() != 9 || (affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation())).isEmpty())) {
                ArrayList<ModelDocument> saveables = new ArrayList<ModelDocument>();
                for (Resource resource : affectedResources) {
                    ModelDocument saveable = ModelManager.getManager().getModelDocument(resource);
                    if (saveable == null) continue;
                    saveables.add(saveable);
                }
                UMLNavigatorContentProvider.this.fireSaveablesDirtyChanged(saveables.toArray(new Saveable[0]));
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!UMLNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                            UMLNavigatorContentProvider.this.viewer.refresh();
                        }
                    }
                });
            }
        }
    };
    private ResourceSetListener resourceLoadListener = new ResourceSetListenerImpl(NotificationFilter.RESOURCE_LOADED.or(NotificationFilter.RESOURCE_UNLOADED)){

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            for (Notification notification : event.getNotifications()) {
                final Resource resource = (Resource)notification.getNotifier();
                final ModelDocument saveable = ModelManager.getManager().getModelDocument(resource);
                if (NotificationFilter.RESOURCE_LOADED.matches(notification)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (saveable != null) {
                                if (ModelManager.getManager().getChangedResources().contains(resource)) {
                                    UMLNavigatorContentProvider.this.fireSaveablesDirtyChanged(new Saveable[]{saveable});
                                } else {
                                    UMLNavigatorContentProvider.this.fireSaveablesOpened(new Saveable[]{saveable});
                                }
                                IFile file = saveable.getFile();
                                if (file != null) {
                                    try {
                                        file.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                    catch (CoreException coreException) {
                                        // empty catch block
                                    }
                                    UMLNavigatorContentProvider.this.viewer.refresh((Object)file, true);
                                }
                            }
                        }
                    });
                    continue;
                }
                if (!NotificationFilter.RESOURCE_UNLOADED.matches(notification)) continue;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (saveable != null && !ModelManager.getManager().getChangedResources().contains(resource)) {
                            UMLNavigatorContentProvider.this.fireSaveablesClosed(new Saveable[]{saveable});
                        }
                        if (!UMLNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                            UMLNavigatorContentProvider.this.viewer.refresh();
                        }
                    }
                });
            }
        }
    };

    public UMLNavigatorContentProvider() {
        this.editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        if (this.editingDomain instanceof AdapterFactoryEditingDomain && ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap() == null) {
            ((AdapterFactoryEditingDomain)this.editingDomain).setResourceToReadOnlyMap(new Hashtable());
        }
        ModelManager.getManager().manage(this.editingDomain);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("uml2", UML22UMLResource.Factory.INSTANCE);
        extensionToFactoryMap.put("xmi", XMI2UMLResource.Factory.INSTANCE);
        this.adapterFactory = this.createAdapterFactory();
        this.treeContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
        this.editingDomain.addResourceSetListener((ResourceSetListener)this.getEventListener());
        this.editingDomain.addResourceSetListener(this.resourceLoadListener);
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
        try {
            this.loadUMLProfiles();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new NavigatorUMLItemProviderAdapterFactory());
        return this.adapterFactory;
    }

    protected void loadUMLProfiles() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        String umlLibURI = "pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml";
        try {
            resourceSet.getResource(URI.createURI((String)umlLibURI), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IOperationHistory getOperationHistory() {
        return ((IWorkspaceCommandStack)this.editingDomain.getCommandStack()).getOperationHistory();
    }

    public void dispose() {
        this.adapterFactory.dispose();
        this.editingDomain.removeResourceSetListener((ResourceSetListener)this.getEventListener());
        this.editingDomain.removeResourceSetListener(this.resourceLoadListener);
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        this.disposed = true;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)viewer;
        ModelManager.getManager().setShell(viewer.getControl().getShell());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!viewer.getControl().isDisposed()) {
                    viewer.refresh();
                }
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            Resource resource = ModelManager.getManager().getResource((IFile)parentElement);
            if (resource != null) {
                List<UMLAbstractNavigatorItem> result = this.wrapModelElements(this.getResourceContents(resource), parentElement);
                return result.toArray();
            }
        } else if (parentElement instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)parentElement);
            if (abstractNavigatorItem instanceof UMLDomainNavigatorItem) {
                UMLDomainNavigatorItem navigatorItem = (UMLDomainNavigatorItem)abstractNavigatorItem;
                Object[] children = this.treeContentProvider.getChildren((Object)navigatorItem.getEObject());
                return this.wrapItems(children, parentElement);
            }
            if (abstractNavigatorItem instanceof UMLNavigatorGroup) {
                UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
                return group.getChildren();
            }
        }
        return EMPTY_ARRAY;
    }

    private List<EObject> getResourceContents(Resource resource) {
        ArrayList<EObject> contents = new ArrayList<EObject>();
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof Element)) continue;
            contents.add(eObject);
        }
        return contents;
    }

    public Object getParent(Object element) {
        if (element instanceof UMLDomainNavigatorItem) {
            UMLDomainNavigatorItem abstractNavigatorItem = (UMLDomainNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            return ModelManager.getManager().getModelDocument((IFile)element) != null;
        }
        return this.getChildren(element).length > 0;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    protected void doInit() {
        super.doInit();
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public Object getAdapter(Class adapter) {
        if (SaveablesProvider.class == adapter) {
            return this;
        }
        return null;
    }

    public Object[] getElements(Saveable saveable) {
        IFile file;
        if (saveable instanceof ModelDocument && (file = ((ModelDocument)saveable).getFile()) != null) {
            return new Object[]{file};
        }
        return EMPTY_ARRAY;
    }

    public Saveable getSaveable(Object element) {
        EObject eObject = null;
        if (element instanceof EObject) {
            eObject = (EObject)element;
        } else if (element instanceof IAdaptable) {
            eObject = (EObject)((IAdaptable)element).getAdapter(EObject.class);
        }
        ModelDocument saveable = null;
        if (eObject != null) {
            Resource resource = eObject.eResource();
            saveable = ModelManager.getManager().getModelDocument(resource);
        } else if (element instanceof Resource) {
            saveable = ModelManager.getManager().getModelDocument((Resource)element);
        }
        return saveable;
    }

    public Saveable[] getSaveables() {
        Collection saveables = ModelManager.getManager().getDocuments();
        Saveable[] array = new Saveable[saveables.size()];
        saveables.toArray(array);
        return array;
    }

    private List<UMLAbstractNavigatorItem> wrapModelElements(List<EObject> items, Object parentElement) {
        ArrayList<UMLAbstractNavigatorItem> wrappedItems = new ArrayList<UMLAbstractNavigatorItem>();
        for (EObject item : items) {
            if (!(item instanceof Element)) continue;
            wrappedItems.add(new UMLDomainNavigatorItem(item, parentElement, this.treeContentProvider));
        }
        return wrappedItems;
    }

    private UMLAbstractNavigatorItem[] wrapItems(Object[] items, Object parentElement) {
        UMLNavigatorGroup group;
        ArrayList<UMLAbstractNavigatorItem> wrappedItems = new ArrayList<UMLAbstractNavigatorItem>();
        if (parentElement instanceof UMLDomainNavigatorItem && ((UMLDomainNavigatorItem)((Object)parentElement)).getEObject() instanceof Package && (group = this.getAssociations((Package)((UMLDomainNavigatorItem)((Object)parentElement)).getEObject(), parentElement)) != null) {
            wrappedItems.add(group);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof Element && !(items[i] instanceof Association)) {
                wrappedItems.add(new UMLDomainNavigatorItem((EObject)((Element)items[i]), parentElement, this.treeContentProvider));
            }
            ++i;
        }
        return wrappedItems.toArray(new UMLAbstractNavigatorItem[wrappedItems.size()]);
    }

    private UMLNavigatorGroup getAssociations(Package umlPackage, Object parentElement) {
        UMLNavigatorGroup group = null;
        ArrayList<EObject> associations = new ArrayList<EObject>();
        for (NamedElement element : umlPackage.getOwnedMembers()) {
            if (!(element instanceof Association)) continue;
            associations.add((EObject)element);
        }
        if (!associations.isEmpty()) {
            group = new UMLNavigatorGroup(Messages.NavigatorGroupName_associations, "icons/associationsNavigatorGroup.gif", parentElement);
            group.addChildren(this.wrapModelElements(associations, (Object)group));
        }
        return group;
    }

    protected DemultiplexingListener getEventListener() {
        return this.eventListener;
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.NOT_TOUCH;
    }

    public void update(final Notification notification, final EObject element) {
        if (!this.isDisposed() && !this.isNotifierDeleted(notification)) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!(UMLNavigatorContentProvider.this.isDisposed() || UMLNavigatorContentProvider.this.viewer.getControl().isDisposed() || UMLNavigatorContentProvider.this.isNotifierDeleted(notification))) {
                        try {
                            if (element instanceof Element) {
                                UMLNavigatorContentProvider.this.viewer.refresh((Object)new UMLDomainNavigatorItem(element, null, UMLNavigatorContentProvider.this.treeContentProvider));
                            } else {
                                UMLNavigatorContentProvider.this.viewer.refresh((Object)element);
                            }
                        }
                        catch (SWTException sWTException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    protected void update(TransactionalEditingDomain domain, Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            this.update(notification, (EObject)notifier);
        } else if (notifier instanceof Resource && 3 == notification.getFeatureID(null)) {
            ModelDocument saveable = ModelManager.getManager().getModelDocument((Resource)notifier);
            if (saveable != null) {
                this.fireSaveablesDirtyChanged(new Saveable[]{saveable});
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (UMLNavigatorContentProvider.this.viewer != null && !UMLNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                        UMLNavigatorContentProvider.this.viewer.refresh();
                    }
                }
            });
        }
    }

    protected boolean isNotifierDeleted(Notification notification) {
        if (!(notification.getNotifier() instanceof EObject)) {
            return false;
        }
        EObject obj = (EObject)notification.getNotifier();
        return obj.eResource() == null;
    }

    protected void postUpdateRequest(Runnable updateRequest) {
        Display.getDefault().syncExec(updateRequest);
    }

    public void handleElementModifiedEvent(Notification notification, EObject element) {
        this.update(notification, element);
    }
}

