/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation.table;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import traceability.presentation.table.TraceabilityViewer;
import traceability.presentation.table.TraceabilityViewerLabelProvider;

public class TraceabilityToolTipSupport
extends ColumnViewerToolTipSupport {
    protected TraceabilityToolTipSupport(ColumnViewer viewer, int style, boolean manualActivation) {
        super(viewer, style, manualActivation);
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
        TraceabilityViewer viewer = (TraceabilityViewer)((Object)((TreeItem)cell.getItem()).getParent().getParent().getData());
        XViewerColumn xCol = viewer.getXTreeColumn(cell.getColumnIndex());
        Image image = this.getImage(event);
        Image bgImage = this.getBackgroundImage(event);
        String text = this.getText(event);
        Color fgColor = this.getForegroundColor(event);
        Color bgColor = this.getBackgroundColor(event);
        Font font = this.getFont(event);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginBottom = 0;
        gl.marginTop = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.verticalSpacing = 1;
        comp.setLayout((Layout)gl);
        Composite topArea = new Composite(comp, 0);
        topArea.setLayoutData((Object)new GridData(4, 4, true, false));
        gl = new GridLayout(2, false);
        gl.marginBottom = 2;
        gl.marginTop = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 5;
        gl.marginRight = 2;
        topArea.setLayout((Layout)gl);
        if (image != null) {
            Composite iconComp = new Composite(topArea, 0);
            iconComp.setLayoutData((Object)new GridData());
            iconComp.setLayout((Layout)new GridLayout(2, false));
            gl = new GridLayout(2, false);
            gl.marginBottom = 0;
            gl.marginTop = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.marginLeft = 0;
            gl.marginRight = 0;
            iconComp.setLayout((Layout)gl);
            Label icon = new Label(iconComp, 0);
            icon.setImage(image);
            icon.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                }
            });
        }
        Label l = new Label(topArea, 0);
        l.setText(xCol.getName());
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ScrolledComposite sc1 = new ScrolledComposite(comp, 2816);
        sc1.setExpandHorizontal(true);
        sc1.setExpandVertical(true);
        StyledText label = new StyledText((Composite)sc1, 0);
        sc1.setContent((Control)label);
        if (text != null && TraceabilityViewer.getRedirectedElement(cell.getElement()) instanceof EObject) {
            StyledString ss = TraceabilityViewerLabelProvider.getStyledString(text, false);
            label.setText(ss.getString());
            label.setStyleRanges(ss.getStyleRanges());
        }
        if (fgColor != null) {
            label.setForeground(fgColor);
        }
        if (bgColor != null) {
            label.setBackground(bgColor);
        }
        if (bgImage != null) {
            label.setBackgroundImage(image);
        }
        if (font != null) {
            label.setFont(font);
        }
        Point p = label.computeSize(-1, -1);
        sc1.setMinSize(p);
        p.x = Math.max(Math.min(p.x, 1000), 100);
        p.y = Math.max(Math.min(p.y, 500), 0);
        GridData data = new GridData(4, 4, false, false);
        data.widthHint = p.x;
        data.heightHint = p.y;
        sc1.setLayoutData((Object)data);
        label.forceFocus();
        this.setShift(new Point(-5, -5));
        this.setHideOnMouseDown(false);
        return comp;
    }

    public static final void enableFor(ColumnViewer viewer) {
        new TraceabilityToolTipSupport(viewer, 1, false);
    }
}

