/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.internal.impl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.mdht.uml.validation.ConstraintProvider;
import org.eclipse.mdht.uml.validation.Diagnostic;
import org.eclipse.mdht.uml.validation.EvaluationModeKind;
import org.eclipse.mdht.uml.validation.SeverityKind;
import org.eclipse.mdht.uml.validation.ValidationFactory;
import org.eclipse.mdht.uml.validation.ValidationPackage;
import org.eclipse.mdht.uml.validation.internal.impl.ConstraintProviderImpl;
import org.eclipse.mdht.uml.validation.internal.impl.DiagnosticImpl;

public class ValidationFactoryImpl
extends EFactoryImpl
implements ValidationFactory {
    public static ValidationFactory init() {
        try {
            ValidationFactory theValidationFactory = (ValidationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.openhealthtools.org/mdht/schema/profile/validation/1.0.0");
            if (theValidationFactory != null) {
                return theValidationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ValidationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDiagnostic();
            }
            case 1: {
                return this.createConstraintProvider();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createEvaluationModeKindFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createSeverityKindFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createStatusFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createValidationContextFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertEvaluationModeKindToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertSeverityKindToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertStatusToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertValidationContextToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Diagnostic createDiagnostic() {
        DiagnosticImpl diagnostic = new DiagnosticImpl();
        return diagnostic;
    }

    @Override
    public ConstraintProvider createConstraintProvider() {
        ConstraintProviderImpl constraintProvider = new ConstraintProviderImpl();
        return constraintProvider;
    }

    public EvaluationModeKind createEvaluationModeKindFromString(EDataType eDataType, String initialValue) {
        EvaluationModeKind result = EvaluationModeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertEvaluationModeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public SeverityKind createSeverityKindFromString(EDataType eDataType, String initialValue) {
        SeverityKind result = SeverityKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSeverityKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public IStatus createStatusFromString(EDataType eDataType, String initialValue) {
        return (IStatus)super.createFromString(eDataType, initialValue);
    }

    public String convertStatusToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IValidationContext createValidationContextFromString(EDataType eDataType, String initialValue) {
        return (IValidationContext)super.createFromString(eDataType, initialValue);
    }

    public String convertValidationContextToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ValidationPackage getValidationPackage() {
        return (ValidationPackage)this.getEPackage();
    }

    @Deprecated
    public static ValidationPackage getPackage() {
        return ValidationPackage.eINSTANCE;
    }
}

