/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintProvider;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.mdht.uml.validation.ConstraintProvider;
import org.eclipse.mdht.uml.validation.Diagnostic;
import org.eclipse.mdht.uml.validation.internal.provider.ProfileConstraintDescriptor;
import org.eclipse.mdht.uml.validation.internal.provider.ValidationProfileUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProfileConstraintProvider
extends AbstractConstraintProvider {
    private ConstraintCache currentCache = ConstraintCache.NULL;

    public Collection<IModelConstraint> getBatchConstraints(EObject eObject, Collection<IModelConstraint> constraints) {
        this.initCache(eObject);
        return super.getBatchConstraints(eObject, constraints);
    }

    public Collection<IModelConstraint> getLiveConstraints(Notification notification, Collection<IModelConstraint> constraints) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            this.initCache((EObject)notifier);
        }
        return super.getLiveConstraints(notification, constraints);
    }

    private void initCache(EObject eObject) {
        if (eObject instanceof Element) {
            this.discoverConstraints((Element)eObject);
        } else {
            this.currentCache = ConstraintCache.NULL;
        }
    }

    private void discoverConstraints(Element element) {
        Package context = element.getNearestPackage();
        Package parent = context != null ? context.getNestingPackage() : null;
        while (parent != null) {
            context = parent;
            parent = context.getNestingPackage();
        }
        this.currentCache = context != null ? ConstraintCache.get(context, this) : ConstraintCache.NULL;
    }

    protected List<IModelConstraint> getConstraints() {
        return this.currentCache.getConstraints();
    }

    List<IModelConstraint> createConstraints(Package context) {
        ArrayList<IModelConstraint> result = new ArrayList<IModelConstraint>();
        for (Profile profile : ValidationProfileUtil.getValidatingProfiles(context)) {
            String bundleName = ValidationProfileUtil.getBundleName(profile);
            ConstraintProvider provider = ValidationProfileUtil.getConstraintProvider((Namespace)profile);
            if (bundleName == null || provider == null) continue;
            this.collectModelConstraints((Collection<? super IModelConstraint>)result, bundleName, (Iterable<? extends Diagnostic>)provider.getDiagnostics());
        }
        return result;
    }

    private void collectModelConstraints(Collection<? super IModelConstraint> collection, String bundleName, Iterable<? extends Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            IModelConstraint modelConstraint = this.createModelConstraint(bundleName, diagnostic);
            if (modelConstraint == null) continue;
            collection.add((IModelConstraint)modelConstraint);
        }
    }

    IModelConstraint createModelConstraint(String bundleName, Diagnostic diagnostic) {
        IModelConstraint result = ConstraintFactory.getInstance().newConstraint((IConstraintDescriptor)new ProfileConstraintDescriptor(bundleName, diagnostic));
        Stereotype stereotypeContext = this.getStereotypeContext(diagnostic);
        if (stereotypeContext != null) {
            result = this.stereotypeCast(result, stereotypeContext);
        }
        return result;
    }

    private Stereotype getStereotypeContext(Diagnostic diagnostic) {
        Stereotype result = null;
        Namespace context = diagnostic.getBase_Constraint().getContext();
        if (context instanceof Stereotype) {
            result = (Stereotype)context;
        }
        return result;
    }

    private IModelConstraint stereotypeCast(IModelConstraint constraint, Stereotype stereotype) {
        return new StereotypeCastingConstraintWrapper(constraint, stereotype);
    }

    private static class ConstraintCache
    extends AdapterImpl {
        static final ConstraintCache NULL = new ConstraintCache();
        private final List<IModelConstraint> constraints;

        ConstraintCache() {
            this.constraints = Collections.emptyList();
        }

        ConstraintCache(Package context, ProfileConstraintProvider provider) {
            this.constraints = provider.createConstraints(context);
            context.eAdapters().add((Object)this);
        }

        List<IModelConstraint> getConstraints() {
            return this.constraints;
        }

        public boolean isAdapterForType(Object type) {
            return type == ProfileConstraintProvider.class;
        }

        static ConstraintCache get(Package context, ProfileConstraintProvider provider) {
            ConstraintCache result = (ConstraintCache)EcoreUtil.getExistingAdapter((Notifier)context, ProfileConstraintProvider.class);
            if (result == null) {
                result = new ConstraintCache(context, provider);
            }
            return result;
        }
    }

    private static class StereotypeCastingConstraintWrapper
    implements IModelConstraint {
        private final IModelConstraint delegate;
        private final StereotypeCastingValidationContextWrapper contextWrapper;

        StereotypeCastingConstraintWrapper(IModelConstraint constraint, Stereotype stereotype) {
            this.delegate = constraint;
            this.contextWrapper = new StereotypeCastingValidationContextWrapper(stereotype);
        }

        public IConstraintDescriptor getDescriptor() {
            return this.delegate.getDescriptor();
        }

        public IStatus validate(IValidationContext ctx) {
            this.contextWrapper.setDelegate(ctx);
            return this.delegate.validate((IValidationContext)this.contextWrapper);
        }
    }

    private static class StereotypeCastingValidationContextWrapper
    implements IValidationContext {
        private final Stereotype stereotype;
        private IValidationContext delegate;

        StereotypeCastingValidationContextWrapper(Stereotype stereotype) {
            this.stereotype = stereotype;
        }

        void setDelegate(IValidationContext ctx) {
            this.delegate = ctx;
        }

        public EObject getTarget() {
            EList applied;
            Element element;
            Element result = element = (Element)this.delegate.getTarget();
            EObject application = element.getStereotypeApplication(this.stereotype);
            if (application == null && !(applied = element.getAppliedSubstereotypes(this.stereotype)).isEmpty()) {
                application = element.getStereotypeApplication((Stereotype)applied.get(0));
            }
            if (application != null) {
                result = application;
            }
            return result;
        }

        public void addResult(EObject eObject) {
            this.delegate.addResult(this.asElement(eObject));
        }

        public void addResults(Collection<? extends EObject> eObjects) {
            for (EObject eObject : eObjects) {
                this.addResult(eObject);
            }
        }

        public IStatus createFailureStatus(Object ... messageArgument) {
            Object[] args = new Object[messageArgument.length];
            int i = 0;
            while (i < messageArgument.length) {
                args[i] = messageArgument[i] instanceof EObject ? this.asElement((EObject)messageArgument[i]) : messageArgument[i];
                ++i;
            }
            return this.delegate.createFailureStatus(args);
        }

        public void skipCurrentConstraintFor(EObject eObject) {
            this.delegate.skipCurrentConstraintFor(this.asElement(eObject));
        }

        public void skipCurrentConstraintForAll(Collection<?> eObjects) {
            ArrayList<Object> toSkip = new ArrayList<Object>(eObjects.size());
            for (Object next : eObjects) {
                if (next instanceof EObject) {
                    toSkip.add(this.asElement((EObject)next));
                    continue;
                }
                toSkip.add(next);
            }
            this.delegate.skipCurrentConstraintForAll(toSkip);
        }

        private EObject asElement(EObject eObject) {
            Element element;
            EObject result = eObject;
            if (!(eObject instanceof Element) && (element = UMLUtil.getBaseElement((EObject)eObject)) != null) {
                result = element;
            }
            return result;
        }

        public String getCurrentConstraintId() {
            return this.delegate.getCurrentConstraintId();
        }

        public EMFEventType getEventType() {
            return this.delegate.getEventType();
        }

        public List<Notification> getAllEvents() {
            return this.delegate.getAllEvents();
        }

        public EStructuralFeature getFeature() {
            return this.delegate.getFeature();
        }

        public Object getFeatureNewValue() {
            return this.delegate.getFeatureNewValue();
        }

        public void disableCurrentConstraint(Throwable exception) {
            this.delegate.disableCurrentConstraint(exception);
        }

        public Object getCurrentConstraintData() {
            return this.delegate.getCurrentConstraintData();
        }

        public Object putCurrentConstraintData(Object newData) {
            return this.delegate.putCurrentConstraintData(newData);
        }

        public Set<EObject> getResultLocus() {
            return this.delegate.getResultLocus();
        }

        public IStatus createSuccessStatus() {
            return this.delegate.createSuccessStatus();
        }
    }
}

