/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.common.ui.util.EditingDomainUtil;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class UML2AbstractAction
implements IObjectActionDelegate,
IViewActionDelegate,
IEditorActionDelegate {
    protected IWorkbenchPart activePart;
    protected ISelection currentSelection;
    protected TransactionalEditingDomain editingDomain;

    public void init(IViewPart view) {
        this.activePart = view;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activePart = targetEditor;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
        this.editingDomain = EditingDomainUtil.getEditingDomain((Collection)((IStructuredSelection)selection).toList());
        action.setEnabled(this.editingDomain != null);
    }

    protected boolean isReadOnly() {
        if (this.editingDomain != null) {
            Object[] objectArray = ((IStructuredSelection)this.currentSelection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                Element element = this.getElementFromSelection(selected);
                if (element != null && this.editingDomain.isReadOnly(element.eResource())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected View getSelectedView() {
        if (this.editingDomain != null) {
            Object[] objectArray = ((IStructuredSelection)this.currentSelection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                View view = (View)((IAdaptable)selected).getAdapter(View.class);
                if (view != null) {
                    return view;
                }
                ++n2;
            }
        }
        return null;
    }

    protected List<Element> getSelectedElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        Object[] objectArray = ((IStructuredSelection)this.currentSelection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            Element element = this.getElementFromSelection(selected);
            if (element != null) {
                elements.add(element);
            }
            ++n2;
        }
        return elements;
    }

    protected Element getSelectedElement() {
        Object[] objectArray = ((IStructuredSelection)this.currentSelection).toArray();
        if (objectArray.length != 0) {
            Object selected = objectArray[0];
            return this.getElementFromSelection(selected);
        }
        return null;
    }

    private Element getElementFromSelection(Object selection) {
        Element element = null;
        EObject eObject = null;
        if (selection instanceof IAdaptable) {
            eObject = (EObject)((IAdaptable)selection).getAdapter(View.class);
            if (eObject == null) {
                eObject = (EObject)((IAdaptable)selection).getAdapter(EObject.class);
            }
        } else if (selection instanceof EObject) {
            eObject = (EObject)selection;
        }
        if (View.class.isInstance(eObject)) {
            eObject = ((View)eObject).getElement();
        }
        if (Element.class.isInstance(eObject)) {
            element = (Element)eObject;
        }
        return element;
    }

    protected String getUniqueMemberName(Classifier owner, String name) {
        int seqNo = 2;
        String uniqueName = name;
        while (owner.getOwnedMember(uniqueName, false, UMLPackage.eINSTANCE.getProperty()) != null) {
            uniqueName = String.valueOf(name) + String.valueOf(seqNo++);
        }
        return uniqueName;
    }

    protected String getUniqueTypeName(Package owner, String name) {
        String uniqueName;
        int seqNo = 1;
        while (owner.getOwnedType(uniqueName = String.valueOf(name) + String.valueOf(seqNo++)) != null) {
        }
        return uniqueName;
    }

    protected String getUniqueTypeName(Class owner, String name) {
        String uniqueName;
        int seqNo = 1;
        while (owner.getNestedClassifier(uniqueName = String.valueOf(name) + String.valueOf(seqNo++)) != null) {
        }
        return uniqueName;
    }

    protected String getUniquePackageName(Package owner, String name) {
        String uniqueName;
        int seqNo = 1;
        while (owner.getNestedPackage(uniqueName = String.valueOf(name) + String.valueOf(seqNo++)) != null) {
        }
        return uniqueName;
    }
}

