/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transformation.ocl2xpath;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.mdht.transformation.ocl.OCLTransformation;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.uml.PropertyCallExp;

public abstract class OCL2XPathTransformation<PK, C, O extends EModelElement, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends OCLTransformation<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    public String transform(OCLExpression<C> exp) {
        if (exp instanceof OperationCallExp) {
            OperationCallExp op = (OperationCallExp)exp;
            String opName = this.getName(op.getReferredOperation());
            String domainSpecific = this.transformDomainSpecific(op, opName);
            if (domainSpecific != null) {
                return domainSpecific;
            }
            if ("matches".equals(opName)) {
                return this.step(this.transform(op.getSource()), "attribute::node()[name() = " + this.transform((OCLExpression)op.getArgument().get(0)) + " and matches(string(.)," + this.transform((OCLExpression)op.getArgument().get(1)) + ")]");
            }
            if ("substring".equals(opName)) {
                return "substring(" + this.transform(op.getSource()) + "," + this.transform((OCLExpression)op.getArgument().get(0)) + "," + this.transform((OCLExpression)op.getArgument().get(1)) + "-" + this.transform((OCLExpression)op.getArgument().get(0)) + ")";
            }
            if ("size".equals(opName)) {
                if ("String".equals(this.getName(op.getSource().getType()))) {
                    return "string-length(" + this.transform(op.getSource()) + ")";
                }
                return "count(" + this.transform(op.getSource()) + ")";
            }
            if ("excluding".equals(opName)) {
                return this.predicate(this.transform(op.getSource()), ". != " + this.transform((OCLExpression)op.getArgument().get(0)));
            }
            if ("first".equals(opName) || "last".equals(opName)) {
                return this.predicate(this.transform(op.getSource()), String.valueOf(opName) + "()");
            }
            if ("at".equals(opName)) {
                return this.predicate(this.transform(op.getSource()), this.transform((OCLExpression)op.getArgument().get(0)));
            }
        }
        if (exp instanceof EnumLiteralExp) {
            EnumLiteralExp enumLiteralExp = (EnumLiteralExp)exp;
            return "\"" + this.getName(enumLiteralExp.getReferredEnumLiteral()) + "\"";
        }
        if (exp instanceof IfExp) {
            IfExp ifExp = (IfExp)exp;
            String condition = this.transform(ifExp.getCondition());
            return "(" + this.predicate(this.transform(ifExp.getThenExpression()), condition) + " | " + this.predicate(this.transform(ifExp.getElseExpression()), this.not(condition)) + ")";
        }
        if (exp instanceof NullLiteralExp) {
            return "false()";
        }
        if (exp instanceof BooleanLiteralExp) {
            OperationCallExp op;
            String opName;
            BooleanLiteralExp booleanLiteralExp = (BooleanLiteralExp)exp;
            if (exp.eContainer() instanceof OperationCallExp && ("=".equals(opName = this.getName((op = (OperationCallExp)exp.eContainer()).getReferredOperation())) || "<>".equals(opName))) {
                OCLExpression otherArg;
                OCLExpression oCLExpression = otherArg = op.getSource() == exp ? (OCLExpression)op.getArgument().get(0) : op.getSource();
                if (otherArg instanceof PropertyCallExp && "Boolean".equals(this.getName(otherArg.getType()))) {
                    return "'" + booleanLiteralExp.getBooleanSymbol().toString() + "'";
                }
            }
        }
        return super.transform(exp);
    }

    public String newVar() {
        return this.selfNode();
    }

    public String iterator(String body, String i, String n, String source) {
        String predicate = "forAll".equals(n) || "reject".equals(n) ? this.not(body) : body;
        String result = "collect".equals(n) || "exists".equals(n) & body.startsWith("@root = \"") ? this.step(source, predicate) : this.predicate(source, predicate);
        if ("one".equals(n)) {
            return "count(" + result + ")=1";
        }
        if ("forAll".equals(n)) {
            return this.not(result);
        }
        return result;
    }

    protected String op(String operator) {
        if ("<>".equals(operator)) {
            return "!=";
        }
        if ("and".equals(operator)) {
            return " and ";
        }
        if ("or".equals(operator)) {
            return " or ";
        }
        if ("xor".equals(operator)) {
            return " or ";
        }
        return operator;
    }

    public String isEmpty(String set) {
        return this.not(set);
    }

    public String isNotEmpty(String set) {
        return set;
    }

    protected String predicate(String set, String predicate) {
        if (".".equals(set)) {
            return predicate;
        }
        return String.valueOf(set) + "[" + predicate + "]";
    }

    public String step(String set, String property) {
        if (".".equals(set)) {
            return property;
        }
        return String.valueOf(set) + "/" + property;
    }

    public String cosmetics(String result) {
        result = result.replace("true() and ", "");
        result = result.replace(" and true()", "");
        result = result.replace("[. and ", "[");
        result = result.replace("[true()]", "");
        result = result.replace("[.]", "");
        result = result.replace("/.[", "[");
        return result;
    }

    protected String selfNode() {
        return ".";
    }

    public String nsPrefix(String elementName) {
        return "cda:" + elementName;
    }

    public String childNode(String step) {
        return String.valueOf(step) + "/child::node()";
    }

    public String compare(String operator, String lhs, String rhs) {
        if ("<>".equals(operator)) {
            return this.not(super.compare("=", lhs, rhs));
        }
        return super.compare(operator, lhs, rhs);
    }

    public String deepEqual(String operator, String lhs, String rhs) {
        return "deep-equal(" + lhs + "," + rhs + ")";
    }

    public String referVar(String variable) {
        return this.selfNode();
    }

    public String instanceOf(String object, String type) {
        return this.predicate(object, "@xsi:type=\"" + type + "\"");
    }

    public String typeof(String typeName) {
        return "\"" + typeName + "\"";
    }

    public String contains(String set, String item) {
        return String.valueOf(set) + "=" + item;
    }
}

