/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.emf.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.mft.emf.core.DomainModelContextStructureBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmfStructureBridge
extends DomainModelContextStructureBridge {
    @Override
    public String getDomainHandleIdentifier(Object object) {
        return EmfStructureBridge.getGenericDomainHandleIdentifier(object, this.parentContentType);
    }

    public static String getGenericDomainHandleIdentifier(Object object, String parentContentType) {
        if (object instanceof EObject) {
            EObject eobject = (EObject)object;
            URI uri = EcoreUtil.getURI((EObject)eobject);
            return uri.toString();
        }
        return null;
    }

    @Override
    public String getHandleIdentifier(Object object) {
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            URI uri = resource.getResourceSet().getURIConverter().normalize(resource.getURI());
            return uri.toString();
        }
        return super.getHandleIdentifier(object);
    }

    @Override
    public boolean acceptsObject(Object object) {
        return this.getDomainObject(object) != null;
    }

    @Override
    public Object getObjectForHandle(String handle) {
        if (this.isDocument(handle)) {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            Object objectForHandle = parentBridge.getObjectForHandle(handle);
            if (objectForHandle instanceof IFile) {
                IFile file = (IFile)objectForHandle;
                ResourceSet rs = this.getDomainObjectResourceSet();
                URI createFileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                Resource createResource = rs.getResource(createFileURI, true);
                return createResource;
            }
            return null;
        }
        return super.getObjectForHandle(handle);
    }

    @Override
    public Object getDomainObjectForHandle(String handle) {
        URI uri = URI.createURI((String)handle);
        ResourceSet resourceSet = this.getDomainObjectResourceSet();
        try {
            if (!uri.hasFragment()) {
                Resource resource = resourceSet.getResource(uri, true);
                return resource;
            }
            EObject eObject = resourceSet.getEObject(uri, true);
            if (eObject != null) {
                return eObject;
            }
        }
        catch (WrappedException wrappedException) {}
        return null;
    }

    protected ResourceSet getDomainObjectResourceSet() {
        return new ResourceSetImpl();
    }

    public List<String> getChildHandles(String handle) {
        Object domainObject = this.getObjectForHandle(handle);
        if (domainObject instanceof EObject) {
            ArrayList<String> childHandles = new ArrayList<String>();
            EObject eo = (EObject)domainObject;
            for (EObject child : eo.eContents()) {
                childHandles.add(this.getDomainHandleIdentifier(child));
            }
            return childHandles;
        }
        return Collections.emptyList();
    }

    public String getParentHandle(String handle) {
        Object object = this.getObjectForHandle(handle);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eContainer() != null) {
                return this.getHandleIdentifier(eObject.eContainer());
            }
            Resource resource = eObject.eResource();
            IFile file = EmfStructureBridge.getFile(resource);
            if (file != null && file.exists()) {
                AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
                return parentBridge.getHandleIdentifier((Object)file);
            }
            return this.getHandleIdentifier(resource);
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            IFile file = EmfStructureBridge.getFile(resource);
            if (file != null && file.exists()) {
                AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
                return parentBridge.getHandleIdentifier((Object)file);
            }
        } else if (object instanceof EPackage) {
            EPackage pack = (EPackage)object;
            if (pack.eContainer() == null && pack.eResource() != null) {
                return this.getDomainHandleIdentifier(pack.eContainer());
            }
        } else if (object instanceof IFile) {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            return parentBridge.getParentHandle(handle);
        }
        return null;
    }

    public static IFile getFile(Resource resource) {
        URI uri = resource.getURI();
        uri = resource.getResourceSet().getURIConverter().normalize(uri);
        String scheme = uri.scheme();
        if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(j));
                ++j;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            return file;
        }
        return null;
    }

    public EAttribute getNameFeature(Object object) {
        return EcorePackage.Literals.ENAMED_ELEMENT__NAME;
    }

    @Override
    public String getLabel(Object object) {
        if (object instanceof EObject) {
            EObject eo = (EObject)object;
            return (String)eo.eGet((EStructuralFeature)this.getNameFeature(object));
        }
        return super.getLabel(object);
    }

    @Override
    public String getContentType(String handle) {
        Object objectForHandle = this.getObjectForHandle(handle);
        if (objectForHandle instanceof Resource) {
            return this.parentContentType;
        }
        return this.getContentType();
    }

    public String[] getFileExtensions() {
        return new String[]{this.getContentType()};
    }

    public boolean isDocument(String handle) {
        if (handle == null || handle.equals("")) {
            return false;
        }
        URI uri = URI.createURI((String)handle);
        return uri.isFile() && !uri.isEmpty();
    }
}

