/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.gmf.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.emf.mft.ui.ModelingUiPlugin;
import org.eclipse.mylyn.mft.emf.core.EmfStructureBridge;
import org.eclipse.mylyn.mft.emf.ui.DiagramUiBridge;
import org.eclipse.mylyn.mft.gmf.ui.ContextDecorator;
import org.eclipse.mylyn.mft.gmf.ui.EdgeDecorator;
import org.eclipse.mylyn.mft.gmf.ui.NodeDecorator;
import org.eclipse.mylyn.mft.gmf.ui.RevealMouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ContextDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider,
IPartListener,
INotifyChangedListener {
    public static final String MYLYN_MARKER = "mylyn-marker";
    public static final String MYLYN_DETAIL = "mylyn-detail";
    public static final String MYLYN_INTERESTING = "mylyn-interesting";
    public static final String MYLYN_BORING = "mylyn-boring";
    private final Map<String, Collection<ContextDecorator>> decoratorsForModel;
    private final Map<RootEditPart, RevealMouseListener> listenerForRoot;
    private EmfStructureBridge structure;
    private boolean anyContextActive;
    private boolean enabled;
    private final AbstractContextListener contextListenerAdapter = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            ContextDecoratorProvider.this.contextChanged(event);
        }
    };
    private final Collection<RootEditPart> diagramParts;
    private final IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.context.modeling.ui.focus.enabled")) {
                ContextDecoratorProvider.this.enabled = Boolean.parseBoolean(event.getNewValue().toString());
                ContextDecoratorProvider.this.refresh();
            }
        }
    };

    public ContextDecoratorProvider() {
        ContextCore.getContextManager().addListener(this.contextListenerAdapter);
        this.decoratorsForModel = new HashMap<String, Collection<ContextDecorator>>();
        this.listenerForRoot = new HashMap<RootEditPart, RevealMouseListener>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow.getActivePage() == null) {
            activeWorkbenchWindow.addPageListener(new IPageListener(){

                public void pageOpened(IWorkbenchPage page) {
                }

                public void pageClosed(IWorkbenchPage page) {
                }

                public void pageActivated(IWorkbenchPage page) {
                    page.addPartListener((IPartListener)ContextDecoratorProvider.this);
                }
            });
        } else {
            activeWorkbenchWindow.getActivePage().addPartListener((IPartListener)this);
        }
        this.diagramParts = new HashSet<RootEditPart>();
        ModelingUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
        this.enabled = ModelingUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.modeling.ui.focus.enabled");
        this.anyContextActive = ContextCore.getContextManager().isContextActive();
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof CreateDecoratorsOperation) {
            CreateDecoratorsOperation cdo = (CreateDecoratorsOperation)operation;
            IDecoratorTarget target = cdo.getDecoratorTarget();
            IGraphicalEditPart targetPart = (IGraphicalEditPart)target.getAdapter(IGraphicalEditPart.class);
            return this.accepts(targetPart);
        }
        return false;
    }

    private boolean accepts(IGraphicalEditPart targetPart) {
        if (targetPart instanceof ConnectionEditPart) {
            ConnectionEditPart connection = (ConnectionEditPart)targetPart;
            IGraphicalEditPart connectionSource = (IGraphicalEditPart)connection.getSource();
            IGraphicalEditPart connectionTarget = (IGraphicalEditPart)connection.getTarget();
            return connectionSource != null && connectionTarget != null && this.accepts(connectionSource) && this.accepts(connectionTarget);
        }
        Object candidate = this.getStructure().getDomainObject(targetPart.getModel());
        if (candidate instanceof EObject) {
            EObject domainObject = (EObject)candidate;
            return this.getStructure().acceptsObject((Object)domainObject) && this.getDomainUIBridge().acceptsViewObject((Object)domainObject, (Object)targetPart);
        }
        return false;
    }

    public void createDecorators(IDecoratorTarget target) {
        IGraphicalEditPart targetPart = (IGraphicalEditPart)target.getAdapter(IGraphicalEditPart.class);
        if (targetPart instanceof ConnectionEditPart) {
            ConnectionEditPart connectionPart = (ConnectionEditPart)targetPart;
            EObject domainSource = (EObject)this.getStructure().getDomainObject(connectionPart.getSource().getModel());
            EObject domainTarget = (EObject)this.getStructure().getDomainObject(connectionPart.getTarget().getModel());
            EdgeDecorator edgeDecorator = new EdgeDecorator(this, target, domainSource, domainTarget);
            target.installDecorator((Object)MYLYN_DETAIL, (IDecorator)edgeDecorator);
            this.addDecorator(domainSource, edgeDecorator);
            this.addDecorator(domainTarget, edgeDecorator);
        } else {
            Object model = targetPart.getModel();
            View view = null;
            if (model instanceof View) {
                view = (View)model;
                model = view.getElement();
            }
            EObject domainObject = (EObject)this.getStructure().getDomainObject(model);
            NodeDecorator mylynDecorator = new NodeDecorator(this, target, domainObject);
            this.addDecorator(domainObject, mylynDecorator);
        }
    }

    private void addDecorator(EObject domainObject, ContextDecorator mylynDecorator) {
        String handle = this.structure.getHandleIdentifier((Object)domainObject);
        Collection<ContextDecorator> list = this.decoratorsForModel.get(handle);
        if (list == null) {
            list = new HashSet<ContextDecorator>();
            this.decoratorsForModel.put(handle, list);
        }
        list.add(mylynDecorator);
    }

    public Collection<RootEditPart> getRootEditParts() {
        return this.diagramParts;
    }

    private RootEditPart getRootEditPart(IWorkbenchPart editor) {
        if (this.getDomainUIBridge().acceptsPart(editor)) {
            if (editor instanceof DiagramEditor) {
                DiagramEditor de = (DiagramEditor)editor;
                return de.getDiagramEditPart().getRoot();
            }
            IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)editor.getAdapter(IDiagramGraphicalViewer.class);
            if (viewer != null) {
                return viewer.getRootEditPart();
            }
        }
        return null;
    }

    private IInteractionElement getRecentInteraction(EObject object) {
        return ContextCore.getContextManager().getActiveContext().get(this.getStructure().getHandleIdentifier((Object)object));
    }

    public boolean isInteresting(EObject object) {
        IInteractionElement interation = this.getRecentInteraction(object);
        return interation != null && interation.getInterest().isInteresting();
    }

    public boolean isLandmark(EObject object) {
        IInteractionElement interation = this.getRecentInteraction(object);
        return interation != null && interation.getInterest().isLandmark();
    }

    public boolean isInteresting(IGraphicalEditPart editPart) {
        Object domainObject = this.getStructure().getDomainObject(editPart.getModel());
        return domainObject instanceof EObject && this.getDomainUIBridge().acceptsViewObject(domainObject, (Object)editPart) && this.isInteresting((EObject)domainObject);
    }

    public Object getDomainObject(IGraphicalEditPart editPart) {
        return this.getStructure().getDomainObject(editPart.getModel());
    }

    public boolean isFocussed() {
        return this.enabled && this.anyContextActive;
    }

    private void deactivate(IWorkbenchPart part) {
        RootEditPart rootEditPart = this.getRootEditPart(part);
        if (rootEditPart != null) {
            this.diagramParts.remove(rootEditPart);
            for (Collection<ContextDecorator> values : this.decoratorsForModel.values()) {
                HashSet<ContextDecorator> removedDecorators = new HashSet<ContextDecorator>();
                for (ContextDecorator decorator : values) {
                    IGraphicalEditPart decoratorEditPart = (IGraphicalEditPart)decorator.getTarget().getAdapter(IGraphicalEditPart.class);
                    if (decoratorEditPart.getRoot() != rootEditPart) continue;
                    decorator.deactivate();
                    removedDecorators.add(decorator);
                }
                values.removeAll(removedDecorators);
            }
            this.listenerForRoot.remove(rootEditPart);
        }
    }

    void refresh(RootEditPart root) {
        this.diagramParts.add(root);
        RevealMouseListener revealMouseListener = this.listenerForRoot.get(root);
        if (revealMouseListener == null) {
            IFigure rootFigure = ((AbstractGraphicalEditPart)root.getViewer().getRootEditPart()).getFigure();
            revealMouseListener = new RevealMouseListener(rootFigure);
            this.listenerForRoot.put(root, revealMouseListener);
            root.getViewer().getControl().addMouseMoveListener((MouseMoveListener)revealMouseListener);
            root.getViewer().getControl().addMouseTrackListener((MouseTrackListener)revealMouseListener);
        }
        root.refresh();
    }

    void refresh(IWorkbenchPart part) {
        RootEditPart rootEditPart = this.getRootEditPart(part);
        if (rootEditPart != null) {
            this.refresh(rootEditPart);
        }
    }

    void refresh() {
        if (this.anyContextActive) {
            for (RootEditPart rootEditPart : this.getRootEditParts()) {
                this.refresh(rootEditPart);
            }
            for (Collection collection : this.decoratorsForModel.values()) {
                this.refresh(collection);
            }
        } else {
            for (Collection<ContextDecorator> collection : this.decoratorsForModel.values()) {
                for (ContextDecorator decorator : collection) {
                    decorator.deactivate();
                }
            }
            for (RootEditPart rootEditPart : this.getRootEditParts()) {
                RevealMouseListener revealMouseListener = this.listenerForRoot.get(rootEditPart);
                if (revealMouseListener != null) {
                    rootEditPart.getViewer().getControl().removeMouseMoveListener((MouseMoveListener)revealMouseListener);
                }
                rootEditPart.refresh();
            }
            this.decoratorsForModel.clear();
            this.listenerForRoot.clear();
        }
    }

    void refresh(IInteractionElement element) {
        String handleIdentifier;
        Collection<ContextDecorator> values;
        if (element == null || element.getContentType() == null) {
            return;
        }
        if (element.getContentType().equals(this.getDomainUIBridge().getContentType()) && (values = this.decoratorsForModel.get(handleIdentifier = element.getHandleIdentifier())) != null) {
            this.refresh(values);
        }
    }

    private void refresh(Collection<ContextDecorator> values) {
        for (ContextDecorator decorator : values) {
            decorator.refresh();
        }
    }

    void refresh(ContextChangeEvent event) {
        List elements = event.getElements();
        for (IInteractionElement element : elements) {
            this.refresh(element);
        }
    }

    public EmfStructureBridge getStructure() {
        if (this.structure == null) {
            this.structure = (EmfStructureBridge)ContextCore.getStructureBridge((String)this.getDomainUIBridge().getContentType());
        }
        return this.structure;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeature() == this.getStructure().getNameFeature(notification.getNotifier())) {
            EObject eo = (EObject)notification.getNotifier();
            String newHandleID = this.structure.getHandleIdentifier((Object)eo);
            String oldHandleID = newHandleID.replaceFirst(notification.getNewStringValue(), notification.getOldStringValue());
            IInteractionElement oldElement = ContextCore.getContextManager().getElement(oldHandleID);
            if (oldElement != null) {
                ContextCore.getContextManager().updateHandle(oldElement, newHandleID);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.refresh(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.refresh(part);
    }

    public void partClosed(IWorkbenchPart part) {
        this.deactivate(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (this.getDomainUIBridge().acceptsPart(part) && part instanceof IEditorPart) {
            IEditorPart ep = (IEditorPart)part;
            AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)ContextDecoratorProvider.getEditingDomain(ep);
            ComposedAdapterFactory caf = (ComposedAdapterFactory)domain.getAdapterFactory();
            caf.addListener((INotifyChangedListener)this);
        }
    }

    public static EditingDomain getEditingDomain(Object object) {
        if (object instanceof IEditingDomainProvider) {
            return ((IEditingDomainProvider)object).getEditingDomain();
        }
        if (object instanceof IAdaptable) {
            IAdaptable adapt = (IAdaptable)object;
            Object candidate = adapt.getAdapter(EditingDomain.class);
            if (candidate instanceof EditingDomain) {
                return (EditingDomain)candidate;
            }
            candidate = adapt.getAdapter(IEditingDomainProvider.class);
            if (candidate instanceof IEditingDomainProvider) {
                return ((IEditingDomainProvider)candidate).getEditingDomain();
            }
        }
        return null;
    }

    public void contextChanged(ContextChangeEvent event) {
        if (event.getEventKind() == ContextChangeEvent.ContextChangeKind.ACTIVATED) {
            this.anyContextActive = true;
            this.refresh();
        } else if (event.getEventKind() == ContextChangeEvent.ContextChangeKind.DEACTIVATED) {
            this.anyContextActive = false;
            this.refresh();
        } else {
            this.refresh(event);
        }
    }

    public RevealMouseListener getListenerForRoot(RootEditPart part) {
        return this.listenerForRoot.get(part);
    }

    public abstract DiagramUiBridge getDomainUIBridge();
}

