/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.profile;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.tck.configsources.CustomConfigProfileConfigSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class TestCustomConfigProfile
extends Arquillian {
    @Deployment
    public static WebArchive deployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"TestConfigProfileTest.war")).addClasses(new Class[]{TestCustomConfigProfile.class, ProfilePropertyBean.class, CustomConfigProfileConfigSource.class})).addAsServiceProvider(ConfigSource.class, new Class[]{CustomConfigProfileConfigSource.class})).addAsResource((Asset)new StringAsset("mp.config.profile=prod\n%dev.vehicle.name=bus\n%prod.vehicle.name=bike\n%test.vehicle.name=coach\nvehicle.name=car"), "META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testConfigProfileWithDev() {
        ProfilePropertyBean bean = (ProfilePropertyBean)CDI.current().select(ProfilePropertyBean.class, new Annotation[0]).get();
        MatcherAssert.assertThat((Object)bean.getConfigProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"van")));
        MatcherAssert.assertThat((Object)ConfigProvider.getConfig().getValue("vehicle.name", String.class), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"van")));
    }

    @Dependent
    public static class ProfilePropertyBean {
        @Inject
        @ConfigProperty(name="vehicle.name")
        private String vehicleName;

        public String getConfigProperty() {
            return this.vehicleName;
        }
    }
}

