/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver;

import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.testng.Assert;

@RequestScoped
public class CircuitBreakerClientWithTimeout {
    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=2, failureRatio=0.75, delay=50000L)
    @Timeout(value=500L)
    public String serviceWithTimeout() {
        try {
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(1000L));
            Assert.fail((String)"Thread not interrupted by timeout");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "OK";
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=2, failureRatio=0.75, delay=50000L, failOn={BulkheadException.class})
    @Timeout(value=500L)
    public String serviceWithTimeoutWithoutFailOn() {
        try {
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(1000L));
            Assert.fail((String)"Thread not interrupted by timeout");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "OK";
    }
}

