/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.config.FallbackConfigBean;
import org.eclipse.microprofile.fault.tolerance.tck.config.FallbackHandlerB;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionA;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FallbackConfigTest
extends Arquillian {
    @Inject
    private FallbackConfigBean bean;

    @Deployment
    public static WebArchive create() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset();
        config.set(FallbackConfigBean.class, "applyOnMethod", Fallback.class, "applyOn", TestConfigExceptionA.class.getCanonicalName());
        config.set(FallbackConfigBean.class, "skipOnMethod", Fallback.class, "skipOn", TestConfigExceptionA.class.getCanonicalName());
        config.set(FallbackConfigBean.class, "fallbackMethodConfig", Fallback.class, "fallbackMethod", "anotherFallback");
        config.set(FallbackConfigBean.class, "fallbackHandlerConfig", Fallback.class, "value", FallbackHandlerB.class.getName());
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftFallbackConfigTest.jar")).addPackage(FallbackConfigTest.class.getPackage())).addPackage(Packages.UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftFallbackConfigTest.war")).addAsLibraries(new Archive[]{jar});
        return war;
    }

    @Test
    public void testApplyOn() {
        Assert.assertEquals((String)"FALLBACK", (String)this.bean.applyOnMethod());
    }

    @Test
    public void testSkipOn() {
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.skipOnMethod());
    }

    @Test
    public void testFallbackMethod() {
        Assert.assertEquals((String)"ANOTHER FALLBACK", (String)this.bean.fallbackMethodConfig());
    }

    @Test
    public void testFallbackHandler() {
        Assert.assertEquals((String)"FallbackHandlerB", (String)this.bean.fallbackHandlerConfig());
    }
}

