/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.config.RetryConfigBean;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionA;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionB;
import org.eclipse.microprofile.fault.tolerance.tck.config.TestConfigExceptionB1;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryConfigTest
extends Arquillian {
    @Inject
    private RetryConfigBean bean;

    @Deployment
    public static WebArchive create() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().set(RetryConfigBean.class, "serviceMaxRetries", Retry.class, "maxRetries", "10").set(RetryConfigBean.class, "serviceMaxDuration", Retry.class, "maxDuration", "1").set(RetryConfigBean.class, "serviceMaxDuration", Retry.class, "durationUnit", "SECONDS").set(RetryConfigBean.class, "serviceDelay", Retry.class, "delay", "2000").set(RetryConfigBean.class, "serviceDelay", Retry.class, "delayUnit", "MICROS").set(RetryConfigBean.class, "serviceRetryOn", Retry.class, "retryOn", TestConfigExceptionA.class.getName() + "," + TestConfigExceptionB.class.getName()).set(RetryConfigBean.class, "serviceAbortOn", Retry.class, "abortOn", TestConfigExceptionA.class.getName() + "," + TestConfigExceptionB1.class.getName()).set(RetryConfigBean.class, "serviceJitter", Retry.class, "jitter", "1").set(RetryConfigBean.class, "serviceJitter", Retry.class, "jitterDelayUnit", "SECONDS");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetryConfig.jar")).addClasses(new Class[]{RetryConfigBean.class})).addClasses(new Class[]{TestConfigExceptionA.class, TestConfigExceptionB.class, TestConfigExceptionB1.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetryConfig.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @Test
    public void testConfigMaxRetries() {
        AtomicInteger counter = new AtomicInteger();
        Exceptions.expect(TestException.class, () -> this.bean.serviceMaxRetries(counter));
        Assert.assertEquals((int)counter.get(), (int)11);
    }

    @Test
    public void testConfigMaxDuration() {
        long startTime = System.nanoTime();
        Exceptions.expect(TestException.class, () -> this.bean.serviceMaxDuration());
        long endTime = System.nanoTime();
        Duration duration = Duration.ofNanos(endTime - startTime);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.lessThan((Comparable)Duration.ofSeconds(8L)));
    }

    @Test
    public void testConfigDelay() {
        long startTime = System.nanoTime();
        Exceptions.expect(TestException.class, () -> this.bean.serviceDelay());
        long endTime = System.nanoTime();
        Duration duration = Duration.ofNanos(endTime - startTime);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.lessThan((Comparable)Duration.ofSeconds(8L)));
    }

    @Test
    public void testConfigRetryOn() {
        AtomicInteger counter = new AtomicInteger();
        counter.set(0);
        Exceptions.expect(TestException.class, () -> this.bean.serviceRetryOn(new TestException(), counter));
        Assert.assertEquals((int)counter.get(), (int)1);
        counter.set(0);
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.serviceRetryOn(new TestConfigExceptionA(), counter));
        Assert.assertEquals((int)counter.get(), (int)2);
        counter.set(0);
        Exceptions.expect(TestConfigExceptionB.class, () -> this.bean.serviceRetryOn(new TestConfigExceptionB(), counter));
        Assert.assertEquals((int)counter.get(), (int)2);
        counter.set(0);
        Exceptions.expect(TestConfigExceptionB1.class, () -> this.bean.serviceRetryOn(new TestConfigExceptionB1(), counter));
        Assert.assertEquals((int)counter.get(), (int)2);
    }

    @Test
    public void testConfigAbortOn() {
        AtomicInteger counter = new AtomicInteger();
        counter.set(0);
        Exceptions.expect(TestException.class, () -> this.bean.serviceAbortOn(new TestException(), counter));
        Assert.assertEquals((int)counter.get(), (int)1);
        counter.set(0);
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.serviceAbortOn(new TestConfigExceptionA(), counter));
        Assert.assertEquals((int)counter.get(), (int)1);
        counter.set(0);
        Exceptions.expect(TestConfigExceptionB.class, () -> this.bean.serviceAbortOn(new TestConfigExceptionB(), counter));
        Assert.assertEquals((int)counter.get(), (int)2);
        counter.set(0);
        Exceptions.expect(TestConfigExceptionB1.class, () -> this.bean.serviceAbortOn(new TestConfigExceptionB1(), counter));
        Assert.assertEquals((int)counter.get(), (int)1);
    }

    @Test
    public void testConfigJitter() {
        Exceptions.expect(TestConfigExceptionA.class, () -> this.bean.serviceJitter());
    }
}

