/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.disableEnv;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.disableEnv.DisableAnnotationClient;
import org.eclipse.microprofile.fault.tolerance.tck.disableEnv.DisableConfigAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DisableFTEnableOnMethodTest
extends Arquillian {
    @Inject
    private DisableAnnotationClient disableClient;

    @Deployment
    public static WebArchive deploy() {
        DisableConfigAsset config = new DisableConfigAsset().enable(DisableAnnotationClient.class, "failAndRetryOnce", Retry.class).enable(DisableAnnotationClient.class, "failWithCircuitBreaker", CircuitBreaker.class).enable(DisableAnnotationClient.class, "failWithTimeout", Timeout.class).enable(DisableAnnotationClient.class, "asyncWaitThenReturn", Asynchronous.class).enable(DisableAnnotationClient.class, "failRetryOnceThenFallback", Fallback.class).enable(DisableAnnotationClient.class, "waitWithBulkhead", Bulkhead.class).disableGlobally();
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftDisableGloballyEnableMethod.jar")).addClasses(new Class[]{DisableAnnotationClient.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftDisableGloballyEnableMethod.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryEnabled() {
        Assert.assertThrows(TestException.class, () -> this.disableClient.failAndRetryOnce());
        Assert.assertEquals((int)this.disableClient.getFailAndRetryOnceCounter(), (int)2, (String)"Retry enabled - should be 2 exections");
    }

    @Test
    public void testCircuitBreaker() {
        Assert.assertThrows(TestException.class, () -> this.disableClient.failWithCircuitBreaker());
        Assert.assertThrows(CircuitBreakerOpenException.class, () -> this.disableClient.failWithCircuitBreaker());
    }

    @Test
    public void testTimeout() {
        Assert.assertThrows(TimeoutException.class, () -> this.disableClient.failWithTimeout());
    }

    @Test
    public void testAsync() throws InterruptedException, ExecutionException {
        Future<String> result = this.disableClient.asyncWaitThenReturn();
        try {
            Assert.assertFalse((boolean)result.isDone(), (String)"Returned future.isDone() expected false because Async enabled");
        }
        finally {
            result.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkhead() throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        CompletableFuture<Object> waitingFuture = new CompletableFuture<Object>();
        Future<?> result1 = executor.submit(() -> this.disableClient.waitWithBulkhead(waitingFuture));
        Future<?> result2 = executor.submit(() -> this.disableClient.waitWithBulkhead(waitingFuture));
        try {
            this.disableClient.waitForBulkheadExecutions(2);
            Assert.assertThrows(BulkheadException.class, () -> this.disableClient.waitWithBulkhead(CompletableFuture.completedFuture(null)));
        }
        finally {
            executor.shutdown();
            waitingFuture.complete(null);
            result1.get();
            result2.get();
        }
    }
}

