/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.AllMetricsBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class MetricsDisabledTest
extends Arquillian {
    @Inject
    private AllMetricsBean allMetricsBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricDisabled.war")).addClasses(new Class[]{AllMetricsBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsResource((Asset)new StringAsset("MP_Fault_Tolerance_Metrics_Enabled=false"), "META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testMetricsDisabled() throws InterruptedException, ExecutionException {
        MetricGetter m = new MetricGetter(AllMetricsBean.class, "doWork");
        m.baselineMetrics();
        this.allMetricsBean.doWork().get();
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"value returned, no retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.VALUE_RETURNED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"exception thrown, no retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max retries reached, no retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.MAX_RETRIES_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max duration reached, no retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.FALSE, MetricDefinition.RetryResult.MAX_DURATION_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"value returned after retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.VALUE_RETURNED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"exception thrown after retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max retries reached after retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.MAX_RETRIES_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max duration reached after retry", (Object)m.getRetryCalls(MetricDefinition.RetryRetried.TRUE, MetricDefinition.RetryResult.MAX_DURATION_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"timeout execution duration histogram present", (Object)m.getTimeoutExecutionDuration().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"timed out calls", (Object)m.getTimeoutCalls(MetricDefinition.TimeoutTimedOut.TRUE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"non timed out calls", (Object)m.getTimeoutCalls(MetricDefinition.TimeoutTimedOut.FALSE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker succeeded calls", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker failed calls", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker prevented calls", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker closed time", (Object)m.getCircuitBreakerState(MetricDefinition.CircuitBreakerState.CLOSED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker half open time", (Object)m.getCircuitBreakerState(MetricDefinition.CircuitBreakerState.HALF_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker open time", (Object)m.getCircuitBreakerState(MetricDefinition.CircuitBreakerState.CLOSED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead accepted calls", (Object)m.getBulkheadCalls(MetricDefinition.BulkheadResult.ACCEPTED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead rejected calls", (Object)m.getBulkheadCalls(MetricDefinition.BulkheadResult.REJECTED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead executions running present", (Object)m.getBulkheadExecutionsRunning().gauge().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"bulkhead executions running value", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead running duration histogram present", (Object)m.getBulkheadRunningDuration().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"bulkhead executions waiting present", (Object)m.getBulkheadExecutionsWaiting().gauge().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"bulkhead executions waiting value", (Object)m.getBulkheadExecutionsWaiting().value(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead queue wait time histogram present", (Object)m.getBulkheadWaitingDuration().isPresent(), (Matcher)Matchers.is((Object)false));
    }
}

