/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver;

import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.faulttolerance.Retry;

@ApplicationScoped
public class RetryClientForZeroJitter {
    private long totalRetryTime = 0L;
    private long previousTime = 0L;
    private int retries = -1;

    @Retry(maxRetries=3, jitter=0L)
    public void serviceA() {
        long currentTime = System.currentTimeMillis();
        this.totalRetryTime += this.previousTime > 0L ? currentTime - this.previousTime : 0L;
        this.previousTime = currentTime;
        if (++this.retries == 3) {
            return;
        }
        throw new RuntimeException();
    }

    public int getRetries() {
        return this.retries;
    }

    public long getTotalRetryTime() {
        return this.totalRetryTime;
    }
}

