/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.util;

import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Dependent;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;

@Dependent
public class ConcurrentExecutionTracker {
    private final AtomicInteger executionCount = new AtomicInteger(0);
    private static final long WAIT_TIMEOUT = TCKConfig.getConfig().getTimeoutInMillis(3000L) * 1000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRunningExecutions(int executions) {
        AtomicInteger atomicInteger = this.executionCount;
        synchronized (atomicInteger) {
            long startTime = System.nanoTime();
            try {
                while (this.executionCount.get() != executions && System.nanoTime() - startTime < WAIT_TIMEOUT) {
                    this.executionCount.wait(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.executionCount.get() != executions) {
                throw new RuntimeException("Timed out waiting for executions to start, expected " + executions + " but there were " + this.executionCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executionStarted() {
        AtomicInteger atomicInteger = this.executionCount;
        synchronized (atomicInteger) {
            this.executionCount.incrementAndGet();
            this.executionCount.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executionEnded() {
        AtomicInteger atomicInteger = this.executionCount;
        synchronized (atomicInteger) {
            this.executionCount.decrementAndGet();
            this.executionCount.notifyAll();
        }
    }
}

